/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.limits.LimitsAsync;
import com.oracle.bmc.limits.model.LimitDefinitionSummary;
import com.oracle.bmc.limits.model.LimitValueSummary;
import com.oracle.bmc.limits.model.ResourceAvailability;
import com.oracle.bmc.limits.model.ServiceSummary;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitsAsyncClient
extends BaseAsyncClient
implements LimitsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LIMITS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(LimitsAsyncClient.class);

    private LimitsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetResourceAvailabilityResponse> getResourceAvailability(GetResourceAvailabilityRequest request, AsyncHandler<GetResourceAvailabilityRequest, GetResourceAvailabilityResponse> handler) {
        Validate.notBlank((String)request.getServiceName(), (String)"serviceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getLimitName(), (String)"limitName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetResourceAvailabilityResponse::builder).logger(LOG, "getResourceAvailability").serviceDetails("Limits", "GetResourceAvailability", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/ResourceAvailability/GetResourceAvailability").method(Method.GET).requestBuilder(GetResourceAvailabilityRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("services").appendPathParam(request.getServiceName()).appendPathParam("limits").appendPathParam(request.getLimitName()).appendPathParam("resourceAvailability").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceAvailability.class, GetResourceAvailabilityResponse.Builder::resourceAvailability).handleResponseHeaderString("opc-request-id", GetResourceAvailabilityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLimitDefinitionsResponse> listLimitDefinitions(ListLimitDefinitionsRequest request, AsyncHandler<ListLimitDefinitionsRequest, ListLimitDefinitionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListLimitDefinitionsResponse::builder).logger(LOG, "listLimitDefinitions").serviceDetails("Limits", "ListLimitDefinitions", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/LimitDefinitionSummary/ListLimitDefinitions").method(Method.GET).requestBuilder(ListLimitDefinitionsRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("limitDefinitions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("serviceName", (Object)request.getServiceName()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LimitDefinitionSummary.class, ListLimitDefinitionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLimitDefinitionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLimitDefinitionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListLimitValuesResponse> listLimitValues(ListLimitValuesRequest request, AsyncHandler<ListLimitValuesRequest, ListLimitValuesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getServiceName(), "serviceName is required");
        return this.clientCall(request, ListLimitValuesResponse::builder).logger(LOG, "listLimitValues").serviceDetails("Limits", "ListLimitValues", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/LimitValueSummary/ListLimitValues").method(Method.GET).requestBuilder(ListLimitValuesRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("limitValues").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("serviceName", (Object)request.getServiceName()).appendEnumQueryParam("scopeType", (BmcEnum)request.getScopeType()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(LimitValueSummary.class, ListLimitValuesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListLimitValuesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListLimitValuesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, AsyncHandler<ListServicesRequest, ListServicesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListServicesResponse::builder).logger(LOG, "listServices").serviceDetails("Limits", "ListServices", "https://docs.oracle.com/iaas/api/#/en/limits/20181025/ServiceSummary/ListServices").method(Method.GET).requestBuilder(ListServicesRequest::builder).basePath("/").appendPathParam("20190729").appendPathParam("services").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ServiceSummary.class, ListServicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListServicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListServicesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)LimitsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(LimitsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)LimitsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)LimitsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)LimitsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)LimitsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public LimitsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)LimitsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LimitsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LimitsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new LimitsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

