/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.keymanagement.KmsVault;
import com.oracle.bmc.keymanagement.KmsVaultAsyncClient;
import com.oracle.bmc.keymanagement.KmsVaultPaginators;
import com.oracle.bmc.keymanagement.KmsVaultWaiters;
import com.oracle.bmc.keymanagement.model.Vault;
import com.oracle.bmc.keymanagement.model.VaultReplicaSummary;
import com.oracle.bmc.keymanagement.model.VaultSummary;
import com.oracle.bmc.keymanagement.model.VaultUsage;
import com.oracle.bmc.keymanagement.requests.BackupVaultRequest;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.DeleteVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultUsageRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultReplicasRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.BackupVaultResponse;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.DeleteVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultUsageResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultReplicasResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsVaultClient
extends BaseSyncClient
implements KmsVault {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSVAULT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsVaultAsyncClient.class);
    private final KmsVaultWaiters waiters;
    private final KmsVaultPaginators paginators;

    private KmsVaultClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("KmsVault-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new KmsVaultWaiters(executorService, this);
        this.paginators = new KmsVaultPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BackupVaultResponse backupVault(BackupVaultRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return (BackupVaultResponse)this.clientCall(request, BackupVaultResponse::builder).logger(LOG, "backupVault").serviceDetails("KmsVault", "BackupVault", "").method(Method.POST).requestBuilder(BackupVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("backup").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, BackupVaultResponse.Builder::vault).handleResponseHeaderString("etag", BackupVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", BackupVaultResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BackupVaultResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CancelVaultDeletionResponse cancelVaultDeletion(CancelVaultDeletionRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return (CancelVaultDeletionResponse)this.clientCall(request, CancelVaultDeletionResponse::builder).logger(LOG, "cancelVaultDeletion").serviceDetails("KmsVault", "CancelVaultDeletion", "").method(Method.POST).requestBuilder(CancelVaultDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(Vault.class, CancelVaultDeletionResponse.Builder::vault).handleResponseHeaderString("etag", CancelVaultDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelVaultDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVaultCompartmentResponse changeVaultCompartment(ChangeVaultCompartmentRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVaultCompartmentDetails(), "changeVaultCompartmentDetails is required");
        return (ChangeVaultCompartmentResponse)this.clientCall(request, ChangeVaultCompartmentResponse::builder).logger(LOG, "changeVaultCompartment").serviceDetails("KmsVault", "ChangeVaultCompartment", "").method(Method.POST).requestBuilder(ChangeVaultCompartmentRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeVaultCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeVaultCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVaultResponse createVault(CreateVaultRequest request) {
        Objects.requireNonNull(request.getCreateVaultDetails(), "createVaultDetails is required");
        return (CreateVaultResponse)this.clientCall(request, CreateVaultResponse::builder).logger(LOG, "createVault").serviceDetails("KmsVault", "CreateVault", "").method(Method.POST).requestBuilder(CreateVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, CreateVaultResponse.Builder::vault).handleResponseHeaderString("etag", CreateVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVaultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVaultReplicaResponse createVaultReplica(CreateVaultReplicaRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateVaultReplicaDetails(), "createVaultReplicaDetails is required");
        return (CreateVaultReplicaResponse)this.clientCall(request, CreateVaultReplicaResponse::builder).logger(LOG, "createVaultReplica").serviceDetails("KmsVault", "CreateVaultReplica", "").method(Method.POST).requestBuilder(CreateVaultReplicaRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("createReplica").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateVaultReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateVaultReplicaResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteVaultReplicaResponse deleteVaultReplica(DeleteVaultReplicaRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteVaultReplicaDetails(), "deleteVaultReplicaDetails is required");
        return (DeleteVaultReplicaResponse)this.clientCall(request, DeleteVaultReplicaResponse::builder).logger(LOG, "deleteVaultReplica").serviceDetails("KmsVault", "DeleteVaultReplica", "").method(Method.POST).requestBuilder(DeleteVaultReplicaRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("deleteReplica").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DeleteVaultReplicaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteVaultReplicaResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetVaultResponse getVault(GetVaultRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return (GetVaultResponse)this.clientCall(request, GetVaultResponse::builder).logger(LOG, "getVault").serviceDetails("KmsVault", "GetVault", "").method(Method.GET).requestBuilder(GetVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Vault.class, GetVaultResponse.Builder::vault).handleResponseHeaderString("etag", GetVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVaultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVaultUsageResponse getVaultUsage(GetVaultUsageRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return (GetVaultUsageResponse)this.clientCall(request, GetVaultUsageResponse::builder).logger(LOG, "getVaultUsage").serviceDetails("KmsVault", "GetVaultUsage", "").method(Method.GET).requestBuilder(GetVaultUsageRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("usage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VaultUsage.class, GetVaultUsageResponse.Builder::vaultUsage).handleResponseHeaderString("opc-request-id", GetVaultUsageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVaultReplicasResponse listVaultReplicas(ListVaultReplicasRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        return (ListVaultReplicasResponse)this.clientCall(request, ListVaultReplicasResponse::builder).logger(LOG, "listVaultReplicas").serviceDetails("KmsVault", "ListVaultReplicas", "").method(Method.GET).requestBuilder(ListVaultReplicasRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("listReplicas").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBodyList(VaultReplicaSummary.class, ListVaultReplicasResponse.Builder::items).handleResponseHeaderString("etag", ListVaultReplicasResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListVaultReplicasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVaultReplicasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVaultsResponse listVaults(ListVaultsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVaultsResponse)this.clientCall(request, ListVaultsResponse::builder).logger(LOG, "listVaults").serviceDetails("KmsVault", "ListVaults", "").method(Method.GET).requestBuilder(ListVaultsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VaultSummary.class, ListVaultsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVaultsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVaultsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RestoreVaultFromFileResponse restoreVaultFromFile(RestoreVaultFromFileRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getRestoreVaultFromFileDetails(), "restoreVaultFromFileDetails is required");
        return (RestoreVaultFromFileResponse)this.clientCall(request, RestoreVaultFromFileResponse::builder).logger(LOG, "restoreVaultFromFile").serviceDetails("KmsVault", "RestoreVaultFromFile", "").method(Method.POST).requestBuilder(RestoreVaultFromFileRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam("actions").appendPathParam("restoreFromFile").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("content-length", (Number)request.getContentLength()).appendHeader("if-match", request.getIfMatch()).appendHeader("content-md5", request.getContentMd5()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBinaryRequestBody().hasBody().handleBody(Vault.class, RestoreVaultFromFileResponse.Builder::vault).handleResponseHeaderString("etag", RestoreVaultFromFileResponse.Builder::etag).handleResponseHeaderString("opc-content-md5", RestoreVaultFromFileResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-request-id", RestoreVaultFromFileResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreVaultFromFileResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public RestoreVaultFromObjectStoreResponse restoreVaultFromObjectStore(RestoreVaultFromObjectStoreRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (RestoreVaultFromObjectStoreResponse)this.clientCall(request, RestoreVaultFromObjectStoreResponse::builder).logger(LOG, "restoreVaultFromObjectStore").serviceDetails("KmsVault", "RestoreVaultFromObjectStore", "").method(Method.POST).requestBuilder(RestoreVaultFromObjectStoreRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam("actions").appendPathParam("restoreFromObjectStore").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, RestoreVaultFromObjectStoreResponse.Builder::vault).handleResponseHeaderString("etag", RestoreVaultFromObjectStoreResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RestoreVaultFromObjectStoreResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreVaultFromObjectStoreResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ScheduleVaultDeletionResponse scheduleVaultDeletion(ScheduleVaultDeletionRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleVaultDeletionDetails(), "scheduleVaultDeletionDetails is required");
        return (ScheduleVaultDeletionResponse)this.clientCall(request, ScheduleVaultDeletionResponse::builder).logger(LOG, "scheduleVaultDeletion").serviceDetails("KmsVault", "ScheduleVaultDeletion", "").method(Method.POST).requestBuilder(ScheduleVaultDeletionRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Vault.class, ScheduleVaultDeletionResponse.Builder::vault).handleResponseHeaderString("etag", ScheduleVaultDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleVaultDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVaultResponse updateVault(UpdateVaultRequest request) {
        Validate.notBlank((String)request.getVaultId(), (String)"vaultId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVaultDetails(), "updateVaultDetails is required");
        return (UpdateVaultResponse)this.clientCall(request, UpdateVaultResponse::builder).logger(LOG, "updateVault").serviceDetails("KmsVault", "UpdateVault", "").method(Method.PUT).requestBuilder(UpdateVaultRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("vaults").appendPathParam(request.getVaultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Vault.class, UpdateVaultResponse.Builder::vault).handleResponseHeaderString("etag", UpdateVaultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVaultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public KmsVaultWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public KmsVaultPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)KmsVaultClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsVaultClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public KmsVaultClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)KmsVaultClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsVaultClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public KmsVaultClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new KmsVaultClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

