/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.keymanagement.KmsCryptoAsync;
import com.oracle.bmc.keymanagement.KmsCryptoAsyncClientBuilder;
import com.oracle.bmc.keymanagement.model.DecryptedData;
import com.oracle.bmc.keymanagement.model.EncryptedData;
import com.oracle.bmc.keymanagement.model.ExportedKeyData;
import com.oracle.bmc.keymanagement.model.GeneratedKey;
import com.oracle.bmc.keymanagement.model.SignedData;
import com.oracle.bmc.keymanagement.model.VerifiedData;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.EncryptRequest;
import com.oracle.bmc.keymanagement.requests.ExportKeyRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.requests.SignRequest;
import com.oracle.bmc.keymanagement.requests.VerifyRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.EncryptResponse;
import com.oracle.bmc.keymanagement.responses.ExportKeyResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.keymanagement.responses.SignResponse;
import com.oracle.bmc.keymanagement.responses.VerifyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsCryptoAsyncClient
extends BaseAsyncClient
implements KmsCryptoAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSCRYPTO").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(KmsCryptoAsyncClient.class);

    private KmsCryptoAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static KmsCryptoAsyncClientBuilder builder() {
        return new KmsCryptoAsyncClientBuilder(SERVICE);
    }

    @Override
    public Future<DecryptResponse> decrypt(DecryptRequest request, AsyncHandler<DecryptRequest, DecryptResponse> handler) {
        Objects.requireNonNull(request.getDecryptDataDetails(), "decryptDataDetails is required");
        return this.clientCall(request, DecryptResponse::builder).logger(LOG, "decrypt").serviceDetails("KmsCrypto", "Decrypt", "").method(Method.POST).requestBuilder(DecryptRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("decrypt").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DecryptedData.class, DecryptResponse.Builder::decryptedData).handleResponseHeaderString("opc-request-id", DecryptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EncryptResponse> encrypt(EncryptRequest request, AsyncHandler<EncryptRequest, EncryptResponse> handler) {
        Objects.requireNonNull(request.getEncryptDataDetails(), "encryptDataDetails is required");
        return this.clientCall(request, EncryptResponse::builder).logger(LOG, "encrypt").serviceDetails("KmsCrypto", "Encrypt", "").method(Method.POST).requestBuilder(EncryptRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("encrypt").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EncryptedData.class, EncryptResponse.Builder::encryptedData).handleResponseHeaderString("opc-request-id", EncryptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportKeyResponse> exportKey(ExportKeyRequest request, AsyncHandler<ExportKeyRequest, ExportKeyResponse> handler) {
        Objects.requireNonNull(request.getExportKeyDetails(), "exportKeyDetails is required");
        return this.clientCall(request, ExportKeyResponse::builder).logger(LOG, "exportKey").serviceDetails("KmsCrypto", "ExportKey", "").method(Method.POST).requestBuilder(ExportKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("exportKey").accept(new String[]{"application/json"}).hasBody().handleBody(ExportedKeyData.class, ExportKeyResponse.Builder::exportedKeyData).handleResponseHeaderString("opc-request-id", ExportKeyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateDataEncryptionKeyResponse> generateDataEncryptionKey(GenerateDataEncryptionKeyRequest request, AsyncHandler<GenerateDataEncryptionKeyRequest, GenerateDataEncryptionKeyResponse> handler) {
        Objects.requireNonNull(request.getGenerateKeyDetails(), "generateKeyDetails is required");
        return this.clientCall(request, GenerateDataEncryptionKeyResponse::builder).logger(LOG, "generateDataEncryptionKey").serviceDetails("KmsCrypto", "GenerateDataEncryptionKey", "").method(Method.POST).requestBuilder(GenerateDataEncryptionKeyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("generateDataEncryptionKey").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GeneratedKey.class, GenerateDataEncryptionKeyResponse.Builder::generatedKey).handleResponseHeaderString("opc-request-id", GenerateDataEncryptionKeyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SignResponse> sign(SignRequest request, AsyncHandler<SignRequest, SignResponse> handler) {
        Objects.requireNonNull(request.getSignDataDetails(), "signDataDetails is required");
        return this.clientCall(request, SignResponse::builder).logger(LOG, "sign").serviceDetails("KmsCrypto", "Sign", "").method(Method.POST).requestBuilder(SignRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("sign").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SignedData.class, SignResponse.Builder::signedData).handleResponseHeaderString("opc-request-id", SignResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<VerifyResponse> verify(VerifyRequest request, AsyncHandler<VerifyRequest, VerifyResponse> handler) {
        Objects.requireNonNull(request.getVerifyDataDetails(), "verifyDataDetails is required");
        return this.clientCall(request, VerifyResponse::builder).logger(LOG, "verify").serviceDetails("KmsCrypto", "Verify", "").method(Method.POST).requestBuilder(VerifyRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("verify").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VerifiedData.class, VerifyResponse.Builder::verifiedData).handleResponseHeaderString("opc-request-id", VerifyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(KmsCryptoAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(KmsCryptoAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public KmsCryptoAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)((KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }
}

