/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.ScanLibraryUsageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ScanLibraryUsageRequest
extends BmcRequest<ScanLibraryUsageDetails> {
    private String fleetId;
    private ScanLibraryUsageDetails scanLibraryUsageDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public ScanLibraryUsageDetails getScanLibraryUsageDetails() {
        return this.scanLibraryUsageDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ScanLibraryUsageDetails getBody$() {
        return this.scanLibraryUsageDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).scanLibraryUsageDetails(this.scanLibraryUsageDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",scanLibraryUsageDetails=").append(String.valueOf((Object)this.scanLibraryUsageDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScanLibraryUsageRequest)) {
            return false;
        }
        ScanLibraryUsageRequest other = (ScanLibraryUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.scanLibraryUsageDetails, (Object)other.scanLibraryUsageDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.scanLibraryUsageDetails == null ? 43 : this.scanLibraryUsageDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ScanLibraryUsageRequest, ScanLibraryUsageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private ScanLibraryUsageDetails scanLibraryUsageDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder scanLibraryUsageDetails(ScanLibraryUsageDetails scanLibraryUsageDetails) {
            this.scanLibraryUsageDetails = scanLibraryUsageDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ScanLibraryUsageRequest o) {
            this.fleetId(o.getFleetId());
            this.scanLibraryUsageDetails(o.getScanLibraryUsageDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ScanLibraryUsageRequest build() {
            ScanLibraryUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ScanLibraryUsageDetails body) {
            this.scanLibraryUsageDetails(body);
            return this;
        }

        public ScanLibraryUsageRequest buildWithoutInvocationCallback() {
            ScanLibraryUsageRequest request = new ScanLibraryUsageRequest();
            request.fleetId = this.fleetId;
            request.scanLibraryUsageDetails = this.scanLibraryUsageDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

