/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.CreateBlocklistDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBlocklistRequest
extends BmcRequest<CreateBlocklistDetails> {
    private String fleetId;
    private CreateBlocklistDetails createBlocklistDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public CreateBlocklistDetails getCreateBlocklistDetails() {
        return this.createBlocklistDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateBlocklistDetails getBody$() {
        return this.createBlocklistDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).createBlocklistDetails(this.createBlocklistDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",createBlocklistDetails=").append(String.valueOf((Object)this.createBlocklistDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBlocklistRequest)) {
            return false;
        }
        CreateBlocklistRequest other = (CreateBlocklistRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.createBlocklistDetails, (Object)other.createBlocklistDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.createBlocklistDetails == null ? 43 : this.createBlocklistDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBlocklistRequest, CreateBlocklistDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private CreateBlocklistDetails createBlocklistDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder createBlocklistDetails(CreateBlocklistDetails createBlocklistDetails) {
            this.createBlocklistDetails = createBlocklistDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBlocklistRequest o) {
            this.fleetId(o.getFleetId());
            this.createBlocklistDetails(o.getCreateBlocklistDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBlocklistRequest build() {
            CreateBlocklistRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBlocklistDetails body) {
            this.createBlocklistDetails(body);
            return this;
        }

        public CreateBlocklistRequest buildWithoutInvocationCallback() {
            CreateBlocklistRequest request = new CreateBlocklistRequest();
            request.fleetId = this.fleetId;
            request.createBlocklistDetails = this.createBlocklistDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

