/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.InstallationSite;
import com.oracle.bmc.jms.model.WorkItemStatus;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkItemSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;
    @JsonProperty(value="installationSite")
    private final InstallationSite installationSite;
    @JsonProperty(value="status")
    private final WorkItemStatus status;
    @JsonProperty(value="retryCount")
    private final Integer retryCount;
    @JsonProperty(value="timeLastUpdated")
    private final Date timeLastUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "workRequestId", "installationSite", "status", "retryCount", "timeLastUpdated"})
    public WorkItemSummary(String id, String workRequestId, InstallationSite installationSite, WorkItemStatus status, Integer retryCount, Date timeLastUpdated) {
        this.id = id;
        this.workRequestId = workRequestId;
        this.installationSite = installationSite;
        this.status = status;
        this.retryCount = retryCount;
        this.timeLastUpdated = timeLastUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public InstallationSite getInstallationSite() {
        return this.installationSite;
    }

    public WorkItemStatus getStatus() {
        return this.status;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Date getTimeLastUpdated() {
        return this.timeLastUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkItemSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(", installationSite=").append(String.valueOf((Object)this.installationSite));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", retryCount=").append(String.valueOf(this.retryCount));
        sb.append(", timeLastUpdated=").append(String.valueOf(this.timeLastUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkItemSummary)) {
            return false;
        }
        WorkItemSummary other = (WorkItemSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals((Object)this.installationSite, (Object)other.installationSite) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.retryCount, other.retryCount) && Objects.equals(this.timeLastUpdated, other.timeLastUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.installationSite == null ? 43 : this.installationSite.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.retryCount == null ? 43 : this.retryCount.hashCode());
        result = result * 59 + (this.timeLastUpdated == null ? 43 : this.timeLastUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonProperty(value="installationSite")
        private InstallationSite installationSite;
        @JsonProperty(value="status")
        private WorkItemStatus status;
        @JsonProperty(value="retryCount")
        private Integer retryCount;
        @JsonProperty(value="timeLastUpdated")
        private Date timeLastUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public Builder installationSite(InstallationSite installationSite) {
            this.installationSite = installationSite;
            this.__explicitlySet__.add("installationSite");
            return this;
        }

        public Builder status(WorkItemStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            this.__explicitlySet__.add("retryCount");
            return this;
        }

        public Builder timeLastUpdated(Date timeLastUpdated) {
            this.timeLastUpdated = timeLastUpdated;
            this.__explicitlySet__.add("timeLastUpdated");
            return this;
        }

        public WorkItemSummary build() {
            WorkItemSummary model = new WorkItemSummary(this.id, this.workRequestId, this.installationSite, this.status, this.retryCount, this.timeLastUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkItemSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("installationSite")) {
                this.installationSite(model.getInstallationSite());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("retryCount")) {
                this.retryCount(model.getRetryCount());
            }
            if (model.wasPropertyExplicitlySet("timeLastUpdated")) {
                this.timeLastUpdated(model.getTimeLastUpdated());
            }
            return this;
        }
    }
}

