/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ArtifactContentType;
import com.oracle.bmc.jms.model.JavaArtifact;
import com.oracle.bmc.jms.model.JavaFamily;
import com.oracle.bmc.jms.model.JavaLicense;
import com.oracle.bmc.jms.model.JreSecurityStatus;
import com.oracle.bmc.jms.model.LicenseType;
import com.oracle.bmc.jms.model.ReleaseType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaRelease
extends ExplicitlySetBmcModel {
    @JsonProperty(value="artifacts")
    private final List<JavaArtifact> artifacts;
    @JsonProperty(value="releaseVersion")
    private final String releaseVersion;
    @JsonProperty(value="familyVersion")
    private final String familyVersion;
    @JsonProperty(value="parentReleaseVersion")
    private final String parentReleaseVersion;
    @JsonProperty(value="securityStatus")
    private final JreSecurityStatus securityStatus;
    @JsonProperty(value="releaseType")
    private final ReleaseType releaseType;
    @JsonProperty(value="licenseType")
    private final LicenseType licenseType;
    @JsonProperty(value="familyDetails")
    private final JavaFamily familyDetails;
    @JsonProperty(value="licenseDetails")
    private final JavaLicense licenseDetails;
    @JsonProperty(value="releaseDate")
    private final Date releaseDate;
    @JsonProperty(value="releaseNotesUrl")
    private final String releaseNotesUrl;
    @JsonProperty(value="artifactContentTypes")
    private final List<ArtifactContentType> artifactContentTypes;

    @Deprecated
    @ConstructorProperties(value={"artifacts", "releaseVersion", "familyVersion", "parentReleaseVersion", "securityStatus", "releaseType", "licenseType", "familyDetails", "licenseDetails", "releaseDate", "releaseNotesUrl", "artifactContentTypes"})
    public JavaRelease(List<JavaArtifact> artifacts, String releaseVersion, String familyVersion, String parentReleaseVersion, JreSecurityStatus securityStatus, ReleaseType releaseType, LicenseType licenseType, JavaFamily familyDetails, JavaLicense licenseDetails, Date releaseDate, String releaseNotesUrl, List<ArtifactContentType> artifactContentTypes) {
        this.artifacts = artifacts;
        this.releaseVersion = releaseVersion;
        this.familyVersion = familyVersion;
        this.parentReleaseVersion = parentReleaseVersion;
        this.securityStatus = securityStatus;
        this.releaseType = releaseType;
        this.licenseType = licenseType;
        this.familyDetails = familyDetails;
        this.licenseDetails = licenseDetails;
        this.releaseDate = releaseDate;
        this.releaseNotesUrl = releaseNotesUrl;
        this.artifactContentTypes = artifactContentTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<JavaArtifact> getArtifacts() {
        return this.artifacts;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public String getParentReleaseVersion() {
        return this.parentReleaseVersion;
    }

    public JreSecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public ReleaseType getReleaseType() {
        return this.releaseType;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public JavaFamily getFamilyDetails() {
        return this.familyDetails;
    }

    public JavaLicense getLicenseDetails() {
        return this.licenseDetails;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public List<ArtifactContentType> getArtifactContentTypes() {
        return this.artifactContentTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaRelease(");
        sb.append("super=").append(super.toString());
        sb.append("artifacts=").append(String.valueOf(this.artifacts));
        sb.append(", releaseVersion=").append(String.valueOf(this.releaseVersion));
        sb.append(", familyVersion=").append(String.valueOf(this.familyVersion));
        sb.append(", parentReleaseVersion=").append(String.valueOf(this.parentReleaseVersion));
        sb.append(", securityStatus=").append(String.valueOf((Object)this.securityStatus));
        sb.append(", releaseType=").append(String.valueOf((Object)this.releaseType));
        sb.append(", licenseType=").append(String.valueOf((Object)this.licenseType));
        sb.append(", familyDetails=").append(String.valueOf((Object)this.familyDetails));
        sb.append(", licenseDetails=").append(String.valueOf((Object)this.licenseDetails));
        sb.append(", releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(", releaseNotesUrl=").append(String.valueOf(this.releaseNotesUrl));
        sb.append(", artifactContentTypes=").append(String.valueOf(this.artifactContentTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaRelease)) {
            return false;
        }
        JavaRelease other = (JavaRelease)((Object)o);
        return Objects.equals(this.artifacts, other.artifacts) && Objects.equals(this.releaseVersion, other.releaseVersion) && Objects.equals(this.familyVersion, other.familyVersion) && Objects.equals(this.parentReleaseVersion, other.parentReleaseVersion) && Objects.equals((Object)this.securityStatus, (Object)other.securityStatus) && Objects.equals((Object)this.releaseType, (Object)other.releaseType) && Objects.equals((Object)this.licenseType, (Object)other.licenseType) && Objects.equals((Object)this.familyDetails, (Object)other.familyDetails) && Objects.equals((Object)this.licenseDetails, (Object)other.licenseDetails) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.releaseNotesUrl, other.releaseNotesUrl) && Objects.equals(this.artifactContentTypes, other.artifactContentTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.artifacts == null ? 43 : this.artifacts.hashCode());
        result = result * 59 + (this.releaseVersion == null ? 43 : this.releaseVersion.hashCode());
        result = result * 59 + (this.familyVersion == null ? 43 : this.familyVersion.hashCode());
        result = result * 59 + (this.parentReleaseVersion == null ? 43 : this.parentReleaseVersion.hashCode());
        result = result * 59 + (this.securityStatus == null ? 43 : this.securityStatus.hashCode());
        result = result * 59 + (this.releaseType == null ? 43 : this.releaseType.hashCode());
        result = result * 59 + (this.licenseType == null ? 43 : this.licenseType.hashCode());
        result = result * 59 + (this.familyDetails == null ? 43 : this.familyDetails.hashCode());
        result = result * 59 + (this.licenseDetails == null ? 43 : this.licenseDetails.hashCode());
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + (this.releaseNotesUrl == null ? 43 : this.releaseNotesUrl.hashCode());
        result = result * 59 + (this.artifactContentTypes == null ? 43 : this.artifactContentTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="artifacts")
        private List<JavaArtifact> artifacts;
        @JsonProperty(value="releaseVersion")
        private String releaseVersion;
        @JsonProperty(value="familyVersion")
        private String familyVersion;
        @JsonProperty(value="parentReleaseVersion")
        private String parentReleaseVersion;
        @JsonProperty(value="securityStatus")
        private JreSecurityStatus securityStatus;
        @JsonProperty(value="releaseType")
        private ReleaseType releaseType;
        @JsonProperty(value="licenseType")
        private LicenseType licenseType;
        @JsonProperty(value="familyDetails")
        private JavaFamily familyDetails;
        @JsonProperty(value="licenseDetails")
        private JavaLicense licenseDetails;
        @JsonProperty(value="releaseDate")
        private Date releaseDate;
        @JsonProperty(value="releaseNotesUrl")
        private String releaseNotesUrl;
        @JsonProperty(value="artifactContentTypes")
        private List<ArtifactContentType> artifactContentTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder artifacts(List<JavaArtifact> artifacts) {
            this.artifacts = artifacts;
            this.__explicitlySet__.add("artifacts");
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            this.__explicitlySet__.add("releaseVersion");
            return this;
        }

        public Builder familyVersion(String familyVersion) {
            this.familyVersion = familyVersion;
            this.__explicitlySet__.add("familyVersion");
            return this;
        }

        public Builder parentReleaseVersion(String parentReleaseVersion) {
            this.parentReleaseVersion = parentReleaseVersion;
            this.__explicitlySet__.add("parentReleaseVersion");
            return this;
        }

        public Builder securityStatus(JreSecurityStatus securityStatus) {
            this.securityStatus = securityStatus;
            this.__explicitlySet__.add("securityStatus");
            return this;
        }

        public Builder releaseType(ReleaseType releaseType) {
            this.releaseType = releaseType;
            this.__explicitlySet__.add("releaseType");
            return this;
        }

        public Builder licenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
            this.__explicitlySet__.add("licenseType");
            return this;
        }

        public Builder familyDetails(JavaFamily familyDetails) {
            this.familyDetails = familyDetails;
            this.__explicitlySet__.add("familyDetails");
            return this;
        }

        public Builder licenseDetails(JavaLicense licenseDetails) {
            this.licenseDetails = licenseDetails;
            this.__explicitlySet__.add("licenseDetails");
            return this;
        }

        public Builder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public Builder releaseNotesUrl(String releaseNotesUrl) {
            this.releaseNotesUrl = releaseNotesUrl;
            this.__explicitlySet__.add("releaseNotesUrl");
            return this;
        }

        public Builder artifactContentTypes(List<ArtifactContentType> artifactContentTypes) {
            this.artifactContentTypes = artifactContentTypes;
            this.__explicitlySet__.add("artifactContentTypes");
            return this;
        }

        public JavaRelease build() {
            JavaRelease model = new JavaRelease(this.artifacts, this.releaseVersion, this.familyVersion, this.parentReleaseVersion, this.securityStatus, this.releaseType, this.licenseType, this.familyDetails, this.licenseDetails, this.releaseDate, this.releaseNotesUrl, this.artifactContentTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaRelease model) {
            if (model.wasPropertyExplicitlySet("artifacts")) {
                this.artifacts(model.getArtifacts());
            }
            if (model.wasPropertyExplicitlySet("releaseVersion")) {
                this.releaseVersion(model.getReleaseVersion());
            }
            if (model.wasPropertyExplicitlySet("familyVersion")) {
                this.familyVersion(model.getFamilyVersion());
            }
            if (model.wasPropertyExplicitlySet("parentReleaseVersion")) {
                this.parentReleaseVersion(model.getParentReleaseVersion());
            }
            if (model.wasPropertyExplicitlySet("securityStatus")) {
                this.securityStatus(model.getSecurityStatus());
            }
            if (model.wasPropertyExplicitlySet("releaseType")) {
                this.releaseType(model.getReleaseType());
            }
            if (model.wasPropertyExplicitlySet("licenseType")) {
                this.licenseType(model.getLicenseType());
            }
            if (model.wasPropertyExplicitlySet("familyDetails")) {
                this.familyDetails(model.getFamilyDetails());
            }
            if (model.wasPropertyExplicitlySet("licenseDetails")) {
                this.licenseDetails(model.getLicenseDetails());
            }
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            if (model.wasPropertyExplicitlySet("releaseNotesUrl")) {
                this.releaseNotesUrl(model.getReleaseNotesUrl());
            }
            if (model.wasPropertyExplicitlySet("artifactContentTypes")) {
                this.artifactContentTypes(model.getArtifactContentTypes());
            }
            return this;
        }
    }
}

