/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.jms.JavaManagementService;
import com.oracle.bmc.jms.JavaManagementServiceAsyncClient;
import com.oracle.bmc.jms.JavaManagementServicePaginators;
import com.oracle.bmc.jms.JavaManagementServiceWaiters;
import com.oracle.bmc.jms.model.ApplicationUsageCollection;
import com.oracle.bmc.jms.model.Blocklist;
import com.oracle.bmc.jms.model.BlocklistCollection;
import com.oracle.bmc.jms.model.CryptoAnalysisResult;
import com.oracle.bmc.jms.model.CryptoAnalysisResultCollection;
import com.oracle.bmc.jms.model.DeployedApplicationUsageCollection;
import com.oracle.bmc.jms.model.Fleet;
import com.oracle.bmc.jms.model.FleetAdvancedFeatureConfiguration;
import com.oracle.bmc.jms.model.FleetAgentConfiguration;
import com.oracle.bmc.jms.model.FleetCollection;
import com.oracle.bmc.jms.model.InstallationSiteCollection;
import com.oracle.bmc.jms.model.InstallationUsageCollection;
import com.oracle.bmc.jms.model.JavaFamily;
import com.oracle.bmc.jms.model.JavaFamilyCollection;
import com.oracle.bmc.jms.model.JavaRelease;
import com.oracle.bmc.jms.model.JavaReleaseCollection;
import com.oracle.bmc.jms.model.JavaServerInstanceUsageCollection;
import com.oracle.bmc.jms.model.JavaServerUsageCollection;
import com.oracle.bmc.jms.model.JreUsageCollection;
import com.oracle.bmc.jms.model.LibraryUsageCollection;
import com.oracle.bmc.jms.model.ManagedInstanceUsageCollection;
import com.oracle.bmc.jms.model.ResourceInventory;
import com.oracle.bmc.jms.model.WorkItemCollection;
import com.oracle.bmc.jms.model.WorkRequest;
import com.oracle.bmc.jms.model.WorkRequestCollection;
import com.oracle.bmc.jms.model.WorkRequestErrorCollection;
import com.oracle.bmc.jms.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.jms.requests.AddFleetInstallationSitesRequest;
import com.oracle.bmc.jms.requests.CancelWorkRequestRequest;
import com.oracle.bmc.jms.requests.ChangeFleetCompartmentRequest;
import com.oracle.bmc.jms.requests.CreateBlocklistRequest;
import com.oracle.bmc.jms.requests.CreateFleetRequest;
import com.oracle.bmc.jms.requests.DeleteBlocklistRequest;
import com.oracle.bmc.jms.requests.DeleteCryptoAnalysisResultRequest;
import com.oracle.bmc.jms.requests.DeleteFleetRequest;
import com.oracle.bmc.jms.requests.GenerateAgentDeployScriptRequest;
import com.oracle.bmc.jms.requests.GetCryptoAnalysisResultRequest;
import com.oracle.bmc.jms.requests.GetFleetAdvancedFeatureConfigurationRequest;
import com.oracle.bmc.jms.requests.GetFleetAgentConfigurationRequest;
import com.oracle.bmc.jms.requests.GetFleetRequest;
import com.oracle.bmc.jms.requests.GetJavaFamilyRequest;
import com.oracle.bmc.jms.requests.GetJavaReleaseRequest;
import com.oracle.bmc.jms.requests.GetWorkRequestRequest;
import com.oracle.bmc.jms.requests.ListBlocklistsRequest;
import com.oracle.bmc.jms.requests.ListCryptoAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListFleetsRequest;
import com.oracle.bmc.jms.requests.ListInstallationSitesRequest;
import com.oracle.bmc.jms.requests.ListJavaFamiliesRequest;
import com.oracle.bmc.jms.requests.ListJavaReleasesRequest;
import com.oracle.bmc.jms.requests.ListJreUsageRequest;
import com.oracle.bmc.jms.requests.ListWorkItemsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestsRequest;
import com.oracle.bmc.jms.requests.RemoveFleetInstallationSitesRequest;
import com.oracle.bmc.jms.requests.RequestCryptoAnalysesRequest;
import com.oracle.bmc.jms.requests.RequestJfrRecordingsRequest;
import com.oracle.bmc.jms.requests.ScanJavaServerUsageRequest;
import com.oracle.bmc.jms.requests.ScanLibraryUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeApplicationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeDeployedApplicationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeInstallationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJavaServerInstanceUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJavaServerUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJreUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeLibraryUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeManagedInstanceUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeResourceInventoryRequest;
import com.oracle.bmc.jms.requests.UpdateFleetAdvancedFeatureConfigurationRequest;
import com.oracle.bmc.jms.requests.UpdateFleetAgentConfigurationRequest;
import com.oracle.bmc.jms.requests.UpdateFleetRequest;
import com.oracle.bmc.jms.responses.AddFleetInstallationSitesResponse;
import com.oracle.bmc.jms.responses.CancelWorkRequestResponse;
import com.oracle.bmc.jms.responses.ChangeFleetCompartmentResponse;
import com.oracle.bmc.jms.responses.CreateBlocklistResponse;
import com.oracle.bmc.jms.responses.CreateFleetResponse;
import com.oracle.bmc.jms.responses.DeleteBlocklistResponse;
import com.oracle.bmc.jms.responses.DeleteCryptoAnalysisResultResponse;
import com.oracle.bmc.jms.responses.DeleteFleetResponse;
import com.oracle.bmc.jms.responses.GenerateAgentDeployScriptResponse;
import com.oracle.bmc.jms.responses.GetCryptoAnalysisResultResponse;
import com.oracle.bmc.jms.responses.GetFleetAdvancedFeatureConfigurationResponse;
import com.oracle.bmc.jms.responses.GetFleetAgentConfigurationResponse;
import com.oracle.bmc.jms.responses.GetFleetResponse;
import com.oracle.bmc.jms.responses.GetJavaFamilyResponse;
import com.oracle.bmc.jms.responses.GetJavaReleaseResponse;
import com.oracle.bmc.jms.responses.GetWorkRequestResponse;
import com.oracle.bmc.jms.responses.ListBlocklistsResponse;
import com.oracle.bmc.jms.responses.ListCryptoAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListFleetsResponse;
import com.oracle.bmc.jms.responses.ListInstallationSitesResponse;
import com.oracle.bmc.jms.responses.ListJavaFamiliesResponse;
import com.oracle.bmc.jms.responses.ListJavaReleasesResponse;
import com.oracle.bmc.jms.responses.ListJreUsageResponse;
import com.oracle.bmc.jms.responses.ListWorkItemsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestsResponse;
import com.oracle.bmc.jms.responses.RemoveFleetInstallationSitesResponse;
import com.oracle.bmc.jms.responses.RequestCryptoAnalysesResponse;
import com.oracle.bmc.jms.responses.RequestJfrRecordingsResponse;
import com.oracle.bmc.jms.responses.ScanJavaServerUsageResponse;
import com.oracle.bmc.jms.responses.ScanLibraryUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeApplicationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeDeployedApplicationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeInstallationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJavaServerInstanceUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJavaServerUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJreUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeLibraryUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeManagedInstanceUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeResourceInventoryResponse;
import com.oracle.bmc.jms.responses.UpdateFleetAdvancedFeatureConfigurationResponse;
import com.oracle.bmc.jms.responses.UpdateFleetAgentConfigurationResponse;
import com.oracle.bmc.jms.responses.UpdateFleetResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaManagementServiceClient
extends BaseSyncClient
implements JavaManagementService {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("JAVAMANAGEMENTSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://javamanagement.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(JavaManagementServiceAsyncClient.class);
    private final JavaManagementServiceWaiters waiters;
    private final JavaManagementServicePaginators paginators;

    private JavaManagementServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("JavaManagementService-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new JavaManagementServiceWaiters(executorService, this);
        this.paginators = new JavaManagementServicePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddFleetInstallationSitesResponse addFleetInstallationSites(AddFleetInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddFleetInstallationSitesDetails(), "addFleetInstallationSitesDetails is required");
        return (AddFleetInstallationSitesResponse)this.clientCall(request, AddFleetInstallationSitesResponse::builder).logger(LOG, "addFleetInstallationSites").serviceDetails("JavaManagementService", "AddFleetInstallationSites", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/InstallationSiteSummary/AddFleetInstallationSites").method(Method.POST).requestBuilder(AddFleetInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("addInstallationSites").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", AddFleetInstallationSitesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddFleetInstallationSitesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("JavaManagementService", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeFleetCompartmentResponse changeFleetCompartment(ChangeFleetCompartmentRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFleetCompartmentDetails(), "changeFleetCompartmentDetails is required");
        return (ChangeFleetCompartmentResponse)this.clientCall(request, ChangeFleetCompartmentResponse::builder).logger(LOG, "changeFleetCompartment").serviceDetails("JavaManagementService", "ChangeFleetCompartment", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/ChangeFleetCompartment").method(Method.POST).requestBuilder(ChangeFleetCompartmentRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFleetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFleetCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateBlocklistResponse createBlocklist(CreateBlocklistRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBlocklistDetails(), "createBlocklistDetails is required");
        return (CreateBlocklistResponse)this.clientCall(request, CreateBlocklistResponse::builder).logger(LOG, "createBlocklist").serviceDetails("JavaManagementService", "CreateBlocklist", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Blocklist/CreateBlocklist").method(Method.POST).requestBuilder(CreateBlocklistRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Blocklist.class, CreateBlocklistResponse.Builder::blocklist).handleResponseHeaderString("opc-request-id", CreateBlocklistResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateBlocklistResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest request) {
        Objects.requireNonNull(request.getCreateFleetDetails(), "createFleetDetails is required");
        return (CreateFleetResponse)this.clientCall(request, CreateFleetResponse::builder).logger(LOG, "createFleet").serviceDetails("JavaManagementService", "CreateFleet", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/CreateFleet").method(Method.POST).requestBuilder(CreateFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFleetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteBlocklistResponse deleteBlocklist(DeleteBlocklistRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBlocklistKey(), (String)"blocklistKey must not be blank", (Object[])new Object[0]);
        return (DeleteBlocklistResponse)this.clientCall(request, DeleteBlocklistResponse::builder).logger(LOG, "deleteBlocklist").serviceDetails("JavaManagementService", "DeleteBlocklist", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Blocklist/DeleteBlocklist").method(Method.DELETE).requestBuilder(DeleteBlocklistRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").appendPathParam(request.getBlocklistKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteBlocklistResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteCryptoAnalysisResultResponse deleteCryptoAnalysisResult(DeleteCryptoAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCryptoAnalysisResultId(), (String)"cryptoAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (DeleteCryptoAnalysisResultResponse)this.clientCall(request, DeleteCryptoAnalysisResultResponse::builder).logger(LOG, "deleteCryptoAnalysisResult").serviceDetails("JavaManagementService", "DeleteCryptoAnalysisResult", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/CryptoAnalysisResult/DeleteCryptoAnalysisResult").method(Method.DELETE).requestBuilder(DeleteCryptoAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendPathParam(request.getCryptoAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteCryptoAnalysisResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCryptoAnalysisResultResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (DeleteFleetResponse)this.clientCall(request, DeleteFleetResponse::builder).logger(LOG, "deleteFleet").serviceDetails("JavaManagementService", "DeleteFleet", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/DeleteFleet").method(Method.DELETE).requestBuilder(DeleteFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFleetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GenerateAgentDeployScriptResponse generateAgentDeployScript(GenerateAgentDeployScriptRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateAgentDeployScriptDetails(), "generateAgentDeployScriptDetails is required");
        return (GenerateAgentDeployScriptResponse)this.clientCall(request, GenerateAgentDeployScriptResponse::builder).logger(LOG, "generateAgentDeployScript").serviceDetails("JavaManagementService", "GenerateAgentDeployScript", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/GenerateAgentDeployScript").method(Method.POST).requestBuilder(GenerateAgentDeployScriptRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("generateAgentDeployScript").accept(new String[]{"text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, GenerateAgentDeployScriptResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GenerateAgentDeployScriptResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GenerateAgentDeployScriptResponse.Builder::contentLength).handleResponseHeaderString("content-type", GenerateAgentDeployScriptResponse.Builder::contentType).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCryptoAnalysisResultResponse getCryptoAnalysisResult(GetCryptoAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCryptoAnalysisResultId(), (String)"cryptoAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (GetCryptoAnalysisResultResponse)this.clientCall(request, GetCryptoAnalysisResultResponse::builder).logger(LOG, "getCryptoAnalysisResult").serviceDetails("JavaManagementService", "GetCryptoAnalysisResult", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/CryptoAnalysisResult/GetCryptoAnalysisResult").method(Method.GET).requestBuilder(GetCryptoAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendPathParam(request.getCryptoAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CryptoAnalysisResult.class, GetCryptoAnalysisResultResponse.Builder::cryptoAnalysisResult).handleResponseHeaderString("etag", GetCryptoAnalysisResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCryptoAnalysisResultResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFleetResponse getFleet(GetFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetResponse)this.clientCall(request, GetFleetResponse::builder).logger(LOG, "getFleet").serviceDetails("JavaManagementService", "GetFleet", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/GetFleet").method(Method.GET).requestBuilder(GetFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Fleet.class, GetFleetResponse.Builder::fleet).handleResponseHeaderString("etag", GetFleetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFleetAdvancedFeatureConfigurationResponse getFleetAdvancedFeatureConfiguration(GetFleetAdvancedFeatureConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetAdvancedFeatureConfigurationResponse)this.clientCall(request, GetFleetAdvancedFeatureConfigurationResponse::builder).logger(LOG, "getFleetAdvancedFeatureConfiguration").serviceDetails("JavaManagementService", "GetFleetAdvancedFeatureConfiguration", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/FleetAdvancedFeatureConfiguration/GetFleetAdvancedFeatureConfiguration").method(Method.GET).requestBuilder(GetFleetAdvancedFeatureConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("advancedFeatureConfiguration").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetAdvancedFeatureConfiguration.class, GetFleetAdvancedFeatureConfigurationResponse.Builder::fleetAdvancedFeatureConfiguration).handleResponseHeaderString("opc-request-id", GetFleetAdvancedFeatureConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetFleetAdvancedFeatureConfigurationResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFleetAgentConfigurationResponse getFleetAgentConfiguration(GetFleetAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetAgentConfigurationResponse)this.clientCall(request, GetFleetAgentConfigurationResponse::builder).logger(LOG, "getFleetAgentConfiguration").serviceDetails("JavaManagementService", "GetFleetAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/FleetAgentConfiguration/GetFleetAgentConfiguration").method(Method.GET).requestBuilder(GetFleetAgentConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("agentConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetAgentConfiguration.class, GetFleetAgentConfigurationResponse.Builder::fleetAgentConfiguration).handleResponseHeaderString("etag", GetFleetAgentConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetAgentConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJavaFamilyResponse getJavaFamily(GetJavaFamilyRequest request) {
        Validate.notBlank((String)request.getFamilyVersion(), (String)"familyVersion must not be blank", (Object[])new Object[0]);
        return (GetJavaFamilyResponse)this.clientCall(request, GetJavaFamilyResponse::builder).logger(LOG, "getJavaFamily").serviceDetails("JavaManagementService", "GetJavaFamily", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaFamily/GetJavaFamily").method(Method.GET).requestBuilder(GetJavaFamilyRequest::builder).basePath("/20210610").appendPathParam("javaFamilies").appendPathParam(request.getFamilyVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaFamily.class, GetJavaFamilyResponse.Builder::javaFamily).handleResponseHeaderString("opc-request-id", GetJavaFamilyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJavaReleaseResponse getJavaRelease(GetJavaReleaseRequest request) {
        Validate.notBlank((String)request.getReleaseVersion(), (String)"releaseVersion must not be blank", (Object[])new Object[0]);
        return (GetJavaReleaseResponse)this.clientCall(request, GetJavaReleaseResponse::builder).logger(LOG, "getJavaRelease").serviceDetails("JavaManagementService", "GetJavaRelease", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaRelease/GetJavaRelease").method(Method.GET).requestBuilder(GetJavaReleaseRequest::builder).basePath("/20210610").appendPathParam("javaReleases").appendPathParam(request.getReleaseVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaRelease.class, GetJavaReleaseResponse.Builder::javaRelease).handleResponseHeaderString("opc-request-id", GetJavaReleaseResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("JavaManagementService", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListBlocklistsResponse listBlocklists(ListBlocklistsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListBlocklistsResponse)this.clientCall(request, ListBlocklistsResponse::builder).logger(LOG, "listBlocklists").serviceDetails("JavaManagementService", "ListBlocklists", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Blocklist/ListBlocklists").method(Method.GET).requestBuilder(ListBlocklistsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").appendEnumQueryParam("operation", (BmcEnum)request.getOperation()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlocklistCollection.class, ListBlocklistsResponse.Builder::blocklistCollection).handleResponseHeaderString("opc-request-id", ListBlocklistsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlocklistsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCryptoAnalysisResultsResponse listCryptoAnalysisResults(ListCryptoAnalysisResultsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListCryptoAnalysisResultsResponse)this.clientCall(request, ListCryptoAnalysisResultsResponse::builder).logger(LOG, "listCryptoAnalysisResults").serviceDetails("JavaManagementService", "ListCryptoAnalysisResults", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/CryptoAnalysisResult/ListCryptoAnalysisResults").method(Method.GET).requestBuilder(ListCryptoAnalysisResultsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendEnumQueryParam("aggregationMode", (BmcEnum)request.getAggregationMode()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CryptoAnalysisResultCollection.class, ListCryptoAnalysisResultsResponse.Builder::cryptoAnalysisResultCollection).handleResponseHeaderString("opc-request-id", ListCryptoAnalysisResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCryptoAnalysisResultsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest request) {
        return (ListFleetsResponse)this.clientCall(request, ListFleetsResponse::builder).logger(LOG, "listFleets").serviceDetails("JavaManagementService", "ListFleets", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/ListFleets").method(Method.GET).requestBuilder(ListFleetsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FleetCollection.class, ListFleetsResponse.Builder::fleetCollection).handleResponseHeaderString("opc-request-id", ListFleetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListInstallationSitesResponse listInstallationSites(ListInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListInstallationSitesResponse)this.clientCall(request, ListInstallationSitesResponse::builder).logger(LOG, "listInstallationSites").serviceDetails("JavaManagementService", "ListInstallationSites", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/InstallationSiteSummary/ListInstallationSites").method(Method.GET).requestBuilder(ListInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("installationSites").appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).appendQueryParam("pathContains", (Object)request.getPathContains()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstallationSiteCollection.class, ListInstallationSitesResponse.Builder::installationSiteCollection).handleResponseHeaderString("opc-request-id", ListInstallationSitesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInstallationSitesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJavaFamiliesResponse listJavaFamilies(ListJavaFamiliesRequest request) {
        return (ListJavaFamiliesResponse)this.clientCall(request, ListJavaFamiliesResponse::builder).logger(LOG, "listJavaFamilies").serviceDetails("JavaManagementService", "ListJavaFamilies", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaFamily/ListJavaFamilies").method(Method.GET).requestBuilder(ListJavaFamiliesRequest::builder).basePath("/20210610").appendPathParam("javaFamilies").appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaFamilyCollection.class, ListJavaFamiliesResponse.Builder::javaFamilyCollection).handleResponseHeaderString("opc-request-id", ListJavaFamiliesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaFamiliesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJavaReleasesResponse listJavaReleases(ListJavaReleasesRequest request) {
        return (ListJavaReleasesResponse)this.clientCall(request, ListJavaReleasesResponse::builder).logger(LOG, "listJavaReleases").serviceDetails("JavaManagementService", "ListJavaReleases", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaRelease/ListJavaReleases").method(Method.GET).requestBuilder(ListJavaReleasesRequest::builder).basePath("/20210610").appendPathParam("javaReleases").appendQueryParam("releaseVersion", (Object)request.getReleaseVersion()).appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendEnumQueryParam("releaseType", (BmcEnum)request.getReleaseType()).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).appendEnumQueryParam("licenseType", (BmcEnum)request.getLicenseType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaReleaseCollection.class, ListJavaReleasesResponse.Builder::javaReleaseCollection).handleResponseHeaderString("opc-request-id", ListJavaReleasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaReleasesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJreUsageResponse listJreUsage(ListJreUsageRequest request) {
        return (ListJreUsageResponse)this.clientCall(request, ListJreUsageResponse::builder).logger(LOG, "listJreUsage").serviceDetails("JavaManagementService", "ListJreUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JreUsage/ListJreUsage").method(Method.GET).requestBuilder(ListJreUsageRequest::builder).basePath("/20210610").appendPathParam("listJreUsage").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("hostId", (Object)request.getHostId()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JreUsageCollection.class, ListJreUsageResponse.Builder::jreUsageCollection).handleResponseHeaderString("opc-request-id", ListJreUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJreUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkItemsResponse listWorkItems(ListWorkItemsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkItemsResponse)this.clientCall(request, ListWorkItemsResponse::builder).logger(LOG, "listWorkItems").serviceDetails("JavaManagementService", "ListWorkItems", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkItemSummary/ListWorkItems").method(Method.GET).requestBuilder(ListWorkItemsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("workItems").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkItemCollection.class, ListWorkItemsResponse.Builder::workItemCollection).handleResponseHeaderString("opc-next-page", ListWorkItemsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkItemsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("JavaManagementService", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("JavaManagementService", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("JavaManagementService", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RemoveFleetInstallationSitesResponse removeFleetInstallationSites(RemoveFleetInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveFleetInstallationSitesDetails(), "removeFleetInstallationSitesDetails is required");
        return (RemoveFleetInstallationSitesResponse)this.clientCall(request, RemoveFleetInstallationSitesResponse::builder).logger(LOG, "removeFleetInstallationSites").serviceDetails("JavaManagementService", "RemoveFleetInstallationSites", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/InstallationSiteSummary/RemoveFleetInstallationSites").method(Method.POST).requestBuilder(RemoveFleetInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("removeInstallationSites").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveFleetInstallationSitesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveFleetInstallationSitesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RequestCryptoAnalysesResponse requestCryptoAnalyses(RequestCryptoAnalysesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestCryptoAnalysesDetails(), "requestCryptoAnalysesDetails is required");
        return (RequestCryptoAnalysesResponse)this.clientCall(request, RequestCryptoAnalysesResponse::builder).logger(LOG, "requestCryptoAnalyses").serviceDetails("JavaManagementService", "RequestCryptoAnalyses", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/RequestCryptoAnalyses").method(Method.POST).requestBuilder(RequestCryptoAnalysesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestCryptoAnalyses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RequestCryptoAnalysesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestCryptoAnalysesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public RequestJfrRecordingsResponse requestJfrRecordings(RequestJfrRecordingsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestJfrRecordingsDetails(), "requestJfrRecordingsDetails is required");
        return (RequestJfrRecordingsResponse)this.clientCall(request, RequestJfrRecordingsResponse::builder).logger(LOG, "requestJfrRecordings").serviceDetails("JavaManagementService", "RequestJfrRecordings", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/RequestJfrRecordings").method(Method.POST).requestBuilder(RequestJfrRecordingsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestJfrRecordings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RequestJfrRecordingsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestJfrRecordingsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ScanJavaServerUsageResponse scanJavaServerUsage(ScanJavaServerUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScanJavaServerUsageDetails(), "scanJavaServerUsageDetails is required");
        return (ScanJavaServerUsageResponse)this.clientCall(request, ScanJavaServerUsageResponse::builder).logger(LOG, "scanJavaServerUsage").serviceDetails("JavaManagementService", "ScanJavaServerUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaServerUsage/ScanJavaServerUsage").method(Method.POST).requestBuilder(ScanJavaServerUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("scanJavaServerUsage").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ScanJavaServerUsageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScanJavaServerUsageResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ScanLibraryUsageResponse scanLibraryUsage(ScanLibraryUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScanLibraryUsageDetails(), "scanLibraryUsageDetails is required");
        return (ScanLibraryUsageResponse)this.clientCall(request, ScanLibraryUsageResponse::builder).logger(LOG, "scanLibraryUsage").serviceDetails("JavaManagementService", "ScanLibraryUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/LibraryUsage/ScanLibraryUsage").method(Method.POST).requestBuilder(ScanLibraryUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("scanLibraryUsage").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ScanLibraryUsageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScanLibraryUsageResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeApplicationUsageResponse summarizeApplicationUsage(SummarizeApplicationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeApplicationUsageResponse)this.clientCall(request, SummarizeApplicationUsageResponse::builder).logger(LOG, "summarizeApplicationUsage").serviceDetails("JavaManagementService", "SummarizeApplicationUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/ApplicationUsage/SummarizeApplicationUsage").method(Method.GET).requestBuilder(SummarizeApplicationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeApplicationUsage").appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("applicationType", (Object)request.getApplicationType()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplicationUsageCollection.class, SummarizeApplicationUsageResponse.Builder::applicationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeApplicationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeApplicationUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeDeployedApplicationUsageResponse summarizeDeployedApplicationUsage(SummarizeDeployedApplicationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeDeployedApplicationUsageResponse)this.clientCall(request, SummarizeDeployedApplicationUsageResponse::builder).logger(LOG, "summarizeDeployedApplicationUsage").serviceDetails("JavaManagementService", "SummarizeDeployedApplicationUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/DeployedApplicationUsage/SummarizeDeployedApplicationUsage").method(Method.GET).requestBuilder(SummarizeDeployedApplicationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeDeployedApplicationUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("applicationNameContains", (Object)request.getApplicationNameContains()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DeployedApplicationUsageCollection.class, SummarizeDeployedApplicationUsageResponse.Builder::deployedApplicationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeDeployedApplicationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeDeployedApplicationUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeInstallationUsageResponse summarizeInstallationUsage(SummarizeInstallationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeInstallationUsageResponse)this.clientCall(request, SummarizeInstallationUsageResponse::builder).logger(LOG, "summarizeInstallationUsage").serviceDetails("JavaManagementService", "SummarizeInstallationUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/InstallationUsage/SummarizeInstallationUsage").method(Method.GET).requestBuilder(SummarizeInstallationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeInstallationUsage").appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("pathContains", (Object)request.getPathContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstallationUsageCollection.class, SummarizeInstallationUsageResponse.Builder::installationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeInstallationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeInstallationUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeJavaServerInstanceUsageResponse summarizeJavaServerInstanceUsage(SummarizeJavaServerInstanceUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJavaServerInstanceUsageResponse)this.clientCall(request, SummarizeJavaServerInstanceUsageResponse::builder).logger(LOG, "summarizeJavaServerInstanceUsage").serviceDetails("JavaManagementService", "SummarizeJavaServerInstanceUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaServerInstanceUsage/SummarizeJavaServerInstanceUsage").method(Method.GET).requestBuilder(SummarizeJavaServerInstanceUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJavaServerInstanceUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("serverInstanceNameContains", (Object)request.getServerInstanceNameContains()).appendQueryParam("serverInstanceName", (Object)request.getServerInstanceName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaServerInstanceUsageCollection.class, SummarizeJavaServerInstanceUsageResponse.Builder::javaServerInstanceUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJavaServerInstanceUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJavaServerInstanceUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeJavaServerUsageResponse summarizeJavaServerUsage(SummarizeJavaServerUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJavaServerUsageResponse)this.clientCall(request, SummarizeJavaServerUsageResponse::builder).logger(LOG, "summarizeJavaServerUsage").serviceDetails("JavaManagementService", "SummarizeJavaServerUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JavaServerUsage/SummarizeJavaServerUsage").method(Method.GET).requestBuilder(SummarizeJavaServerUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJavaServerUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverNameContains", (Object)request.getServerNameContains()).appendQueryParam("serverName", (Object)request.getServerName()).appendQueryParam("serverVersion", (Object)request.getServerVersion()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JavaServerUsageCollection.class, SummarizeJavaServerUsageResponse.Builder::javaServerUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJavaServerUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJavaServerUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeJreUsageResponse summarizeJreUsage(SummarizeJreUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJreUsageResponse)this.clientCall(request, SummarizeJreUsageResponse::builder).logger(LOG, "summarizeJreUsage").serviceDetails("JavaManagementService", "SummarizeJreUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/JreUsage/SummarizeJreUsage").method(Method.GET).requestBuilder(SummarizeJreUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJreUsage").appendQueryParam("jreId", (Object)request.getJreId()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JreUsageCollection.class, SummarizeJreUsageResponse.Builder::jreUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJreUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJreUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeLibraryUsageResponse summarizeLibraryUsage(SummarizeLibraryUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeLibraryUsageResponse)this.clientCall(request, SummarizeLibraryUsageResponse::builder).logger(LOG, "summarizeLibraryUsage").serviceDetails("JavaManagementService", "SummarizeLibraryUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/LibraryUsage/SummarizeLibraryUsage").method(Method.GET).requestBuilder(SummarizeLibraryUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeLibraryUsage").appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("libraryNameContains", (Object)request.getLibraryNameContains()).appendQueryParam("libraryName", (Object)request.getLibraryName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(LibraryUsageCollection.class, SummarizeLibraryUsageResponse.Builder::libraryUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeLibraryUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeLibraryUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeManagedInstanceUsageResponse summarizeManagedInstanceUsage(SummarizeManagedInstanceUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeManagedInstanceUsageResponse)this.clientCall(request, SummarizeManagedInstanceUsageResponse::builder).logger(LOG, "summarizeManagedInstanceUsage").serviceDetails("JavaManagementService", "SummarizeManagedInstanceUsage", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/ManagedInstanceUsage/SummarizeManagedInstanceUsage").method(Method.GET).requestBuilder(SummarizeManagedInstanceUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeManagedInstanceUsage").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendEnumQueryParam("managedInstanceType", (BmcEnum)request.getManagedInstanceType()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("hostnameContains", (Object)request.getHostnameContains()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedInstanceUsageCollection.class, SummarizeManagedInstanceUsageResponse.Builder::managedInstanceUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedInstanceUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedInstanceUsageResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeResourceInventoryResponse summarizeResourceInventory(SummarizeResourceInventoryRequest request) {
        return (SummarizeResourceInventoryResponse)this.clientCall(request, SummarizeResourceInventoryResponse::builder).logger(LOG, "summarizeResourceInventory").serviceDetails("JavaManagementService", "SummarizeResourceInventory", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/SummarizeResourceInventory").method(Method.GET).requestBuilder(SummarizeResourceInventoryRequest::builder).basePath("/20210610").appendPathParam("summarizeResourceInventory").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceInventory.class, SummarizeResourceInventoryResponse.Builder::resourceInventory).handleResponseHeaderString("opc-request-id", SummarizeResourceInventoryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetDetails(), "updateFleetDetails is required");
        return (UpdateFleetResponse)this.clientCall(request, UpdateFleetResponse::builder).logger(LOG, "updateFleet").serviceDetails("JavaManagementService", "UpdateFleet", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/Fleet/UpdateFleet").method(Method.PUT).requestBuilder(UpdateFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateFleetAdvancedFeatureConfigurationResponse updateFleetAdvancedFeatureConfiguration(UpdateFleetAdvancedFeatureConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetAdvancedFeatureConfigurationDetails(), "updateFleetAdvancedFeatureConfigurationDetails is required");
        return (UpdateFleetAdvancedFeatureConfigurationResponse)this.clientCall(request, UpdateFleetAdvancedFeatureConfigurationResponse::builder).logger(LOG, "updateFleetAdvancedFeatureConfiguration").serviceDetails("JavaManagementService", "UpdateFleetAdvancedFeatureConfiguration", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/FleetAdvancedFeatureConfiguration/UpdateFleetAdvancedFeatureConfiguration").method(Method.PUT).requestBuilder(UpdateFleetAdvancedFeatureConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("advancedFeatureConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FleetAdvancedFeatureConfiguration.class, UpdateFleetAdvancedFeatureConfigurationResponse.Builder::fleetAdvancedFeatureConfiguration).handleResponseHeaderString("opc-request-id", UpdateFleetAdvancedFeatureConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateFleetAdvancedFeatureConfigurationResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateFleetAgentConfigurationResponse updateFleetAgentConfiguration(UpdateFleetAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetAgentConfigurationDetails(), "updateFleetAgentConfigurationDetails is required");
        return (UpdateFleetAgentConfigurationResponse)this.clientCall(request, UpdateFleetAgentConfigurationResponse::builder).logger(LOG, "updateFleetAgentConfiguration").serviceDetails("JavaManagementService", "UpdateFleetAgentConfiguration", "https://docs.oracle.com/iaas/api/#/en/jms/20210610/FleetAgentConfiguration/UpdateFleetAgentConfiguration").method(Method.PUT).requestBuilder(UpdateFleetAgentConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("agentConfiguration").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetAgentConfigurationResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public JavaManagementServiceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public JavaManagementServicePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)JavaManagementServiceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(JavaManagementServiceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, JavaManagementServiceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public JavaManagementServiceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new JavaManagementServiceClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

