/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ThickAuthorizationResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="policy")
    private final String policy;
    @JsonProperty(value="policyCacheDuration")
    private final String policyCacheDuration;
    @JsonProperty(value="groups")
    private final List<String> groups;
    @JsonProperty(value="groupMembershipCacheDuration")
    private final String groupMembershipCacheDuration;
    @JsonProperty(value="flushAllCaches")
    private final Boolean flushAllCaches;

    @Deprecated
    @ConstructorProperties(value={"policy", "policyCacheDuration", "groups", "groupMembershipCacheDuration", "flushAllCaches"})
    public ThickAuthorizationResponse(String policy, String policyCacheDuration, List<String> groups, String groupMembershipCacheDuration, Boolean flushAllCaches) {
        this.policy = policy;
        this.policyCacheDuration = policyCacheDuration;
        this.groups = groups;
        this.groupMembershipCacheDuration = groupMembershipCacheDuration;
        this.flushAllCaches = flushAllCaches;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getPolicyCacheDuration() {
        return this.policyCacheDuration;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroupMembershipCacheDuration() {
        return this.groupMembershipCacheDuration;
    }

    public Boolean getFlushAllCaches() {
        return this.flushAllCaches;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ThickAuthorizationResponse(");
        sb.append("super=").append(super.toString());
        sb.append("policy=").append(String.valueOf(this.policy));
        sb.append(", policyCacheDuration=").append(String.valueOf(this.policyCacheDuration));
        sb.append(", groups=").append(String.valueOf(this.groups));
        sb.append(", groupMembershipCacheDuration=").append(String.valueOf(this.groupMembershipCacheDuration));
        sb.append(", flushAllCaches=").append(String.valueOf(this.flushAllCaches));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThickAuthorizationResponse)) {
            return false;
        }
        ThickAuthorizationResponse other = (ThickAuthorizationResponse)((Object)o);
        return Objects.equals(this.policy, other.policy) && Objects.equals(this.policyCacheDuration, other.policyCacheDuration) && Objects.equals(this.groups, other.groups) && Objects.equals(this.groupMembershipCacheDuration, other.groupMembershipCacheDuration) && Objects.equals(this.flushAllCaches, other.flushAllCaches) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.policy == null ? 43 : this.policy.hashCode());
        result = result * 59 + (this.policyCacheDuration == null ? 43 : this.policyCacheDuration.hashCode());
        result = result * 59 + (this.groups == null ? 43 : this.groups.hashCode());
        result = result * 59 + (this.groupMembershipCacheDuration == null ? 43 : this.groupMembershipCacheDuration.hashCode());
        result = result * 59 + (this.flushAllCaches == null ? 43 : this.flushAllCaches.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="policy")
        private String policy;
        @JsonProperty(value="policyCacheDuration")
        private String policyCacheDuration;
        @JsonProperty(value="groups")
        private List<String> groups;
        @JsonProperty(value="groupMembershipCacheDuration")
        private String groupMembershipCacheDuration;
        @JsonProperty(value="flushAllCaches")
        private Boolean flushAllCaches;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder policy(String policy) {
            this.policy = policy;
            this.__explicitlySet__.add("policy");
            return this;
        }

        public Builder policyCacheDuration(String policyCacheDuration) {
            this.policyCacheDuration = policyCacheDuration;
            this.__explicitlySet__.add("policyCacheDuration");
            return this;
        }

        public Builder groups(List<String> groups) {
            this.groups = groups;
            this.__explicitlySet__.add("groups");
            return this;
        }

        public Builder groupMembershipCacheDuration(String groupMembershipCacheDuration) {
            this.groupMembershipCacheDuration = groupMembershipCacheDuration;
            this.__explicitlySet__.add("groupMembershipCacheDuration");
            return this;
        }

        public Builder flushAllCaches(Boolean flushAllCaches) {
            this.flushAllCaches = flushAllCaches;
            this.__explicitlySet__.add("flushAllCaches");
            return this;
        }

        public ThickAuthorizationResponse build() {
            ThickAuthorizationResponse model = new ThickAuthorizationResponse(this.policy, this.policyCacheDuration, this.groups, this.groupMembershipCacheDuration, this.flushAllCaches);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ThickAuthorizationResponse model) {
            if (model.wasPropertyExplicitlySet("policy")) {
                this.policy(model.getPolicy());
            }
            if (model.wasPropertyExplicitlySet("policyCacheDuration")) {
                this.policyCacheDuration(model.getPolicyCacheDuration());
            }
            if (model.wasPropertyExplicitlySet("groups")) {
                this.groups(model.getGroups());
            }
            if (model.wasPropertyExplicitlySet("groupMembershipCacheDuration")) {
                this.groupMembershipCacheDuration(model.getGroupMembershipCacheDuration());
            }
            if (model.wasPropertyExplicitlySet("flushAllCaches")) {
                this.flushAllCaches(model.getFlushAllCaches());
            }
            return this;
        }
    }
}

