/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RefreshRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currentToken")
    private final String currentToken;
    @JsonProperty(value="newPublicKey")
    private final String newPublicKey;

    @Deprecated
    @ConstructorProperties(value={"currentToken", "newPublicKey"})
    public RefreshRequest(String currentToken, String newPublicKey) {
        this.currentToken = currentToken;
        this.newPublicKey = newPublicKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public String getNewPublicKey() {
        return this.newPublicKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RefreshRequest(");
        sb.append("super=").append(super.toString());
        sb.append("currentToken=").append(String.valueOf(this.currentToken));
        sb.append(", newPublicKey=").append(String.valueOf(this.newPublicKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefreshRequest)) {
            return false;
        }
        RefreshRequest other = (RefreshRequest)((Object)o);
        return Objects.equals(this.currentToken, other.currentToken) && Objects.equals(this.newPublicKey, other.newPublicKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currentToken == null ? 43 : this.currentToken.hashCode());
        result = result * 59 + (this.newPublicKey == null ? 43 : this.newPublicKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentToken")
        private String currentToken;
        @JsonProperty(value="newPublicKey")
        private String newPublicKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentToken(String currentToken) {
            this.currentToken = currentToken;
            this.__explicitlySet__.add("currentToken");
            return this;
        }

        public Builder newPublicKey(String newPublicKey) {
            this.newPublicKey = newPublicKey;
            this.__explicitlySet__.add("newPublicKey");
            return this;
        }

        public RefreshRequest build() {
            RefreshRequest model = new RefreshRequest(this.currentToken, this.newPublicKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RefreshRequest model) {
            if (model.wasPropertyExplicitlySet("currentToken")) {
                this.currentToken(model.getCurrentToken());
            }
            if (model.wasPropertyExplicitlySet("newPublicKey")) {
                this.newPublicKey(model.getNewPublicKey());
            }
            return this;
        }
    }
}

