/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.Claim;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Principal
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subjectId")
    private final String subjectId;
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="claims")
    private final List<Claim> claims;

    @Deprecated
    @ConstructorProperties(value={"subjectId", "tenantId", "claims"})
    public Principal(String subjectId, String tenantId, List<Claim> claims) {
        this.subjectId = subjectId;
        this.tenantId = tenantId;
        this.claims = claims;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<Claim> getClaims() {
        return this.claims;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Principal(");
        sb.append("super=").append(super.toString());
        sb.append("subjectId=").append(String.valueOf(this.subjectId));
        sb.append(", tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", claims=").append(String.valueOf(this.claims));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)((Object)o);
        return Objects.equals(this.subjectId, other.subjectId) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.claims, other.claims) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subjectId == null ? 43 : this.subjectId.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.claims == null ? 43 : this.claims.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subjectId")
        private String subjectId;
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="claims")
        private List<Claim> claims;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            this.__explicitlySet__.add("subjectId");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder claims(List<Claim> claims) {
            this.claims = claims;
            this.__explicitlySet__.add("claims");
            return this;
        }

        public Principal build() {
            Principal model = new Principal(this.subjectId, this.tenantId, this.claims);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Principal model) {
            if (model.wasPropertyExplicitlySet("subjectId")) {
                this.subjectId(model.getSubjectId());
            }
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("claims")) {
                this.claims(model.getClaims());
            }
            return this;
        }
    }
}

