/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PasswordResetAuthenticationRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="passwordResetToken")
    private final String passwordResetToken;

    @Deprecated
    @ConstructorProperties(value={"userId", "passwordResetToken"})
    public PasswordResetAuthenticationRequest(String userId, String passwordResetToken) {
        this.userId = userId;
        this.passwordResetToken = passwordResetToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPasswordResetToken() {
        return this.passwordResetToken;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PasswordResetAuthenticationRequest(");
        sb.append("super=").append(super.toString());
        sb.append("userId=").append(String.valueOf(this.userId));
        sb.append(", passwordResetToken=").append(String.valueOf(this.passwordResetToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordResetAuthenticationRequest)) {
            return false;
        }
        PasswordResetAuthenticationRequest other = (PasswordResetAuthenticationRequest)((Object)o);
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.passwordResetToken, other.passwordResetToken) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.passwordResetToken == null ? 43 : this.passwordResetToken.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="passwordResetToken")
        private String passwordResetToken;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder passwordResetToken(String passwordResetToken) {
            this.passwordResetToken = passwordResetToken;
            this.__explicitlySet__.add("passwordResetToken");
            return this;
        }

        public PasswordResetAuthenticationRequest build() {
            PasswordResetAuthenticationRequest model = new PasswordResetAuthenticationRequest(this.userId, this.passwordResetToken);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PasswordResetAuthenticationRequest model) {
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("passwordResetToken")) {
                this.passwordResetToken(model.getPasswordResetToken());
            }
            return this;
        }
    }
}

