/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IdentityProvider
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="tenantName")
    private final String tenantName;
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="redirectUri")
    private final String redirectUri;
    @JsonProperty(value="signingCertificate")
    private final String signingCertificate;
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="serviceProviderEntityId")
    private final String serviceProviderEntityId;
    @JsonProperty(value="forceAuthentication")
    private final Boolean forceAuthentication;
    @JsonProperty(value="authnContextClassRefs")
    private final List<String> authnContextClassRefs;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "tenantName", "tenantId", "redirectUri", "signingCertificate", "protocol", "serviceProviderEntityId", "forceAuthentication", "authnContextClassRefs"})
    public IdentityProvider(String id, String name, String tenantName, String tenantId, String redirectUri, String signingCertificate, Protocol protocol, String serviceProviderEntityId, Boolean forceAuthentication, List<String> authnContextClassRefs) {
        this.id = id;
        this.name = name;
        this.tenantName = tenantName;
        this.tenantId = tenantId;
        this.redirectUri = redirectUri;
        this.signingCertificate = signingCertificate;
        this.protocol = protocol;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.forceAuthentication = forceAuthentication;
        this.authnContextClassRefs = authnContextClassRefs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public Boolean getForceAuthentication() {
        return this.forceAuthentication;
    }

    public List<String> getAuthnContextClassRefs() {
        return this.authnContextClassRefs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentityProvider(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", tenantName=").append(String.valueOf(this.tenantName));
        sb.append(", tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", redirectUri=").append(String.valueOf(this.redirectUri));
        sb.append(", signingCertificate=").append(String.valueOf(this.signingCertificate));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", serviceProviderEntityId=").append(String.valueOf(this.serviceProviderEntityId));
        sb.append(", forceAuthentication=").append(String.valueOf(this.forceAuthentication));
        sb.append(", authnContextClassRefs=").append(String.valueOf(this.authnContextClassRefs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider other = (IdentityProvider)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.tenantName, other.tenantName) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.redirectUri, other.redirectUri) && Objects.equals(this.signingCertificate, other.signingCertificate) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.serviceProviderEntityId, other.serviceProviderEntityId) && Objects.equals(this.forceAuthentication, other.forceAuthentication) && Objects.equals(this.authnContextClassRefs, other.authnContextClassRefs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.tenantName == null ? 43 : this.tenantName.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.redirectUri == null ? 43 : this.redirectUri.hashCode());
        result = result * 59 + (this.signingCertificate == null ? 43 : this.signingCertificate.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.serviceProviderEntityId == null ? 43 : this.serviceProviderEntityId.hashCode());
        result = result * 59 + (this.forceAuthentication == null ? 43 : this.forceAuthentication.hashCode());
        result = result * 59 + (this.authnContextClassRefs == null ? 43 : this.authnContextClassRefs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Saml2("SAML2");

        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Protocol: " + key);
        }

        static {
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="tenantName")
        private String tenantName;
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="redirectUri")
        private String redirectUri;
        @JsonProperty(value="signingCertificate")
        private String signingCertificate;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="serviceProviderEntityId")
        private String serviceProviderEntityId;
        @JsonProperty(value="forceAuthentication")
        private Boolean forceAuthentication;
        @JsonProperty(value="authnContextClassRefs")
        private List<String> authnContextClassRefs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            this.__explicitlySet__.add("tenantName");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            this.__explicitlySet__.add("redirectUri");
            return this;
        }

        public Builder signingCertificate(String signingCertificate) {
            this.signingCertificate = signingCertificate;
            this.__explicitlySet__.add("signingCertificate");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder serviceProviderEntityId(String serviceProviderEntityId) {
            this.serviceProviderEntityId = serviceProviderEntityId;
            this.__explicitlySet__.add("serviceProviderEntityId");
            return this;
        }

        public Builder forceAuthentication(Boolean forceAuthentication) {
            this.forceAuthentication = forceAuthentication;
            this.__explicitlySet__.add("forceAuthentication");
            return this;
        }

        public Builder authnContextClassRefs(List<String> authnContextClassRefs) {
            this.authnContextClassRefs = authnContextClassRefs;
            this.__explicitlySet__.add("authnContextClassRefs");
            return this;
        }

        public IdentityProvider build() {
            IdentityProvider model = new IdentityProvider(this.id, this.name, this.tenantName, this.tenantId, this.redirectUri, this.signingCertificate, this.protocol, this.serviceProviderEntityId, this.forceAuthentication, this.authnContextClassRefs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IdentityProvider model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("tenantName")) {
                this.tenantName(model.getTenantName());
            }
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("redirectUri")) {
                this.redirectUri(model.getRedirectUri());
            }
            if (model.wasPropertyExplicitlySet("signingCertificate")) {
                this.signingCertificate(model.getSigningCertificate());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("serviceProviderEntityId")) {
                this.serviceProviderEntityId(model.getServiceProviderEntityId());
            }
            if (model.wasPropertyExplicitlySet("forceAuthentication")) {
                this.forceAuthentication(model.getForceAuthentication());
            }
            if (model.wasPropertyExplicitlySet("authnContextClassRefs")) {
                this.authnContextClassRefs(model.getAuthnContextClassRefs());
            }
            return this;
        }
    }
}

