/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContextVariable
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="type")
    private final Type type;

    @Deprecated
    @ConstructorProperties(value={"name", "value", "type"})
    public ContextVariable(String name, String value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContextVariable(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextVariable)) {
            return false;
        }
        ContextVariable other = (ContextVariable)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.type, (Object)other.type) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        String("STRING"),
        Number("NUMBER"),
        Entity("ENTITY"),
        Boolean("BOOLEAN"),
        List("LIST");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="type")
        private Type type;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public ContextVariable build() {
            ContextVariable model = new ContextVariable(this.name, this.value, this.type);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContextVariable model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            return this;
        }
    }
}

