/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.PermissionContext;
import com.oracle.bmc.identitydataplane.model.Principal;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuthorizationRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="requestId")
    private final String requestId;
    @JsonProperty(value="userPrincipal")
    private final Principal userPrincipal;
    @JsonProperty(value="svcPrincipal")
    private final Principal svcPrincipal;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="context")
    private final List<PermissionContext> context;
    @JsonProperty(value="policyHash")
    private final String policyHash;

    @Deprecated
    @ConstructorProperties(value={"requestId", "userPrincipal", "svcPrincipal", "serviceName", "context", "policyHash"})
    public AuthorizationRequest(String requestId, Principal userPrincipal, Principal svcPrincipal, String serviceName, List<PermissionContext> context, String policyHash) {
        this.requestId = requestId;
        this.userPrincipal = userPrincipal;
        this.svcPrincipal = svcPrincipal;
        this.serviceName = serviceName;
        this.context = context;
        this.policyHash = policyHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Principal getSvcPrincipal() {
        return this.svcPrincipal;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<PermissionContext> getContext() {
        return this.context;
    }

    public String getPolicyHash() {
        return this.policyHash;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthorizationRequest(");
        sb.append("super=").append(super.toString());
        sb.append("requestId=").append(String.valueOf(this.requestId));
        sb.append(", userPrincipal=").append(String.valueOf((Object)this.userPrincipal));
        sb.append(", svcPrincipal=").append(String.valueOf((Object)this.svcPrincipal));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", context=").append(String.valueOf(this.context));
        sb.append(", policyHash=").append(String.valueOf(this.policyHash));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizationRequest)) {
            return false;
        }
        AuthorizationRequest other = (AuthorizationRequest)((Object)o);
        return Objects.equals(this.requestId, other.requestId) && Objects.equals((Object)this.userPrincipal, (Object)other.userPrincipal) && Objects.equals((Object)this.svcPrincipal, (Object)other.svcPrincipal) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.context, other.context) && Objects.equals(this.policyHash, other.policyHash) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.requestId == null ? 43 : this.requestId.hashCode());
        result = result * 59 + (this.userPrincipal == null ? 43 : this.userPrincipal.hashCode());
        result = result * 59 + (this.svcPrincipal == null ? 43 : this.svcPrincipal.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.context == null ? 43 : this.context.hashCode());
        result = result * 59 + (this.policyHash == null ? 43 : this.policyHash.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="requestId")
        private String requestId;
        @JsonProperty(value="userPrincipal")
        private Principal userPrincipal;
        @JsonProperty(value="svcPrincipal")
        private Principal svcPrincipal;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="context")
        private List<PermissionContext> context;
        @JsonProperty(value="policyHash")
        private String policyHash;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            this.__explicitlySet__.add("requestId");
            return this;
        }

        public Builder userPrincipal(Principal userPrincipal) {
            this.userPrincipal = userPrincipal;
            this.__explicitlySet__.add("userPrincipal");
            return this;
        }

        public Builder svcPrincipal(Principal svcPrincipal) {
            this.svcPrincipal = svcPrincipal;
            this.__explicitlySet__.add("svcPrincipal");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder context(List<PermissionContext> context) {
            this.context = context;
            this.__explicitlySet__.add("context");
            return this;
        }

        public Builder policyHash(String policyHash) {
            this.policyHash = policyHash;
            this.__explicitlySet__.add("policyHash");
            return this;
        }

        public AuthorizationRequest build() {
            AuthorizationRequest model = new AuthorizationRequest(this.requestId, this.userPrincipal, this.svcPrincipal, this.serviceName, this.context, this.policyHash);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuthorizationRequest model) {
            if (model.wasPropertyExplicitlySet("requestId")) {
                this.requestId(model.getRequestId());
            }
            if (model.wasPropertyExplicitlySet("userPrincipal")) {
                this.userPrincipal(model.getUserPrincipal());
            }
            if (model.wasPropertyExplicitlySet("svcPrincipal")) {
                this.svcPrincipal(model.getSvcPrincipal());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("context")) {
                this.context(model.getContext());
            }
            if (model.wasPropertyExplicitlySet("policyHash")) {
                this.policyHash(model.getPolicyHash());
            }
            return this;
        }
    }
}

