/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.PasswordPolicy;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuthenticationPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="passwordPolicy")
    private final PasswordPolicy passwordPolicy;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;

    @Deprecated
    @ConstructorProperties(value={"passwordPolicy", "compartmentId"})
    public AuthenticationPolicy(PasswordPolicy passwordPolicy, String compartmentId) {
        this.passwordPolicy = passwordPolicy;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("passwordPolicy=").append(String.valueOf((Object)this.passwordPolicy));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticationPolicy)) {
            return false;
        }
        AuthenticationPolicy other = (AuthenticationPolicy)((Object)o);
        return Objects.equals((Object)this.passwordPolicy, (Object)other.passwordPolicy) && Objects.equals(this.compartmentId, other.compartmentId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.passwordPolicy == null ? 43 : this.passwordPolicy.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="passwordPolicy")
        private PasswordPolicy passwordPolicy;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder passwordPolicy(PasswordPolicy passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            this.__explicitlySet__.add("passwordPolicy");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public AuthenticationPolicy build() {
            AuthenticationPolicy model = new AuthenticationPolicy(this.passwordPolicy, this.compartmentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuthenticationPolicy model) {
            if (model.wasPropertyExplicitlySet("passwordPolicy")) {
                this.passwordPolicy(model.getPasswordPolicy());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            return this;
        }
    }
}

