/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRuleLifecycleState;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRuleType;
import com.oracle.bmc.governancerulescontrolplane.model.Template;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EnforcedGovernanceRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="governanceRuleDisplayName")
    private final String governanceRuleDisplayName;
    @JsonProperty(value="type")
    private final GovernanceRuleType type;
    @JsonProperty(value="template")
    private final Template template;
    @JsonProperty(value="lifecycleState")
    private final GovernanceRuleLifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "governanceRuleDisplayName", "type", "template", "lifecycleState", "timeCreated", "timeUpdated"})
    public EnforcedGovernanceRule(String id, String compartmentId, String governanceRuleDisplayName, GovernanceRuleType type, Template template, GovernanceRuleLifecycleState lifecycleState, Date timeCreated, Date timeUpdated) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.governanceRuleDisplayName = governanceRuleDisplayName;
        this.type = type;
        this.template = template;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getGovernanceRuleDisplayName() {
        return this.governanceRuleDisplayName;
    }

    public GovernanceRuleType getType() {
        return this.type;
    }

    public Template getTemplate() {
        return this.template;
    }

    public GovernanceRuleLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EnforcedGovernanceRule(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", governanceRuleDisplayName=").append(String.valueOf(this.governanceRuleDisplayName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", template=").append(String.valueOf((Object)this.template));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnforcedGovernanceRule)) {
            return false;
        }
        EnforcedGovernanceRule other = (EnforcedGovernanceRule)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.governanceRuleDisplayName, other.governanceRuleDisplayName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.template, (Object)other.template) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.governanceRuleDisplayName == null ? 43 : this.governanceRuleDisplayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.template == null ? 43 : this.template.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="governanceRuleDisplayName")
        private String governanceRuleDisplayName;
        @JsonProperty(value="type")
        private GovernanceRuleType type;
        @JsonProperty(value="template")
        private Template template;
        @JsonProperty(value="lifecycleState")
        private GovernanceRuleLifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder governanceRuleDisplayName(String governanceRuleDisplayName) {
            this.governanceRuleDisplayName = governanceRuleDisplayName;
            this.__explicitlySet__.add("governanceRuleDisplayName");
            return this;
        }

        public Builder type(GovernanceRuleType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder template(Template template) {
            this.template = template;
            this.__explicitlySet__.add("template");
            return this;
        }

        public Builder lifecycleState(GovernanceRuleLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public EnforcedGovernanceRule build() {
            EnforcedGovernanceRule model = new EnforcedGovernanceRule(this.id, this.compartmentId, this.governanceRuleDisplayName, this.type, this.template, this.lifecycleState, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EnforcedGovernanceRule model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("governanceRuleDisplayName")) {
                this.governanceRuleDisplayName(model.getGovernanceRuleDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("template")) {
                this.template(model.getTemplate());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

