/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.genericartifactscontent.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetGenericArtifactContentRequest
extends BmcRequest<Void> {
    private String artifactId;
    private String opcRequestId;

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().artifactId(this.artifactId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",artifactId=").append(String.valueOf(this.artifactId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetGenericArtifactContentRequest)) {
            return false;
        }
        GetGenericArtifactContentRequest other = (GetGenericArtifactContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.artifactId == null ? 43 : this.artifactId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGenericArtifactContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String artifactId = null;
        private String opcRequestId = null;

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGenericArtifactContentRequest o) {
            this.artifactId(o.getArtifactId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGenericArtifactContentRequest build() {
            GetGenericArtifactContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetGenericArtifactContentRequest buildWithoutInvocationCallback() {
            GetGenericArtifactContentRequest request = new GetGenericArtifactContentRequest();
            request.artifactId = this.artifactId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

