/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.ServingMode;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeTextDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="input")
    private final String input;
    @JsonProperty(value="servingMode")
    private final ServingMode servingMode;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="additionalCommand")
    private final String additionalCommand;
    @JsonProperty(value="length")
    private final Length length;
    @JsonProperty(value="format")
    private final Format format;
    @JsonProperty(value="extractiveness")
    private final Extractiveness extractiveness;

    @Deprecated
    @ConstructorProperties(value={"input", "servingMode", "compartmentId", "isEcho", "temperature", "additionalCommand", "length", "format", "extractiveness"})
    public SummarizeTextDetails(String input, ServingMode servingMode, String compartmentId, Boolean isEcho, Double temperature, String additionalCommand, Length length, Format format, Extractiveness extractiveness) {
        this.input = input;
        this.servingMode = servingMode;
        this.compartmentId = compartmentId;
        this.isEcho = isEcho;
        this.temperature = temperature;
        this.additionalCommand = additionalCommand;
        this.length = length;
        this.format = format;
        this.extractiveness = extractiveness;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInput() {
        return this.input;
    }

    public ServingMode getServingMode() {
        return this.servingMode;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String getAdditionalCommand() {
        return this.additionalCommand;
    }

    public Length getLength() {
        return this.length;
    }

    public Format getFormat() {
        return this.format;
    }

    public Extractiveness getExtractiveness() {
        return this.extractiveness;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeTextDetails(");
        sb.append("super=").append(super.toString());
        sb.append("input=").append(String.valueOf(this.input));
        sb.append(", servingMode=").append(String.valueOf((Object)this.servingMode));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", temperature=").append(String.valueOf(this.temperature));
        sb.append(", additionalCommand=").append(String.valueOf(this.additionalCommand));
        sb.append(", length=").append(String.valueOf((Object)this.length));
        sb.append(", format=").append(String.valueOf((Object)this.format));
        sb.append(", extractiveness=").append(String.valueOf((Object)this.extractiveness));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeTextDetails)) {
            return false;
        }
        SummarizeTextDetails other = (SummarizeTextDetails)((Object)o);
        return Objects.equals(this.input, other.input) && Objects.equals((Object)this.servingMode, (Object)other.servingMode) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.additionalCommand, other.additionalCommand) && Objects.equals((Object)this.length, (Object)other.length) && Objects.equals((Object)this.format, (Object)other.format) && Objects.equals((Object)this.extractiveness, (Object)other.extractiveness) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.input == null ? 43 : this.input.hashCode());
        result = result * 59 + (this.servingMode == null ? 43 : this.servingMode.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.temperature == null ? 43 : this.temperature.hashCode());
        result = result * 59 + (this.additionalCommand == null ? 43 : this.additionalCommand.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        result = result * 59 + (this.format == null ? 43 : this.format.hashCode());
        result = result * 59 + (this.extractiveness == null ? 43 : this.extractiveness.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Extractiveness implements BmcEnum
    {
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH"),
        Auto("AUTO");

        private final String value;
        private static Map<String, Extractiveness> map;

        private Extractiveness(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Extractiveness create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Extractiveness: " + key);
        }

        static {
            map = new HashMap<String, Extractiveness>();
            for (Extractiveness v : Extractiveness.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Format implements BmcEnum
    {
        Paragraph("PARAGRAPH"),
        Bullets("BULLETS"),
        Auto("AUTO");

        private final String value;
        private static Map<String, Format> map;

        private Format(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Format create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Format: " + key);
        }

        static {
            map = new HashMap<String, Format>();
            for (Format v : Format.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Length implements BmcEnum
    {
        Short("SHORT"),
        Medium("MEDIUM"),
        Long("LONG"),
        Auto("AUTO");

        private final String value;
        private static Map<String, Length> map;

        private Length(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Length create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Length: " + key);
        }

        static {
            map = new HashMap<String, Length>();
            for (Length v : Length.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="input")
        private String input;
        @JsonProperty(value="servingMode")
        private ServingMode servingMode;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="temperature")
        private Double temperature;
        @JsonProperty(value="additionalCommand")
        private String additionalCommand;
        @JsonProperty(value="length")
        private Length length;
        @JsonProperty(value="format")
        private Format format;
        @JsonProperty(value="extractiveness")
        private Extractiveness extractiveness;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder input(String input) {
            this.input = input;
            this.__explicitlySet__.add("input");
            return this;
        }

        public Builder servingMode(ServingMode servingMode) {
            this.servingMode = servingMode;
            this.__explicitlySet__.add("servingMode");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            this.__explicitlySet__.add("temperature");
            return this;
        }

        public Builder additionalCommand(String additionalCommand) {
            this.additionalCommand = additionalCommand;
            this.__explicitlySet__.add("additionalCommand");
            return this;
        }

        public Builder length(Length length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public Builder format(Format format) {
            this.format = format;
            this.__explicitlySet__.add("format");
            return this;
        }

        public Builder extractiveness(Extractiveness extractiveness) {
            this.extractiveness = extractiveness;
            this.__explicitlySet__.add("extractiveness");
            return this;
        }

        public SummarizeTextDetails build() {
            SummarizeTextDetails model = new SummarizeTextDetails(this.input, this.servingMode, this.compartmentId, this.isEcho, this.temperature, this.additionalCommand, this.length, this.format, this.extractiveness);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeTextDetails model) {
            if (model.wasPropertyExplicitlySet("input")) {
                this.input(model.getInput());
            }
            if (model.wasPropertyExplicitlySet("servingMode")) {
                this.servingMode(model.getServingMode());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("temperature")) {
                this.temperature(model.getTemperature());
            }
            if (model.wasPropertyExplicitlySet("additionalCommand")) {
                this.additionalCommand(model.getAdditionalCommand());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            if (model.wasPropertyExplicitlySet("format")) {
                this.format(model.getFormat());
            }
            if (model.wasPropertyExplicitlySet("extractiveness")) {
                this.extractiveness(model.getExtractiveness());
            }
            return this;
        }
    }
}

