/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GroundingWebChunk
extends ExplicitlySetBmcModel {
    @JsonProperty(value="uri")
    private final String uri;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="domain")
    private final String domain;

    @Deprecated
    @ConstructorProperties(value={"uri", "title", "domain"})
    public GroundingWebChunk(String uri, String title, String domain) {
        this.uri = uri;
        this.title = title;
        this.domain = domain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUri() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GroundingWebChunk(");
        sb.append("super=").append(super.toString());
        sb.append("uri=").append(String.valueOf(this.uri));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroundingWebChunk)) {
            return false;
        }
        GroundingWebChunk other = (GroundingWebChunk)((Object)o);
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.title, other.title) && Objects.equals(this.domain, other.domain) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="domain")
        private String domain;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public GroundingWebChunk build() {
            GroundingWebChunk model = new GroundingWebChunk(this.uri, this.title, this.domain);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GroundingWebChunk model) {
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            return this;
        }
    }
}

