/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.ServingMode;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EmbedTextDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="inputs")
    private final List<String> inputs;
    @JsonProperty(value="servingMode")
    private final ServingMode servingMode;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="truncate")
    private final Truncate truncate;
    @JsonProperty(value="inputType")
    private final InputType inputType;

    @Deprecated
    @ConstructorProperties(value={"inputs", "servingMode", "compartmentId", "isEcho", "truncate", "inputType"})
    public EmbedTextDetails(List<String> inputs, ServingMode servingMode, String compartmentId, Boolean isEcho, Truncate truncate, InputType inputType) {
        this.inputs = inputs;
        this.servingMode = servingMode;
        this.compartmentId = compartmentId;
        this.isEcho = isEcho;
        this.truncate = truncate;
        this.inputType = inputType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public ServingMode getServingMode() {
        return this.servingMode;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public Truncate getTruncate() {
        return this.truncate;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmbedTextDetails(");
        sb.append("super=").append(super.toString());
        sb.append("inputs=").append(String.valueOf(this.inputs));
        sb.append(", servingMode=").append(String.valueOf((Object)this.servingMode));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", truncate=").append(String.valueOf((Object)this.truncate));
        sb.append(", inputType=").append(String.valueOf((Object)this.inputType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbedTextDetails)) {
            return false;
        }
        EmbedTextDetails other = (EmbedTextDetails)((Object)o);
        return Objects.equals(this.inputs, other.inputs) && Objects.equals((Object)this.servingMode, (Object)other.servingMode) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals((Object)this.truncate, (Object)other.truncate) && Objects.equals((Object)this.inputType, (Object)other.inputType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.inputs == null ? 43 : this.inputs.hashCode());
        result = result * 59 + (this.servingMode == null ? 43 : this.servingMode.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.truncate == null ? 43 : this.truncate.hashCode());
        result = result * 59 + (this.inputType == null ? 43 : this.inputType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InputType implements BmcEnum
    {
        SearchDocument("SEARCH_DOCUMENT"),
        SearchQuery("SEARCH_QUERY"),
        Classification("CLASSIFICATION"),
        Clustering("CLUSTERING"),
        Image("IMAGE");

        private final String value;
        private static Map<String, InputType> map;

        private InputType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InputType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid InputType: " + key);
        }

        static {
            map = new HashMap<String, InputType>();
            for (InputType v : InputType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Truncate implements BmcEnum
    {
        None("NONE"),
        Start("START"),
        End("END");

        private final String value;
        private static Map<String, Truncate> map;

        private Truncate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Truncate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Truncate: " + key);
        }

        static {
            map = new HashMap<String, Truncate>();
            for (Truncate v : Truncate.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="inputs")
        private List<String> inputs;
        @JsonProperty(value="servingMode")
        private ServingMode servingMode;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="truncate")
        private Truncate truncate;
        @JsonProperty(value="inputType")
        private InputType inputType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder inputs(List<String> inputs) {
            this.inputs = inputs;
            this.__explicitlySet__.add("inputs");
            return this;
        }

        public Builder servingMode(ServingMode servingMode) {
            this.servingMode = servingMode;
            this.__explicitlySet__.add("servingMode");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder truncate(Truncate truncate) {
            this.truncate = truncate;
            this.__explicitlySet__.add("truncate");
            return this;
        }

        public Builder inputType(InputType inputType) {
            this.inputType = inputType;
            this.__explicitlySet__.add("inputType");
            return this;
        }

        public EmbedTextDetails build() {
            EmbedTextDetails model = new EmbedTextDetails(this.inputs, this.servingMode, this.compartmentId, this.isEcho, this.truncate, this.inputType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmbedTextDetails model) {
            if (model.wasPropertyExplicitlySet("inputs")) {
                this.inputs(model.getInputs());
            }
            if (model.wasPropertyExplicitlySet("servingMode")) {
                this.servingMode(model.getServingMode());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("truncate")) {
                this.truncate(model.getTruncate());
            }
            if (model.wasPropertyExplicitlySet("inputType")) {
                this.inputType(model.getInputType());
            }
            return this;
        }
    }
}

