/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.LlmInferenceRequest;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="runtimeType")
@JsonFilter(value="explicitlySetFilter")
public final class CohereLlmInferenceRequest
extends LlmInferenceRequest {
    @JsonProperty(value="prompt")
    private final String prompt;
    @JsonProperty(value="isStream")
    private final Boolean isStream;
    @JsonProperty(value="numGenerations")
    private final Integer numGenerations;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="maxTokens")
    private final Integer maxTokens;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="topK")
    private final Integer topK;
    @JsonProperty(value="topP")
    private final Double topP;
    @JsonProperty(value="frequencyPenalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private final Double presencePenalty;
    @JsonProperty(value="stopSequences")
    private final List<String> stopSequences;
    @JsonProperty(value="returnLikelihoods")
    private final ReturnLikelihoods returnLikelihoods;
    @JsonProperty(value="truncate")
    private final Truncate truncate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CohereLlmInferenceRequest(String prompt, Boolean isStream, Integer numGenerations, Boolean isEcho, Integer maxTokens, Double temperature, Integer topK, Double topP, Double frequencyPenalty, Double presencePenalty, List<String> stopSequences, ReturnLikelihoods returnLikelihoods, Truncate truncate) {
        this.prompt = prompt;
        this.isStream = isStream;
        this.numGenerations = numGenerations;
        this.isEcho = isEcho;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topK = topK;
        this.topP = topP;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.stopSequences = stopSequences;
        this.returnLikelihoods = returnLikelihoods;
        this.truncate = truncate;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Boolean getIsStream() {
        return this.isStream;
    }

    public Integer getNumGenerations() {
        return this.numGenerations;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public ReturnLikelihoods getReturnLikelihoods() {
        return this.returnLikelihoods;
    }

    public Truncate getTruncate() {
        return this.truncate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereLlmInferenceRequest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", prompt=").append(String.valueOf(this.prompt));
        sb.append(", isStream=").append(String.valueOf(this.isStream));
        sb.append(", numGenerations=").append(String.valueOf(this.numGenerations));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", maxTokens=").append(String.valueOf(this.maxTokens));
        sb.append(", temperature=").append(String.valueOf(this.temperature));
        sb.append(", topK=").append(String.valueOf(this.topK));
        sb.append(", topP=").append(String.valueOf(this.topP));
        sb.append(", frequencyPenalty=").append(String.valueOf(this.frequencyPenalty));
        sb.append(", presencePenalty=").append(String.valueOf(this.presencePenalty));
        sb.append(", stopSequences=").append(String.valueOf(this.stopSequences));
        sb.append(", returnLikelihoods=").append(String.valueOf((Object)this.returnLikelihoods));
        sb.append(", truncate=").append(String.valueOf((Object)this.truncate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereLlmInferenceRequest)) {
            return false;
        }
        CohereLlmInferenceRequest other = (CohereLlmInferenceRequest)((Object)o);
        return Objects.equals(this.prompt, other.prompt) && Objects.equals(this.isStream, other.isStream) && Objects.equals(this.numGenerations, other.numGenerations) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals(this.maxTokens, other.maxTokens) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.topK, other.topK) && Objects.equals(this.topP, other.topP) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.stopSequences, other.stopSequences) && Objects.equals((Object)this.returnLikelihoods, (Object)other.returnLikelihoods) && Objects.equals((Object)this.truncate, (Object)other.truncate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.prompt == null ? 43 : this.prompt.hashCode());
        result = result * 59 + (this.isStream == null ? 43 : this.isStream.hashCode());
        result = result * 59 + (this.numGenerations == null ? 43 : this.numGenerations.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.maxTokens == null ? 43 : this.maxTokens.hashCode());
        result = result * 59 + (this.temperature == null ? 43 : this.temperature.hashCode());
        result = result * 59 + (this.topK == null ? 43 : this.topK.hashCode());
        result = result * 59 + (this.topP == null ? 43 : this.topP.hashCode());
        result = result * 59 + (this.frequencyPenalty == null ? 43 : this.frequencyPenalty.hashCode());
        result = result * 59 + (this.presencePenalty == null ? 43 : this.presencePenalty.hashCode());
        result = result * 59 + (this.stopSequences == null ? 43 : this.stopSequences.hashCode());
        result = result * 59 + (this.returnLikelihoods == null ? 43 : this.returnLikelihoods.hashCode());
        result = result * 59 + (this.truncate == null ? 43 : this.truncate.hashCode());
        return result;
    }

    public static enum Truncate implements BmcEnum
    {
        None("NONE"),
        Start("START"),
        End("END");

        private final String value;
        private static Map<String, Truncate> map;

        private Truncate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Truncate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Truncate: " + key);
        }

        static {
            map = new HashMap<String, Truncate>();
            for (Truncate v : Truncate.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ReturnLikelihoods implements BmcEnum
    {
        None("NONE"),
        All("ALL"),
        Generation("GENERATION");

        private final String value;
        private static Map<String, ReturnLikelihoods> map;

        private ReturnLikelihoods(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReturnLikelihoods create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReturnLikelihoods: " + key);
        }

        static {
            map = new HashMap<String, ReturnLikelihoods>();
            for (ReturnLikelihoods v : ReturnLikelihoods.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="prompt")
        private String prompt;
        @JsonProperty(value="isStream")
        private Boolean isStream;
        @JsonProperty(value="numGenerations")
        private Integer numGenerations;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="maxTokens")
        private Integer maxTokens;
        @JsonProperty(value="temperature")
        private Double temperature;
        @JsonProperty(value="topK")
        private Integer topK;
        @JsonProperty(value="topP")
        private Double topP;
        @JsonProperty(value="frequencyPenalty")
        private Double frequencyPenalty;
        @JsonProperty(value="presencePenalty")
        private Double presencePenalty;
        @JsonProperty(value="stopSequences")
        private List<String> stopSequences;
        @JsonProperty(value="returnLikelihoods")
        private ReturnLikelihoods returnLikelihoods;
        @JsonProperty(value="truncate")
        private Truncate truncate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            this.__explicitlySet__.add("prompt");
            return this;
        }

        public Builder isStream(Boolean isStream) {
            this.isStream = isStream;
            this.__explicitlySet__.add("isStream");
            return this;
        }

        public Builder numGenerations(Integer numGenerations) {
            this.numGenerations = numGenerations;
            this.__explicitlySet__.add("numGenerations");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            this.__explicitlySet__.add("maxTokens");
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            this.__explicitlySet__.add("temperature");
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            this.__explicitlySet__.add("topK");
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            this.__explicitlySet__.add("topP");
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            this.__explicitlySet__.add("frequencyPenalty");
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            this.__explicitlySet__.add("presencePenalty");
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            this.__explicitlySet__.add("stopSequences");
            return this;
        }

        public Builder returnLikelihoods(ReturnLikelihoods returnLikelihoods) {
            this.returnLikelihoods = returnLikelihoods;
            this.__explicitlySet__.add("returnLikelihoods");
            return this;
        }

        public Builder truncate(Truncate truncate) {
            this.truncate = truncate;
            this.__explicitlySet__.add("truncate");
            return this;
        }

        public CohereLlmInferenceRequest build() {
            CohereLlmInferenceRequest model = new CohereLlmInferenceRequest(this.prompt, this.isStream, this.numGenerations, this.isEcho, this.maxTokens, this.temperature, this.topK, this.topP, this.frequencyPenalty, this.presencePenalty, this.stopSequences, this.returnLikelihoods, this.truncate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereLlmInferenceRequest model) {
            if (model.wasPropertyExplicitlySet("prompt")) {
                this.prompt(model.getPrompt());
            }
            if (model.wasPropertyExplicitlySet("isStream")) {
                this.isStream(model.getIsStream());
            }
            if (model.wasPropertyExplicitlySet("numGenerations")) {
                this.numGenerations(model.getNumGenerations());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("maxTokens")) {
                this.maxTokens(model.getMaxTokens());
            }
            if (model.wasPropertyExplicitlySet("temperature")) {
                this.temperature(model.getTemperature());
            }
            if (model.wasPropertyExplicitlySet("topK")) {
                this.topK(model.getTopK());
            }
            if (model.wasPropertyExplicitlySet("topP")) {
                this.topP(model.getTopP());
            }
            if (model.wasPropertyExplicitlySet("frequencyPenalty")) {
                this.frequencyPenalty(model.getFrequencyPenalty());
            }
            if (model.wasPropertyExplicitlySet("presencePenalty")) {
                this.presencePenalty(model.getPresencePenalty());
            }
            if (model.wasPropertyExplicitlySet("stopSequences")) {
                this.stopSequences(model.getStopSequences());
            }
            if (model.wasPropertyExplicitlySet("returnLikelihoods")) {
                this.returnLikelihoods(model.getReturnLikelihoods());
            }
            if (model.wasPropertyExplicitlySet("truncate")) {
                this.truncate(model.getTruncate());
            }
            return this;
        }
    }
}

