/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.LlmInferenceRequest;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="runtimeType")
@JsonFilter(value="explicitlySetFilter")
public final class LlamaLlmInferenceRequest
extends LlmInferenceRequest {
    @JsonProperty(value="prompt")
    private final String prompt;
    @JsonProperty(value="isStream")
    private final Boolean isStream;
    @JsonProperty(value="numGenerations")
    private final Integer numGenerations;
    @JsonProperty(value="isEcho")
    private final Boolean isEcho;
    @JsonProperty(value="topK")
    private final Integer topK;
    @JsonProperty(value="topP")
    private final Double topP;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="frequencyPenalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private final Double presencePenalty;
    @JsonProperty(value="stop")
    private final List<String> stop;
    @JsonProperty(value="logProbs")
    private final Integer logProbs;
    @JsonProperty(value="maxTokens")
    private final Integer maxTokens;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LlamaLlmInferenceRequest(String prompt, Boolean isStream, Integer numGenerations, Boolean isEcho, Integer topK, Double topP, Double temperature, Double frequencyPenalty, Double presencePenalty, List<String> stop, Integer logProbs, Integer maxTokens) {
        this.prompt = prompt;
        this.isStream = isStream;
        this.numGenerations = numGenerations;
        this.isEcho = isEcho;
        this.topK = topK;
        this.topP = topP;
        this.temperature = temperature;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.stop = stop;
        this.logProbs = logProbs;
        this.maxTokens = maxTokens;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Boolean getIsStream() {
        return this.isStream;
    }

    public Integer getNumGenerations() {
        return this.numGenerations;
    }

    public Boolean getIsEcho() {
        return this.isEcho;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getLogProbs() {
        return this.logProbs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LlamaLlmInferenceRequest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", prompt=").append(String.valueOf(this.prompt));
        sb.append(", isStream=").append(String.valueOf(this.isStream));
        sb.append(", numGenerations=").append(String.valueOf(this.numGenerations));
        sb.append(", isEcho=").append(String.valueOf(this.isEcho));
        sb.append(", topK=").append(String.valueOf(this.topK));
        sb.append(", topP=").append(String.valueOf(this.topP));
        sb.append(", temperature=").append(String.valueOf(this.temperature));
        sb.append(", frequencyPenalty=").append(String.valueOf(this.frequencyPenalty));
        sb.append(", presencePenalty=").append(String.valueOf(this.presencePenalty));
        sb.append(", stop=").append(String.valueOf(this.stop));
        sb.append(", logProbs=").append(String.valueOf(this.logProbs));
        sb.append(", maxTokens=").append(String.valueOf(this.maxTokens));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LlamaLlmInferenceRequest)) {
            return false;
        }
        LlamaLlmInferenceRequest other = (LlamaLlmInferenceRequest)((Object)o);
        return Objects.equals(this.prompt, other.prompt) && Objects.equals(this.isStream, other.isStream) && Objects.equals(this.numGenerations, other.numGenerations) && Objects.equals(this.isEcho, other.isEcho) && Objects.equals(this.topK, other.topK) && Objects.equals(this.topP, other.topP) && Objects.equals(this.temperature, other.temperature) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty) && Objects.equals(this.presencePenalty, other.presencePenalty) && Objects.equals(this.stop, other.stop) && Objects.equals(this.logProbs, other.logProbs) && Objects.equals(this.maxTokens, other.maxTokens) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.prompt == null ? 43 : this.prompt.hashCode());
        result = result * 59 + (this.isStream == null ? 43 : this.isStream.hashCode());
        result = result * 59 + (this.numGenerations == null ? 43 : this.numGenerations.hashCode());
        result = result * 59 + (this.isEcho == null ? 43 : this.isEcho.hashCode());
        result = result * 59 + (this.topK == null ? 43 : this.topK.hashCode());
        result = result * 59 + (this.topP == null ? 43 : this.topP.hashCode());
        result = result * 59 + (this.temperature == null ? 43 : this.temperature.hashCode());
        result = result * 59 + (this.frequencyPenalty == null ? 43 : this.frequencyPenalty.hashCode());
        result = result * 59 + (this.presencePenalty == null ? 43 : this.presencePenalty.hashCode());
        result = result * 59 + (this.stop == null ? 43 : this.stop.hashCode());
        result = result * 59 + (this.logProbs == null ? 43 : this.logProbs.hashCode());
        result = result * 59 + (this.maxTokens == null ? 43 : this.maxTokens.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="prompt")
        private String prompt;
        @JsonProperty(value="isStream")
        private Boolean isStream;
        @JsonProperty(value="numGenerations")
        private Integer numGenerations;
        @JsonProperty(value="isEcho")
        private Boolean isEcho;
        @JsonProperty(value="topK")
        private Integer topK;
        @JsonProperty(value="topP")
        private Double topP;
        @JsonProperty(value="temperature")
        private Double temperature;
        @JsonProperty(value="frequencyPenalty")
        private Double frequencyPenalty;
        @JsonProperty(value="presencePenalty")
        private Double presencePenalty;
        @JsonProperty(value="stop")
        private List<String> stop;
        @JsonProperty(value="logProbs")
        private Integer logProbs;
        @JsonProperty(value="maxTokens")
        private Integer maxTokens;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder prompt(String prompt) {
            this.prompt = prompt;
            this.__explicitlySet__.add("prompt");
            return this;
        }

        public Builder isStream(Boolean isStream) {
            this.isStream = isStream;
            this.__explicitlySet__.add("isStream");
            return this;
        }

        public Builder numGenerations(Integer numGenerations) {
            this.numGenerations = numGenerations;
            this.__explicitlySet__.add("numGenerations");
            return this;
        }

        public Builder isEcho(Boolean isEcho) {
            this.isEcho = isEcho;
            this.__explicitlySet__.add("isEcho");
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            this.__explicitlySet__.add("topK");
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            this.__explicitlySet__.add("topP");
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            this.__explicitlySet__.add("temperature");
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            this.__explicitlySet__.add("frequencyPenalty");
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            this.__explicitlySet__.add("presencePenalty");
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            this.__explicitlySet__.add("stop");
            return this;
        }

        public Builder logProbs(Integer logProbs) {
            this.logProbs = logProbs;
            this.__explicitlySet__.add("logProbs");
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            this.__explicitlySet__.add("maxTokens");
            return this;
        }

        public LlamaLlmInferenceRequest build() {
            LlamaLlmInferenceRequest model = new LlamaLlmInferenceRequest(this.prompt, this.isStream, this.numGenerations, this.isEcho, this.topK, this.topP, this.temperature, this.frequencyPenalty, this.presencePenalty, this.stop, this.logProbs, this.maxTokens);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LlamaLlmInferenceRequest model) {
            if (model.wasPropertyExplicitlySet("prompt")) {
                this.prompt(model.getPrompt());
            }
            if (model.wasPropertyExplicitlySet("isStream")) {
                this.isStream(model.getIsStream());
            }
            if (model.wasPropertyExplicitlySet("numGenerations")) {
                this.numGenerations(model.getNumGenerations());
            }
            if (model.wasPropertyExplicitlySet("isEcho")) {
                this.isEcho(model.getIsEcho());
            }
            if (model.wasPropertyExplicitlySet("topK")) {
                this.topK(model.getTopK());
            }
            if (model.wasPropertyExplicitlySet("topP")) {
                this.topP(model.getTopP());
            }
            if (model.wasPropertyExplicitlySet("temperature")) {
                this.temperature(model.getTemperature());
            }
            if (model.wasPropertyExplicitlySet("frequencyPenalty")) {
                this.frequencyPenalty(model.getFrequencyPenalty());
            }
            if (model.wasPropertyExplicitlySet("presencePenalty")) {
                this.presencePenalty(model.getPresencePenalty());
            }
            if (model.wasPropertyExplicitlySet("stop")) {
                this.stop(model.getStop());
            }
            if (model.wasPropertyExplicitlySet("logProbs")) {
                this.logProbs(model.getLogProbs());
            }
            if (model.wasPropertyExplicitlySet("maxTokens")) {
                this.maxTokens(model.getMaxTokens());
            }
            return this;
        }
    }
}

