/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.BaseChatResponse;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ChatResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelId")
    private final String modelId;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="chatResponse")
    private final BaseChatResponse chatResponse;

    @Deprecated
    @ConstructorProperties(value={"modelId", "modelVersion", "chatResponse"})
    public ChatResult(String modelId, String modelVersion, BaseChatResponse chatResponse) {
        this.modelId = modelId;
        this.modelVersion = modelVersion;
        this.chatResponse = chatResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public BaseChatResponse getChatResponse() {
        return this.chatResponse;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChatResult(");
        sb.append("super=").append(super.toString());
        sb.append("modelId=").append(String.valueOf(this.modelId));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", chatResponse=").append(String.valueOf((Object)this.chatResponse));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatResult)) {
            return false;
        }
        ChatResult other = (ChatResult)((Object)o);
        return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.chatResponse, (Object)other.chatResponse) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.chatResponse == null ? 43 : this.chatResponse.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="chatResponse")
        private BaseChatResponse chatResponse;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder chatResponse(BaseChatResponse chatResponse) {
            this.chatResponse = chatResponse;
            this.__explicitlySet__.add("chatResponse");
            return this;
        }

        public ChatResult build() {
            ChatResult model = new ChatResult(this.modelId, this.modelVersion, this.chatResponse);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChatResult model) {
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("chatResponse")) {
                this.chatResponse(model.getChatResponse());
            }
            return this;
        }
    }
}

