/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.Action;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType")
@JsonFilter(value="explicitlySetFilter")
public final class UpgradeAction
extends Action {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="qualifier")
    private final String qualifier;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpgradeAction(String referenceKey, Action.State state, String description, String version, String qualifier) {
        super(referenceKey, state, description);
        this.version = version;
        this.qualifier = qualifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpgradeAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", qualifier=").append(String.valueOf(this.qualifier));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpgradeAction)) {
            return false;
        }
        UpgradeAction other = (UpgradeAction)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.qualifier, other.qualifier) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.qualifier == null ? 43 : this.qualifier.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="referenceKey")
        private String referenceKey;
        @JsonProperty(value="state")
        private Action.State state;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="qualifier")
        private String qualifier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            this.__explicitlySet__.add("referenceKey");
            return this;
        }

        public Builder state(Action.State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            this.__explicitlySet__.add("qualifier");
            return this;
        }

        public UpgradeAction build() {
            UpgradeAction model = new UpgradeAction(this.referenceKey, this.state, this.description, this.version, this.qualifier);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpgradeAction model) {
            if (model.wasPropertyExplicitlySet("referenceKey")) {
                this.referenceKey(model.getReferenceKey());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("qualifier")) {
                this.qualifier(model.getQualifier());
            }
            return this;
        }
    }
}

