/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.Action;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledActivity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="runCycle")
    private final RunCycle runCycle;
    @JsonProperty(value="fusionEnvironmentId")
    private final String fusionEnvironmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="actions")
    private final List<Action> actions;
    @JsonProperty(value="serviceAvailability")
    private final ServiceAvailability serviceAvailability;
    @JsonProperty(value="timeScheduledStart")
    private final Date timeScheduledStart;
    @JsonProperty(value="timeExpectedFinish")
    private final Date timeExpectedFinish;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="delayInHours")
    private final Integer delayInHours;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "runCycle", "fusionEnvironmentId", "lifecycleState", "actions", "serviceAvailability", "timeScheduledStart", "timeExpectedFinish", "timeFinished", "delayInHours", "timeCreated", "timeUpdated", "lifecycleDetails"})
    public ScheduledActivity(String id, String displayName, RunCycle runCycle, String fusionEnvironmentId, LifecycleState lifecycleState, List<Action> actions, ServiceAvailability serviceAvailability, Date timeScheduledStart, Date timeExpectedFinish, Date timeFinished, Integer delayInHours, Date timeCreated, Date timeUpdated, LifecycleDetails lifecycleDetails) {
        this.id = id;
        this.displayName = displayName;
        this.runCycle = runCycle;
        this.fusionEnvironmentId = fusionEnvironmentId;
        this.lifecycleState = lifecycleState;
        this.actions = actions;
        this.serviceAvailability = serviceAvailability;
        this.timeScheduledStart = timeScheduledStart;
        this.timeExpectedFinish = timeExpectedFinish;
        this.timeFinished = timeFinished;
        this.delayInHours = delayInHours;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleDetails = lifecycleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RunCycle getRunCycle() {
        return this.runCycle;
    }

    public String getFusionEnvironmentId() {
        return this.fusionEnvironmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public ServiceAvailability getServiceAvailability() {
        return this.serviceAvailability;
    }

    public Date getTimeScheduledStart() {
        return this.timeScheduledStart;
    }

    public Date getTimeExpectedFinish() {
        return this.timeExpectedFinish;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Integer getDelayInHours() {
        return this.delayInHours;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledActivity(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", runCycle=").append(String.valueOf((Object)this.runCycle));
        sb.append(", fusionEnvironmentId=").append(String.valueOf(this.fusionEnvironmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", actions=").append(String.valueOf(this.actions));
        sb.append(", serviceAvailability=").append(String.valueOf((Object)this.serviceAvailability));
        sb.append(", timeScheduledStart=").append(String.valueOf(this.timeScheduledStart));
        sb.append(", timeExpectedFinish=").append(String.valueOf(this.timeExpectedFinish));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", delayInHours=").append(String.valueOf(this.delayInHours));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledActivity)) {
            return false;
        }
        ScheduledActivity other = (ScheduledActivity)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.runCycle, (Object)other.runCycle) && Objects.equals(this.fusionEnvironmentId, other.fusionEnvironmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.actions, other.actions) && Objects.equals((Object)this.serviceAvailability, (Object)other.serviceAvailability) && Objects.equals(this.timeScheduledStart, other.timeScheduledStart) && Objects.equals(this.timeExpectedFinish, other.timeExpectedFinish) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.delayInHours, other.delayInHours) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.runCycle == null ? 43 : this.runCycle.hashCode());
        result = result * 59 + (this.fusionEnvironmentId == null ? 43 : this.fusionEnvironmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.actions == null ? 43 : this.actions.hashCode());
        result = result * 59 + (this.serviceAvailability == null ? 43 : this.serviceAvailability.hashCode());
        result = result * 59 + (this.timeScheduledStart == null ? 43 : this.timeScheduledStart.hashCode());
        result = result * 59 + (this.timeExpectedFinish == null ? 43 : this.timeExpectedFinish.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.delayInHours == null ? 43 : this.delayInHours.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleDetails implements BmcEnum
    {
        None("NONE"),
        Rollbackaccepted("ROLLBACKACCEPTED"),
        Rollbackinprogress("ROLLBACKINPROGRESS"),
        Rollbacksucceeded("ROLLBACKSUCCEEDED"),
        Rollbackfailed("ROLLBACKFAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleDetails> map;

        private LifecycleDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleDetails.class);
            map = new HashMap<String, LifecycleDetails>();
            for (LifecycleDetails v : LifecycleDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ServiceAvailability implements BmcEnum
    {
        Available("AVAILABLE"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServiceAvailability> map;

        private ServiceAvailability(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceAvailability create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServiceAvailability', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServiceAvailability.class);
            map = new HashMap<String, ServiceAvailability>();
            for (ServiceAvailability v : ServiceAvailability.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RunCycle implements BmcEnum
    {
        Quarterly("QUARTERLY"),
        Monthly("MONTHLY"),
        Oneoff("ONEOFF"),
        Vertex("VERTEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RunCycle> map;

        private RunCycle(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RunCycle create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RunCycle', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RunCycle.class);
            map = new HashMap<String, RunCycle>();
            for (RunCycle v : RunCycle.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="runCycle")
        private RunCycle runCycle;
        @JsonProperty(value="fusionEnvironmentId")
        private String fusionEnvironmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="actions")
        private List<Action> actions;
        @JsonProperty(value="serviceAvailability")
        private ServiceAvailability serviceAvailability;
        @JsonProperty(value="timeScheduledStart")
        private Date timeScheduledStart;
        @JsonProperty(value="timeExpectedFinish")
        private Date timeExpectedFinish;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="delayInHours")
        private Integer delayInHours;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleDetails")
        private LifecycleDetails lifecycleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder runCycle(RunCycle runCycle) {
            this.runCycle = runCycle;
            this.__explicitlySet__.add("runCycle");
            return this;
        }

        public Builder fusionEnvironmentId(String fusionEnvironmentId) {
            this.fusionEnvironmentId = fusionEnvironmentId;
            this.__explicitlySet__.add("fusionEnvironmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder actions(List<Action> actions) {
            this.actions = actions;
            this.__explicitlySet__.add("actions");
            return this;
        }

        public Builder serviceAvailability(ServiceAvailability serviceAvailability) {
            this.serviceAvailability = serviceAvailability;
            this.__explicitlySet__.add("serviceAvailability");
            return this;
        }

        public Builder timeScheduledStart(Date timeScheduledStart) {
            this.timeScheduledStart = timeScheduledStart;
            this.__explicitlySet__.add("timeScheduledStart");
            return this;
        }

        public Builder timeExpectedFinish(Date timeExpectedFinish) {
            this.timeExpectedFinish = timeExpectedFinish;
            this.__explicitlySet__.add("timeExpectedFinish");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder delayInHours(Integer delayInHours) {
            this.delayInHours = delayInHours;
            this.__explicitlySet__.add("delayInHours");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public ScheduledActivity build() {
            ScheduledActivity model = new ScheduledActivity(this.id, this.displayName, this.runCycle, this.fusionEnvironmentId, this.lifecycleState, this.actions, this.serviceAvailability, this.timeScheduledStart, this.timeExpectedFinish, this.timeFinished, this.delayInHours, this.timeCreated, this.timeUpdated, this.lifecycleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledActivity model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("runCycle")) {
                this.runCycle(model.getRunCycle());
            }
            if (model.wasPropertyExplicitlySet("fusionEnvironmentId")) {
                this.fusionEnvironmentId(model.getFusionEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("actions")) {
                this.actions(model.getActions());
            }
            if (model.wasPropertyExplicitlySet("serviceAvailability")) {
                this.serviceAvailability(model.getServiceAvailability());
            }
            if (model.wasPropertyExplicitlySet("timeScheduledStart")) {
                this.timeScheduledStart(model.getTimeScheduledStart());
            }
            if (model.wasPropertyExplicitlySet("timeExpectedFinish")) {
                this.timeExpectedFinish(model.getTimeExpectedFinish());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("delayInHours")) {
                this.delayInHours(model.getDelayInHours());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            return this;
        }
    }
}

