/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KmsKeyInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activeKeyId")
    private final String activeKeyId;
    @JsonProperty(value="activeKeyVersion")
    private final String activeKeyVersion;
    @JsonProperty(value="scheduledKeyId")
    private final String scheduledKeyId;
    @JsonProperty(value="scheduledKeyVersion")
    private final String scheduledKeyVersion;
    @JsonProperty(value="currentKeyLifecycleState")
    private final String currentKeyLifecycleState;
    @JsonProperty(value="scheduledLifecycleState")
    private final String scheduledLifecycleState;
    @JsonProperty(value="scheduledKeyStatus")
    private final ScheduledKeyStatus scheduledKeyStatus;

    @Deprecated
    @ConstructorProperties(value={"activeKeyId", "activeKeyVersion", "scheduledKeyId", "scheduledKeyVersion", "currentKeyLifecycleState", "scheduledLifecycleState", "scheduledKeyStatus"})
    public KmsKeyInfo(String activeKeyId, String activeKeyVersion, String scheduledKeyId, String scheduledKeyVersion, String currentKeyLifecycleState, String scheduledLifecycleState, ScheduledKeyStatus scheduledKeyStatus) {
        this.activeKeyId = activeKeyId;
        this.activeKeyVersion = activeKeyVersion;
        this.scheduledKeyId = scheduledKeyId;
        this.scheduledKeyVersion = scheduledKeyVersion;
        this.currentKeyLifecycleState = currentKeyLifecycleState;
        this.scheduledLifecycleState = scheduledLifecycleState;
        this.scheduledKeyStatus = scheduledKeyStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getActiveKeyId() {
        return this.activeKeyId;
    }

    public String getActiveKeyVersion() {
        return this.activeKeyVersion;
    }

    public String getScheduledKeyId() {
        return this.scheduledKeyId;
    }

    public String getScheduledKeyVersion() {
        return this.scheduledKeyVersion;
    }

    public String getCurrentKeyLifecycleState() {
        return this.currentKeyLifecycleState;
    }

    public String getScheduledLifecycleState() {
        return this.scheduledLifecycleState;
    }

    public ScheduledKeyStatus getScheduledKeyStatus() {
        return this.scheduledKeyStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KmsKeyInfo(");
        sb.append("super=").append(super.toString());
        sb.append("activeKeyId=").append(String.valueOf(this.activeKeyId));
        sb.append(", activeKeyVersion=").append(String.valueOf(this.activeKeyVersion));
        sb.append(", scheduledKeyId=").append(String.valueOf(this.scheduledKeyId));
        sb.append(", scheduledKeyVersion=").append(String.valueOf(this.scheduledKeyVersion));
        sb.append(", currentKeyLifecycleState=").append(String.valueOf(this.currentKeyLifecycleState));
        sb.append(", scheduledLifecycleState=").append(String.valueOf(this.scheduledLifecycleState));
        sb.append(", scheduledKeyStatus=").append(String.valueOf((Object)this.scheduledKeyStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KmsKeyInfo)) {
            return false;
        }
        KmsKeyInfo other = (KmsKeyInfo)((Object)o);
        return Objects.equals(this.activeKeyId, other.activeKeyId) && Objects.equals(this.activeKeyVersion, other.activeKeyVersion) && Objects.equals(this.scheduledKeyId, other.scheduledKeyId) && Objects.equals(this.scheduledKeyVersion, other.scheduledKeyVersion) && Objects.equals(this.currentKeyLifecycleState, other.currentKeyLifecycleState) && Objects.equals(this.scheduledLifecycleState, other.scheduledLifecycleState) && Objects.equals((Object)this.scheduledKeyStatus, (Object)other.scheduledKeyStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activeKeyId == null ? 43 : this.activeKeyId.hashCode());
        result = result * 59 + (this.activeKeyVersion == null ? 43 : this.activeKeyVersion.hashCode());
        result = result * 59 + (this.scheduledKeyId == null ? 43 : this.scheduledKeyId.hashCode());
        result = result * 59 + (this.scheduledKeyVersion == null ? 43 : this.scheduledKeyVersion.hashCode());
        result = result * 59 + (this.currentKeyLifecycleState == null ? 43 : this.currentKeyLifecycleState.hashCode());
        result = result * 59 + (this.scheduledLifecycleState == null ? 43 : this.scheduledLifecycleState.hashCode());
        result = result * 59 + (this.scheduledKeyStatus == null ? 43 : this.scheduledKeyStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScheduledKeyStatus implements BmcEnum
    {
        Scheduling("SCHEDULING"),
        Updating("UPDATING"),
        Failed("FAILED"),
        None("NONE");

        private final String value;
        private static Map<String, ScheduledKeyStatus> map;

        private ScheduledKeyStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScheduledKeyStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ScheduledKeyStatus: " + key);
        }

        static {
            map = new HashMap<String, ScheduledKeyStatus>();
            for (ScheduledKeyStatus v : ScheduledKeyStatus.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activeKeyId")
        private String activeKeyId;
        @JsonProperty(value="activeKeyVersion")
        private String activeKeyVersion;
        @JsonProperty(value="scheduledKeyId")
        private String scheduledKeyId;
        @JsonProperty(value="scheduledKeyVersion")
        private String scheduledKeyVersion;
        @JsonProperty(value="currentKeyLifecycleState")
        private String currentKeyLifecycleState;
        @JsonProperty(value="scheduledLifecycleState")
        private String scheduledLifecycleState;
        @JsonProperty(value="scheduledKeyStatus")
        private ScheduledKeyStatus scheduledKeyStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activeKeyId(String activeKeyId) {
            this.activeKeyId = activeKeyId;
            this.__explicitlySet__.add("activeKeyId");
            return this;
        }

        public Builder activeKeyVersion(String activeKeyVersion) {
            this.activeKeyVersion = activeKeyVersion;
            this.__explicitlySet__.add("activeKeyVersion");
            return this;
        }

        public Builder scheduledKeyId(String scheduledKeyId) {
            this.scheduledKeyId = scheduledKeyId;
            this.__explicitlySet__.add("scheduledKeyId");
            return this;
        }

        public Builder scheduledKeyVersion(String scheduledKeyVersion) {
            this.scheduledKeyVersion = scheduledKeyVersion;
            this.__explicitlySet__.add("scheduledKeyVersion");
            return this;
        }

        public Builder currentKeyLifecycleState(String currentKeyLifecycleState) {
            this.currentKeyLifecycleState = currentKeyLifecycleState;
            this.__explicitlySet__.add("currentKeyLifecycleState");
            return this;
        }

        public Builder scheduledLifecycleState(String scheduledLifecycleState) {
            this.scheduledLifecycleState = scheduledLifecycleState;
            this.__explicitlySet__.add("scheduledLifecycleState");
            return this;
        }

        public Builder scheduledKeyStatus(ScheduledKeyStatus scheduledKeyStatus) {
            this.scheduledKeyStatus = scheduledKeyStatus;
            this.__explicitlySet__.add("scheduledKeyStatus");
            return this;
        }

        public KmsKeyInfo build() {
            KmsKeyInfo model = new KmsKeyInfo(this.activeKeyId, this.activeKeyVersion, this.scheduledKeyId, this.scheduledKeyVersion, this.currentKeyLifecycleState, this.scheduledLifecycleState, this.scheduledKeyStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KmsKeyInfo model) {
            if (model.wasPropertyExplicitlySet("activeKeyId")) {
                this.activeKeyId(model.getActiveKeyId());
            }
            if (model.wasPropertyExplicitlySet("activeKeyVersion")) {
                this.activeKeyVersion(model.getActiveKeyVersion());
            }
            if (model.wasPropertyExplicitlySet("scheduledKeyId")) {
                this.scheduledKeyId(model.getScheduledKeyId());
            }
            if (model.wasPropertyExplicitlySet("scheduledKeyVersion")) {
                this.scheduledKeyVersion(model.getScheduledKeyVersion());
            }
            if (model.wasPropertyExplicitlySet("currentKeyLifecycleState")) {
                this.currentKeyLifecycleState(model.getCurrentKeyLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("scheduledLifecycleState")) {
                this.scheduledLifecycleState(model.getScheduledLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("scheduledKeyStatus")) {
                this.scheduledKeyStatus(model.getScheduledKeyStatus());
            }
            return this;
        }
    }
}

