/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.CreateServiceInstanceDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="serviceInstanceType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateOicServiceInstanceDetails
extends CreateServiceInstanceDetails {
    @JsonProperty(value="messagePacks")
    private final Integer messagePacks;
    @JsonProperty(value="edition")
    private final Edition edition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateOicServiceInstanceDetails(String displayName, String compartmentId, Integer messagePacks, Edition edition) {
        super(displayName, compartmentId);
        this.messagePacks = messagePacks;
        this.edition = edition;
    }

    public Integer getMessagePacks() {
        return this.messagePacks;
    }

    public Edition getEdition() {
        return this.edition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOicServiceInstanceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", messagePacks=").append(String.valueOf(this.messagePacks));
        sb.append(", edition=").append(String.valueOf((Object)this.edition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOicServiceInstanceDetails)) {
            return false;
        }
        CreateOicServiceInstanceDetails other = (CreateOicServiceInstanceDetails)((Object)o);
        return Objects.equals(this.messagePacks, other.messagePacks) && Objects.equals((Object)this.edition, (Object)other.edition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.messagePacks == null ? 43 : this.messagePacks.hashCode());
        result = result * 59 + (this.edition == null ? 43 : this.edition.hashCode());
        return result;
    }

    public static enum Edition implements BmcEnum
    {
        Standard("STANDARD"),
        Enterprise("ENTERPRISE");

        private final String value;
        private static Map<String, Edition> map;

        private Edition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Edition create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Edition: " + key);
        }

        static {
            map = new HashMap<String, Edition>();
            for (Edition v : Edition.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="messagePacks")
        private Integer messagePacks;
        @JsonProperty(value="edition")
        private Edition edition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder messagePacks(Integer messagePacks) {
            this.messagePacks = messagePacks;
            this.__explicitlySet__.add("messagePacks");
            return this;
        }

        public Builder edition(Edition edition) {
            this.edition = edition;
            this.__explicitlySet__.add("edition");
            return this;
        }

        public CreateOicServiceInstanceDetails build() {
            CreateOicServiceInstanceDetails model = new CreateOicServiceInstanceDetails(this.displayName, this.compartmentId, this.messagePacks, this.edition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOicServiceInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("messagePacks")) {
                this.messagePacks(model.getMessagePacks());
            }
            if (model.wasPropertyExplicitlySet("edition")) {
                this.edition(model.getEdition());
            }
            return this;
        }
    }
}

