/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.CreateServiceAttachmentDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class AttachExistingInstanceDetails
extends CreateServiceAttachmentDetails {
    @JsonProperty(value="serviceInstanceType")
    private final ServiceInstanceType serviceInstanceType;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AttachExistingInstanceDetails(ServiceInstanceType serviceInstanceType, String instanceId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.serviceInstanceType = serviceInstanceType;
        this.instanceId = instanceId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public ServiceInstanceType getServiceInstanceType() {
        return this.serviceInstanceType;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttachExistingInstanceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", serviceInstanceType=").append(String.valueOf((Object)this.serviceInstanceType));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachExistingInstanceDetails)) {
            return false;
        }
        AttachExistingInstanceDetails other = (AttachExistingInstanceDetails)((Object)o);
        return Objects.equals((Object)this.serviceInstanceType, (Object)other.serviceInstanceType) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceInstanceType == null ? 43 : this.serviceInstanceType.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        return result;
    }

    public static enum ServiceInstanceType implements BmcEnum
    {
        IntegrationCloud("INTEGRATION_CLOUD"),
        AnalyticsWarehouse("ANALYTICS_WAREHOUSE");

        private final String value;
        private static Map<String, ServiceInstanceType> map;

        private ServiceInstanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceInstanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ServiceInstanceType: " + key);
        }

        static {
            map = new HashMap<String, ServiceInstanceType>();
            for (ServiceInstanceType v : ServiceInstanceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serviceInstanceType")
        private ServiceInstanceType serviceInstanceType;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serviceInstanceType(ServiceInstanceType serviceInstanceType) {
            this.serviceInstanceType = serviceInstanceType;
            this.__explicitlySet__.add("serviceInstanceType");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public AttachExistingInstanceDetails build() {
            AttachExistingInstanceDetails model = new AttachExistingInstanceDetails(this.serviceInstanceType, this.instanceId, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttachExistingInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("serviceInstanceType")) {
                this.serviceInstanceType(model.getServiceInstanceType());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

