/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.fusionapps.FusionApplicationsAsync;
import com.oracle.bmc.fusionapps.model.AdminUserCollection;
import com.oracle.bmc.fusionapps.model.DataMaskingActivity;
import com.oracle.bmc.fusionapps.model.DataMaskingActivityCollection;
import com.oracle.bmc.fusionapps.model.FusionEnvironment;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentCollection;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentFamily;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentFamilyCollection;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentFamilyLimitsAndUsage;
import com.oracle.bmc.fusionapps.model.FusionEnvironmentStatus;
import com.oracle.bmc.fusionapps.model.RefreshActivity;
import com.oracle.bmc.fusionapps.model.RefreshActivityCollection;
import com.oracle.bmc.fusionapps.model.ScheduledActivity;
import com.oracle.bmc.fusionapps.model.ScheduledActivityCollection;
import com.oracle.bmc.fusionapps.model.ServiceAttachment;
import com.oracle.bmc.fusionapps.model.ServiceAttachmentCollection;
import com.oracle.bmc.fusionapps.model.SubscriptionDetail;
import com.oracle.bmc.fusionapps.model.TimeAvailableForRefreshCollection;
import com.oracle.bmc.fusionapps.model.WorkRequest;
import com.oracle.bmc.fusionapps.model.WorkRequestErrorCollection;
import com.oracle.bmc.fusionapps.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.fusionapps.model.WorkRequestSummaryCollection;
import com.oracle.bmc.fusionapps.requests.ChangeFusionEnvironmentCompartmentRequest;
import com.oracle.bmc.fusionapps.requests.ChangeFusionEnvironmentFamilyCompartmentRequest;
import com.oracle.bmc.fusionapps.requests.CreateDataMaskingActivityRequest;
import com.oracle.bmc.fusionapps.requests.CreateFusionEnvironmentAdminUserRequest;
import com.oracle.bmc.fusionapps.requests.CreateFusionEnvironmentFamilyRequest;
import com.oracle.bmc.fusionapps.requests.CreateFusionEnvironmentRequest;
import com.oracle.bmc.fusionapps.requests.CreateRefreshActivityRequest;
import com.oracle.bmc.fusionapps.requests.DeleteFusionEnvironmentAdminUserRequest;
import com.oracle.bmc.fusionapps.requests.DeleteFusionEnvironmentFamilyRequest;
import com.oracle.bmc.fusionapps.requests.DeleteFusionEnvironmentRequest;
import com.oracle.bmc.fusionapps.requests.GetDataMaskingActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentFamilyLimitsAndUsageRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentFamilyRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentFamilySubscriptionDetailRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentRequest;
import com.oracle.bmc.fusionapps.requests.GetFusionEnvironmentStatusRequest;
import com.oracle.bmc.fusionapps.requests.GetRefreshActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetScheduledActivityRequest;
import com.oracle.bmc.fusionapps.requests.GetServiceAttachmentRequest;
import com.oracle.bmc.fusionapps.requests.GetWorkRequestRequest;
import com.oracle.bmc.fusionapps.requests.ListAdminUsersRequest;
import com.oracle.bmc.fusionapps.requests.ListDataMaskingActivitiesRequest;
import com.oracle.bmc.fusionapps.requests.ListFusionEnvironmentFamiliesRequest;
import com.oracle.bmc.fusionapps.requests.ListFusionEnvironmentsRequest;
import com.oracle.bmc.fusionapps.requests.ListRefreshActivitiesRequest;
import com.oracle.bmc.fusionapps.requests.ListScheduledActivitiesRequest;
import com.oracle.bmc.fusionapps.requests.ListServiceAttachmentsRequest;
import com.oracle.bmc.fusionapps.requests.ListTimeAvailableForRefreshesRequest;
import com.oracle.bmc.fusionapps.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.fusionapps.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.fusionapps.requests.ListWorkRequestsRequest;
import com.oracle.bmc.fusionapps.requests.ResetFusionEnvironmentPasswordRequest;
import com.oracle.bmc.fusionapps.requests.UpdateFusionEnvironmentFamilyRequest;
import com.oracle.bmc.fusionapps.requests.UpdateFusionEnvironmentRequest;
import com.oracle.bmc.fusionapps.responses.ChangeFusionEnvironmentCompartmentResponse;
import com.oracle.bmc.fusionapps.responses.ChangeFusionEnvironmentFamilyCompartmentResponse;
import com.oracle.bmc.fusionapps.responses.CreateDataMaskingActivityResponse;
import com.oracle.bmc.fusionapps.responses.CreateFusionEnvironmentAdminUserResponse;
import com.oracle.bmc.fusionapps.responses.CreateFusionEnvironmentFamilyResponse;
import com.oracle.bmc.fusionapps.responses.CreateFusionEnvironmentResponse;
import com.oracle.bmc.fusionapps.responses.CreateRefreshActivityResponse;
import com.oracle.bmc.fusionapps.responses.DeleteFusionEnvironmentAdminUserResponse;
import com.oracle.bmc.fusionapps.responses.DeleteFusionEnvironmentFamilyResponse;
import com.oracle.bmc.fusionapps.responses.DeleteFusionEnvironmentResponse;
import com.oracle.bmc.fusionapps.responses.GetDataMaskingActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentFamilyLimitsAndUsageResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentFamilyResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentFamilySubscriptionDetailResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentResponse;
import com.oracle.bmc.fusionapps.responses.GetFusionEnvironmentStatusResponse;
import com.oracle.bmc.fusionapps.responses.GetRefreshActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetScheduledActivityResponse;
import com.oracle.bmc.fusionapps.responses.GetServiceAttachmentResponse;
import com.oracle.bmc.fusionapps.responses.GetWorkRequestResponse;
import com.oracle.bmc.fusionapps.responses.ListAdminUsersResponse;
import com.oracle.bmc.fusionapps.responses.ListDataMaskingActivitiesResponse;
import com.oracle.bmc.fusionapps.responses.ListFusionEnvironmentFamiliesResponse;
import com.oracle.bmc.fusionapps.responses.ListFusionEnvironmentsResponse;
import com.oracle.bmc.fusionapps.responses.ListRefreshActivitiesResponse;
import com.oracle.bmc.fusionapps.responses.ListScheduledActivitiesResponse;
import com.oracle.bmc.fusionapps.responses.ListServiceAttachmentsResponse;
import com.oracle.bmc.fusionapps.responses.ListTimeAvailableForRefreshesResponse;
import com.oracle.bmc.fusionapps.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.fusionapps.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.fusionapps.responses.ListWorkRequestsResponse;
import com.oracle.bmc.fusionapps.responses.ResetFusionEnvironmentPasswordResponse;
import com.oracle.bmc.fusionapps.responses.UpdateFusionEnvironmentFamilyResponse;
import com.oracle.bmc.fusionapps.responses.UpdateFusionEnvironmentResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionApplicationsAsyncClient
extends BaseAsyncClient
implements FusionApplicationsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FUSIONAPPLICATIONS").serviceEndpointPrefix("").serviceEndpointTemplate("https://fusionapps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FusionApplicationsAsyncClient.class);

    private FusionApplicationsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeFusionEnvironmentCompartmentResponse> changeFusionEnvironmentCompartment(ChangeFusionEnvironmentCompartmentRequest request, AsyncHandler<ChangeFusionEnvironmentCompartmentRequest, ChangeFusionEnvironmentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFusionEnvironmentCompartmentDetails(), "changeFusionEnvironmentCompartmentDetails is required");
        return this.clientCall(request, ChangeFusionEnvironmentCompartmentResponse::builder).logger(LOG, "changeFusionEnvironmentCompartment").serviceDetails("FusionApplications", "ChangeFusionEnvironmentCompartment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/ChangeFusionEnvironmentCompartment").method(Method.POST).requestBuilder(ChangeFusionEnvironmentCompartmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeFusionEnvironmentCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeFusionEnvironmentCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeFusionEnvironmentFamilyCompartmentResponse> changeFusionEnvironmentFamilyCompartment(ChangeFusionEnvironmentFamilyCompartmentRequest request, AsyncHandler<ChangeFusionEnvironmentFamilyCompartmentRequest, ChangeFusionEnvironmentFamilyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFusionEnvironmentFamilyCompartmentDetails(), "changeFusionEnvironmentFamilyCompartmentDetails is required");
        return this.clientCall(request, ChangeFusionEnvironmentFamilyCompartmentResponse::builder).logger(LOG, "changeFusionEnvironmentFamilyCompartment").serviceDetails("FusionApplications", "ChangeFusionEnvironmentFamilyCompartment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/ChangeFusionEnvironmentFamilyCompartment").method(Method.POST).requestBuilder(ChangeFusionEnvironmentFamilyCompartmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeFusionEnvironmentFamilyCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeFusionEnvironmentFamilyCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDataMaskingActivityResponse> createDataMaskingActivity(CreateDataMaskingActivityRequest request, AsyncHandler<CreateDataMaskingActivityRequest, CreateDataMaskingActivityResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataMaskingActivityDetails(), "createDataMaskingActivityDetails is required");
        return this.clientCall(request, CreateDataMaskingActivityResponse::builder).logger(LOG, "createDataMaskingActivity").serviceDetails("FusionApplications", "CreateDataMaskingActivity", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/DataMaskingActivity/CreateDataMaskingActivity").method(Method.POST).requestBuilder(CreateDataMaskingActivityRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("dataMaskingActivities").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateDataMaskingActivityResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDataMaskingActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFusionEnvironmentResponse> createFusionEnvironment(CreateFusionEnvironmentRequest request, AsyncHandler<CreateFusionEnvironmentRequest, CreateFusionEnvironmentResponse> handler) {
        Objects.requireNonNull(request.getCreateFusionEnvironmentDetails(), "createFusionEnvironmentDetails is required");
        return this.clientCall(request, CreateFusionEnvironmentResponse::builder).logger(LOG, "createFusionEnvironment").serviceDetails("FusionApplications", "CreateFusionEnvironment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/CreateFusionEnvironment").method(Method.POST).requestBuilder(CreateFusionEnvironmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateFusionEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFusionEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFusionEnvironmentAdminUserResponse> createFusionEnvironmentAdminUser(CreateFusionEnvironmentAdminUserRequest request, AsyncHandler<CreateFusionEnvironmentAdminUserRequest, CreateFusionEnvironmentAdminUserResponse> handler) {
        Objects.requireNonNull(request.getCreateFusionEnvironmentAdminUserDetails(), "createFusionEnvironmentAdminUserDetails is required");
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateFusionEnvironmentAdminUserResponse::builder).logger(LOG, "createFusionEnvironmentAdminUser").serviceDetails("FusionApplications", "CreateFusionEnvironmentAdminUser", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/CreateFusionEnvironmentAdminUser").method(Method.POST).requestBuilder(CreateFusionEnvironmentAdminUserRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("adminUsers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateFusionEnvironmentAdminUserResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateFusionEnvironmentAdminUserResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateFusionEnvironmentFamilyResponse> createFusionEnvironmentFamily(CreateFusionEnvironmentFamilyRequest request, AsyncHandler<CreateFusionEnvironmentFamilyRequest, CreateFusionEnvironmentFamilyResponse> handler) {
        Objects.requireNonNull(request.getCreateFusionEnvironmentFamilyDetails(), "createFusionEnvironmentFamilyDetails is required");
        return this.clientCall(request, CreateFusionEnvironmentFamilyResponse::builder).logger(LOG, "createFusionEnvironmentFamily").serviceDetails("FusionApplications", "CreateFusionEnvironmentFamily", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/CreateFusionEnvironmentFamily").method(Method.POST).requestBuilder(CreateFusionEnvironmentFamilyRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateFusionEnvironmentFamilyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFusionEnvironmentFamilyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRefreshActivityResponse> createRefreshActivity(CreateRefreshActivityRequest request, AsyncHandler<CreateRefreshActivityRequest, CreateRefreshActivityResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateRefreshActivityDetails(), "createRefreshActivityDetails is required");
        return this.clientCall(request, CreateRefreshActivityResponse::builder).logger(LOG, "createRefreshActivity").serviceDetails("FusionApplications", "CreateRefreshActivity", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/CreateRefreshActivityDetails/CreateRefreshActivity").method(Method.POST).requestBuilder(CreateRefreshActivityRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("refreshActivities").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateRefreshActivityResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRefreshActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFusionEnvironmentResponse> deleteFusionEnvironment(DeleteFusionEnvironmentRequest request, AsyncHandler<DeleteFusionEnvironmentRequest, DeleteFusionEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFusionEnvironmentResponse::builder).logger(LOG, "deleteFusionEnvironment").serviceDetails("FusionApplications", "DeleteFusionEnvironment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/DeleteFusionEnvironment").method(Method.DELETE).requestBuilder(DeleteFusionEnvironmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFusionEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFusionEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFusionEnvironmentAdminUserResponse> deleteFusionEnvironmentAdminUser(DeleteFusionEnvironmentAdminUserRequest request, AsyncHandler<DeleteFusionEnvironmentAdminUserRequest, DeleteFusionEnvironmentAdminUserResponse> handler) {
        Validate.notBlank((String)request.getAdminUsername(), (String)"adminUsername must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFusionEnvironmentAdminUserResponse::builder).logger(LOG, "deleteFusionEnvironmentAdminUser").serviceDetails("FusionApplications", "DeleteFusionEnvironmentAdminUser", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/DeleteFusionEnvironmentAdminUser").method(Method.DELETE).requestBuilder(DeleteFusionEnvironmentAdminUserRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("adminUsers").appendPathParam(request.getAdminUsername()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFusionEnvironmentAdminUserResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteFusionEnvironmentAdminUserResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteFusionEnvironmentFamilyResponse> deleteFusionEnvironmentFamily(DeleteFusionEnvironmentFamilyRequest request, AsyncHandler<DeleteFusionEnvironmentFamilyRequest, DeleteFusionEnvironmentFamilyResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteFusionEnvironmentFamilyResponse::builder).logger(LOG, "deleteFusionEnvironmentFamily").serviceDetails("FusionApplications", "DeleteFusionEnvironmentFamily", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/DeleteFusionEnvironmentFamily").method(Method.DELETE).requestBuilder(DeleteFusionEnvironmentFamilyRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteFusionEnvironmentFamilyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFusionEnvironmentFamilyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataMaskingActivityResponse> getDataMaskingActivity(GetDataMaskingActivityRequest request, AsyncHandler<GetDataMaskingActivityRequest, GetDataMaskingActivityResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataMaskingActivityId(), (String)"dataMaskingActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDataMaskingActivityResponse::builder).logger(LOG, "getDataMaskingActivity").serviceDetails("FusionApplications", "GetDataMaskingActivity", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/DataMaskingActivity/GetDataMaskingActivity").method(Method.GET).requestBuilder(GetDataMaskingActivityRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("dataMaskingActivities").appendPathParam(request.getDataMaskingActivityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataMaskingActivity.class, GetDataMaskingActivityResponse.Builder::dataMaskingActivity).handleResponseHeaderString("etag", GetDataMaskingActivityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataMaskingActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFusionEnvironmentResponse> getFusionEnvironment(GetFusionEnvironmentRequest request, AsyncHandler<GetFusionEnvironmentRequest, GetFusionEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFusionEnvironmentResponse::builder).logger(LOG, "getFusionEnvironment").serviceDetails("FusionApplications", "GetFusionEnvironment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/GetFusionEnvironment").method(Method.GET).requestBuilder(GetFusionEnvironmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironment.class, GetFusionEnvironmentResponse.Builder::fusionEnvironment).handleResponseHeaderString("etag", GetFusionEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFusionEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFusionEnvironmentFamilyResponse> getFusionEnvironmentFamily(GetFusionEnvironmentFamilyRequest request, AsyncHandler<GetFusionEnvironmentFamilyRequest, GetFusionEnvironmentFamilyResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFusionEnvironmentFamilyResponse::builder).logger(LOG, "getFusionEnvironmentFamily").serviceDetails("FusionApplications", "GetFusionEnvironmentFamily", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/GetFusionEnvironmentFamily").method(Method.GET).requestBuilder(GetFusionEnvironmentFamilyRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironmentFamily.class, GetFusionEnvironmentFamilyResponse.Builder::fusionEnvironmentFamily).handleResponseHeaderString("etag", GetFusionEnvironmentFamilyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFusionEnvironmentFamilyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFusionEnvironmentFamilyLimitsAndUsageResponse> getFusionEnvironmentFamilyLimitsAndUsage(GetFusionEnvironmentFamilyLimitsAndUsageRequest request, AsyncHandler<GetFusionEnvironmentFamilyLimitsAndUsageRequest, GetFusionEnvironmentFamilyLimitsAndUsageResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFusionEnvironmentFamilyLimitsAndUsageResponse::builder).logger(LOG, "getFusionEnvironmentFamilyLimitsAndUsage").serviceDetails("FusionApplications", "GetFusionEnvironmentFamilyLimitsAndUsage", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamilyLimitsAndUsage/GetFusionEnvironmentFamilyLimitsAndUsage").method(Method.GET).requestBuilder(GetFusionEnvironmentFamilyLimitsAndUsageRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).appendPathParam("limitsAndUsage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironmentFamilyLimitsAndUsage.class, GetFusionEnvironmentFamilyLimitsAndUsageResponse.Builder::fusionEnvironmentFamilyLimitsAndUsage).handleResponseHeaderString("etag", GetFusionEnvironmentFamilyLimitsAndUsageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFusionEnvironmentFamilyLimitsAndUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFusionEnvironmentFamilySubscriptionDetailResponse> getFusionEnvironmentFamilySubscriptionDetail(GetFusionEnvironmentFamilySubscriptionDetailRequest request, AsyncHandler<GetFusionEnvironmentFamilySubscriptionDetailRequest, GetFusionEnvironmentFamilySubscriptionDetailResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFusionEnvironmentFamilySubscriptionDetailResponse::builder).logger(LOG, "getFusionEnvironmentFamilySubscriptionDetail").serviceDetails("FusionApplications", "GetFusionEnvironmentFamilySubscriptionDetail", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/GetFusionEnvironmentFamilySubscriptionDetail").method(Method.GET).requestBuilder(GetFusionEnvironmentFamilySubscriptionDetailRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).appendPathParam("subscriptionDetails").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionDetail.class, GetFusionEnvironmentFamilySubscriptionDetailResponse.Builder::subscriptionDetail).handleResponseHeaderString("etag", GetFusionEnvironmentFamilySubscriptionDetailResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFusionEnvironmentFamilySubscriptionDetailResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetFusionEnvironmentStatusResponse> getFusionEnvironmentStatus(GetFusionEnvironmentStatusRequest request, AsyncHandler<GetFusionEnvironmentStatusRequest, GetFusionEnvironmentStatusResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetFusionEnvironmentStatusResponse::builder).logger(LOG, "getFusionEnvironmentStatus").serviceDetails("FusionApplications", "GetFusionEnvironmentStatus", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentStatus/GetFusionEnvironmentStatus").method(Method.GET).requestBuilder(GetFusionEnvironmentStatusRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("status").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironmentStatus.class, GetFusionEnvironmentStatusResponse.Builder::fusionEnvironmentStatus).handleResponseHeaderString("opc-request-id", GetFusionEnvironmentStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRefreshActivityResponse> getRefreshActivity(GetRefreshActivityRequest request, AsyncHandler<GetRefreshActivityRequest, GetRefreshActivityResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefreshActivityId(), (String)"refreshActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRefreshActivityResponse::builder).logger(LOG, "getRefreshActivity").serviceDetails("FusionApplications", "GetRefreshActivity", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/RefreshActivity/GetRefreshActivity").method(Method.GET).requestBuilder(GetRefreshActivityRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("refreshActivities").appendPathParam(request.getRefreshActivityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RefreshActivity.class, GetRefreshActivityResponse.Builder::refreshActivity).handleResponseHeaderString("etag", GetRefreshActivityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRefreshActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetScheduledActivityResponse> getScheduledActivity(GetScheduledActivityRequest request, AsyncHandler<GetScheduledActivityRequest, GetScheduledActivityResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getScheduledActivityId(), (String)"scheduledActivityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduledActivityResponse::builder).logger(LOG, "getScheduledActivity").serviceDetails("FusionApplications", "GetScheduledActivity", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/ScheduledActivity/GetScheduledActivity").method(Method.GET).requestBuilder(GetScheduledActivityRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("scheduledActivities").appendPathParam(request.getScheduledActivityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledActivity.class, GetScheduledActivityResponse.Builder::scheduledActivity).handleResponseHeaderString("etag", GetScheduledActivityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetScheduledActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetServiceAttachmentResponse> getServiceAttachment(GetServiceAttachmentRequest request, AsyncHandler<GetServiceAttachmentRequest, GetServiceAttachmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getServiceAttachmentId(), (String)"serviceAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetServiceAttachmentResponse::builder).logger(LOG, "getServiceAttachment").serviceDetails("FusionApplications", "GetServiceAttachment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/ServiceAttachment/GetServiceAttachment").method(Method.GET).requestBuilder(GetServiceAttachmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("serviceAttachments").appendPathParam(request.getServiceAttachmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceAttachment.class, GetServiceAttachmentResponse.Builder::serviceAttachment).handleResponseHeaderString("etag", GetServiceAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetServiceAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("FusionApplications", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20211201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAdminUsersResponse> listAdminUsers(ListAdminUsersRequest request, AsyncHandler<ListAdminUsersRequest, ListAdminUsersResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAdminUsersResponse::builder).logger(LOG, "listAdminUsers").serviceDetails("FusionApplications", "ListAdminUsers", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/ListAdminUsers").method(Method.GET).requestBuilder(ListAdminUsersRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("adminUsers").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AdminUserCollection.class, ListAdminUsersResponse.Builder::adminUserCollection).handleResponseHeaderString("opc-request-id", ListAdminUsersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAdminUsersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDataMaskingActivitiesResponse> listDataMaskingActivities(ListDataMaskingActivitiesRequest request, AsyncHandler<ListDataMaskingActivitiesRequest, ListDataMaskingActivitiesResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataMaskingActivitiesResponse::builder).logger(LOG, "listDataMaskingActivities").serviceDetails("FusionApplications", "ListDataMaskingActivities", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/DataMaskingActivity/ListDataMaskingActivities").method(Method.GET).requestBuilder(ListDataMaskingActivitiesRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("dataMaskingActivities").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataMaskingActivityCollection.class, ListDataMaskingActivitiesResponse.Builder::dataMaskingActivityCollection).handleResponseHeaderString("opc-request-id", ListDataMaskingActivitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataMaskingActivitiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFusionEnvironmentFamiliesResponse> listFusionEnvironmentFamilies(ListFusionEnvironmentFamiliesRequest request, AsyncHandler<ListFusionEnvironmentFamiliesRequest, ListFusionEnvironmentFamiliesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFusionEnvironmentFamiliesResponse::builder).logger(LOG, "listFusionEnvironmentFamilies").serviceDetails("FusionApplications", "ListFusionEnvironmentFamilies", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/ListFusionEnvironmentFamilies").method(Method.GET).requestBuilder(ListFusionEnvironmentFamiliesRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendQueryParam("fusionEnvironmentFamilyId", (Object)request.getFusionEnvironmentFamilyId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironmentFamilyCollection.class, ListFusionEnvironmentFamiliesResponse.Builder::fusionEnvironmentFamilyCollection).handleResponseHeaderString("opc-request-id", ListFusionEnvironmentFamiliesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFusionEnvironmentFamiliesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListFusionEnvironmentsResponse> listFusionEnvironments(ListFusionEnvironmentsRequest request, AsyncHandler<ListFusionEnvironmentsRequest, ListFusionEnvironmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListFusionEnvironmentsResponse::builder).logger(LOG, "listFusionEnvironments").serviceDetails("FusionApplications", "ListFusionEnvironments", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/ListFusionEnvironments").method(Method.GET).requestBuilder(ListFusionEnvironmentsRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fusionEnvironmentFamilyId", (Object)request.getFusionEnvironmentFamilyId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FusionEnvironmentCollection.class, ListFusionEnvironmentsResponse.Builder::fusionEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListFusionEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFusionEnvironmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRefreshActivitiesResponse> listRefreshActivities(ListRefreshActivitiesRequest request, AsyncHandler<ListRefreshActivitiesRequest, ListRefreshActivitiesResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRefreshActivitiesResponse::builder).logger(LOG, "listRefreshActivities").serviceDetails("FusionApplications", "ListRefreshActivities", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/RefreshActivity/ListRefreshActivities").method(Method.GET).requestBuilder(ListRefreshActivitiesRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("refreshActivities").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeScheduledStartGreaterThanOrEqualTo", (Object)request.getTimeScheduledStartGreaterThanOrEqualTo()).appendQueryParam("timeExpectedFinishLessThanOrEqualTo", (Object)request.getTimeExpectedFinishLessThanOrEqualTo()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RefreshActivityCollection.class, ListRefreshActivitiesResponse.Builder::refreshActivityCollection).handleResponseHeaderString("opc-request-id", ListRefreshActivitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRefreshActivitiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListScheduledActivitiesResponse> listScheduledActivities(ListScheduledActivitiesRequest request, AsyncHandler<ListScheduledActivitiesRequest, ListScheduledActivitiesResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListScheduledActivitiesResponse::builder).logger(LOG, "listScheduledActivities").serviceDetails("FusionApplications", "ListScheduledActivities", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/ScheduledActivity/ListScheduledActivities").method(Method.GET).requestBuilder(ListScheduledActivitiesRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("scheduledActivities").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeScheduledStartGreaterThanOrEqualTo", (Object)request.getTimeScheduledStartGreaterThanOrEqualTo()).appendQueryParam("timeExpectedFinishLessThanOrEqualTo", (Object)request.getTimeExpectedFinishLessThanOrEqualTo()).appendEnumQueryParam("runCycle", (BmcEnum)request.getRunCycle()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledActivityCollection.class, ListScheduledActivitiesResponse.Builder::scheduledActivityCollection).handleResponseHeaderString("opc-request-id", ListScheduledActivitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledActivitiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListServiceAttachmentsResponse> listServiceAttachments(ListServiceAttachmentsRequest request, AsyncHandler<ListServiceAttachmentsRequest, ListServiceAttachmentsResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListServiceAttachmentsResponse::builder).logger(LOG, "listServiceAttachments").serviceDetails("FusionApplications", "ListServiceAttachments", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/ServiceAttachment/ListServiceAttachments").method(Method.GET).requestBuilder(ListServiceAttachmentsRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("serviceAttachments").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("serviceInstanceType", (BmcEnum)request.getServiceInstanceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceAttachmentCollection.class, ListServiceAttachmentsResponse.Builder::serviceAttachmentCollection).handleResponseHeaderString("opc-request-id", ListServiceAttachmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceAttachmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListTimeAvailableForRefreshesResponse> listTimeAvailableForRefreshes(ListTimeAvailableForRefreshesRequest request, AsyncHandler<ListTimeAvailableForRefreshesRequest, ListTimeAvailableForRefreshesResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTimeAvailableForRefreshesResponse::builder).logger(LOG, "listTimeAvailableForRefreshes").serviceDetails("FusionApplications", "ListTimeAvailableForRefreshes", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/TimeAvailableForRefresh/ListTimeAvailableForRefreshes").method(Method.GET).requestBuilder(ListTimeAvailableForRefreshesRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("timeAvailableForRefresh").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TimeAvailableForRefreshCollection.class, ListTimeAvailableForRefreshesResponse.Builder::timeAvailableForRefreshCollection).handleResponseHeaderString("opc-request-id", ListTimeAvailableForRefreshesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTimeAvailableForRefreshesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("FusionApplications", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20211201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("FusionApplications", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20211201").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("FusionApplications", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20211201").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ResetFusionEnvironmentPasswordResponse> resetFusionEnvironmentPassword(ResetFusionEnvironmentPasswordRequest request, AsyncHandler<ResetFusionEnvironmentPasswordRequest, ResetFusionEnvironmentPasswordResponse> handler) {
        Objects.requireNonNull(request.getResetFusionEnvironmentPasswordDetails(), "resetFusionEnvironmentPasswordDetails is required");
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAdminUsername(), (String)"adminUsername must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResetFusionEnvironmentPasswordResponse::builder).logger(LOG, "resetFusionEnvironmentPassword").serviceDetails("FusionApplications", "ResetFusionEnvironmentPassword", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/ResetFusionEnvironmentPassword").method(Method.POST).requestBuilder(ResetFusionEnvironmentPasswordRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).appendPathParam("adminUsers").appendPathParam(request.getAdminUsername()).appendPathParam("actions").appendPathParam("resetPassword").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ResetFusionEnvironmentPasswordResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ResetFusionEnvironmentPasswordResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFusionEnvironmentResponse> updateFusionEnvironment(UpdateFusionEnvironmentRequest request, AsyncHandler<UpdateFusionEnvironmentRequest, UpdateFusionEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentId(), (String)"fusionEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFusionEnvironmentDetails(), "updateFusionEnvironmentDetails is required");
        return this.clientCall(request, UpdateFusionEnvironmentResponse::builder).logger(LOG, "updateFusionEnvironment").serviceDetails("FusionApplications", "UpdateFusionEnvironment", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironment/UpdateFusionEnvironment").method(Method.PUT).requestBuilder(UpdateFusionEnvironmentRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironments").appendPathParam(request.getFusionEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFusionEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFusionEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateFusionEnvironmentFamilyResponse> updateFusionEnvironmentFamily(UpdateFusionEnvironmentFamilyRequest request, AsyncHandler<UpdateFusionEnvironmentFamilyRequest, UpdateFusionEnvironmentFamilyResponse> handler) {
        Validate.notBlank((String)request.getFusionEnvironmentFamilyId(), (String)"fusionEnvironmentFamilyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFusionEnvironmentFamilyDetails(), "updateFusionEnvironmentFamilyDetails is required");
        return this.clientCall(request, UpdateFusionEnvironmentFamilyResponse::builder).logger(LOG, "updateFusionEnvironmentFamily").serviceDetails("FusionApplications", "UpdateFusionEnvironmentFamily", "https://docs.oracle.com/iaas/api/#/en/fusion-applications/20211201/FusionEnvironmentFamily/UpdateFusionEnvironmentFamily").method(Method.PUT).requestBuilder(UpdateFusionEnvironmentFamilyRequest::builder).basePath("/20211201").appendPathParam("fusionEnvironmentFamilies").appendPathParam(request.getFusionEnvironmentFamilyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFusionEnvironmentFamilyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFusionEnvironmentFamilyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FusionApplicationsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FusionApplicationsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FusionApplicationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FusionApplicationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FusionApplicationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FusionApplicationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public FusionApplicationsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FusionApplicationsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FusionApplicationsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public FusionApplicationsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FusionApplicationsAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

