/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.responses;

import com.oracle.bmc.filestorage.model.FileSystem;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetFileSystemResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private FileSystem fileSystem;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "fileSystem"})
    private GetFileSystemResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, FileSystem fileSystem) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.fileSystem = fileSystem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",fileSystem=").append(String.valueOf((Object)this.fileSystem));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFileSystemResponse)) {
            return false;
        }
        GetFileSystemResponse other = (GetFileSystemResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.fileSystem, (Object)other.fileSystem);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.fileSystem == null ? 43 : this.fileSystem.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetFileSystemResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private FileSystem fileSystem;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder copy(GetFileSystemResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.fileSystem(o.getFileSystem());
            return this;
        }

        public GetFileSystemResponse build() {
            return new GetFileSystemResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.fileSystem);
        }
    }
}

