/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateSnapshotDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSnapshotRequest
extends BmcRequest<UpdateSnapshotDetails> {
    private String snapshotId;
    private UpdateSnapshotDetails updateSnapshotDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public UpdateSnapshotDetails getUpdateSnapshotDetails() {
        return this.updateSnapshotDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSnapshotDetails getBody$() {
        return this.updateSnapshotDetails;
    }

    public Builder toBuilder() {
        return new Builder().snapshotId(this.snapshotId).updateSnapshotDetails(this.updateSnapshotDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",snapshotId=").append(String.valueOf(this.snapshotId));
        sb.append(",updateSnapshotDetails=").append(String.valueOf((Object)this.updateSnapshotDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSnapshotRequest)) {
            return false;
        }
        UpdateSnapshotRequest other = (UpdateSnapshotRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals((Object)this.updateSnapshotDetails, (Object)other.updateSnapshotDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.snapshotId == null ? 43 : this.snapshotId.hashCode());
        result = result * 59 + (this.updateSnapshotDetails == null ? 43 : this.updateSnapshotDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSnapshotRequest, UpdateSnapshotDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String snapshotId = null;
        private UpdateSnapshotDetails updateSnapshotDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder updateSnapshotDetails(UpdateSnapshotDetails updateSnapshotDetails) {
            this.updateSnapshotDetails = updateSnapshotDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSnapshotRequest o) {
            this.snapshotId(o.getSnapshotId());
            this.updateSnapshotDetails(o.getUpdateSnapshotDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSnapshotRequest build() {
            UpdateSnapshotRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSnapshotDetails body) {
            this.updateSnapshotDetails(body);
            return this;
        }

        public UpdateSnapshotRequest buildWithoutInvocationCallback() {
            UpdateSnapshotRequest request = new UpdateSnapshotRequest();
            request.snapshotId = this.snapshotId;
            request.updateSnapshotDetails = this.updateSnapshotDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

