/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateReplicationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateReplicationRequest
extends BmcRequest<UpdateReplicationDetails> {
    private String replicationId;
    private UpdateReplicationDetails updateReplicationDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getReplicationId() {
        return this.replicationId;
    }

    public UpdateReplicationDetails getUpdateReplicationDetails() {
        return this.updateReplicationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateReplicationDetails getBody$() {
        return this.updateReplicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().replicationId(this.replicationId).updateReplicationDetails(this.updateReplicationDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",replicationId=").append(String.valueOf(this.replicationId));
        sb.append(",updateReplicationDetails=").append(String.valueOf((Object)this.updateReplicationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateReplicationRequest)) {
            return false;
        }
        UpdateReplicationRequest other = (UpdateReplicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.replicationId, other.replicationId) && Objects.equals((Object)this.updateReplicationDetails, (Object)other.updateReplicationDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationId == null ? 43 : this.replicationId.hashCode());
        result = result * 59 + (this.updateReplicationDetails == null ? 43 : this.updateReplicationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateReplicationRequest, UpdateReplicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String replicationId = null;
        private UpdateReplicationDetails updateReplicationDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder replicationId(String replicationId) {
            this.replicationId = replicationId;
            return this;
        }

        public Builder updateReplicationDetails(UpdateReplicationDetails updateReplicationDetails) {
            this.updateReplicationDetails = updateReplicationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateReplicationRequest o) {
            this.replicationId(o.getReplicationId());
            this.updateReplicationDetails(o.getUpdateReplicationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateReplicationRequest build() {
            UpdateReplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateReplicationDetails body) {
            this.updateReplicationDetails(body);
            return this;
        }

        public UpdateReplicationRequest buildWithoutInvocationCallback() {
            UpdateReplicationRequest request = new UpdateReplicationRequest();
            request.replicationId = this.replicationId;
            request.updateReplicationDetails = this.updateReplicationDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

