/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateFileSystemDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateFileSystemRequest
extends BmcRequest<UpdateFileSystemDetails> {
    private String fileSystemId;
    private UpdateFileSystemDetails updateFileSystemDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public UpdateFileSystemDetails getUpdateFileSystemDetails() {
        return this.updateFileSystemDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateFileSystemDetails getBody$() {
        return this.updateFileSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().fileSystemId(this.fileSystemId).updateFileSystemDetails(this.updateFileSystemDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fileSystemId=").append(String.valueOf(this.fileSystemId));
        sb.append(",updateFileSystemDetails=").append(String.valueOf((Object)this.updateFileSystemDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateFileSystemRequest)) {
            return false;
        }
        UpdateFileSystemRequest other = (UpdateFileSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fileSystemId, other.fileSystemId) && Objects.equals((Object)this.updateFileSystemDetails, (Object)other.updateFileSystemDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fileSystemId == null ? 43 : this.fileSystemId.hashCode());
        result = result * 59 + (this.updateFileSystemDetails == null ? 43 : this.updateFileSystemDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateFileSystemRequest, UpdateFileSystemDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fileSystemId = null;
        private UpdateFileSystemDetails updateFileSystemDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public Builder updateFileSystemDetails(UpdateFileSystemDetails updateFileSystemDetails) {
            this.updateFileSystemDetails = updateFileSystemDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFileSystemRequest o) {
            this.fileSystemId(o.getFileSystemId());
            this.updateFileSystemDetails(o.getUpdateFileSystemDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFileSystemRequest build() {
            UpdateFileSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateFileSystemDetails body) {
            this.updateFileSystemDetails(body);
            return this;
        }

        public UpdateFileSystemRequest buildWithoutInvocationCallback() {
            UpdateFileSystemRequest request = new UpdateFileSystemRequest();
            request.fileSystemId = this.fileSystemId;
            request.updateFileSystemDetails = this.updateFileSystemDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

