/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateExportSetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExportSetRequest
extends BmcRequest<UpdateExportSetDetails> {
    private String exportSetId;
    private UpdateExportSetDetails updateExportSetDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getExportSetId() {
        return this.exportSetId;
    }

    public UpdateExportSetDetails getUpdateExportSetDetails() {
        return this.updateExportSetDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateExportSetDetails getBody$() {
        return this.updateExportSetDetails;
    }

    public Builder toBuilder() {
        return new Builder().exportSetId(this.exportSetId).updateExportSetDetails(this.updateExportSetDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exportSetId=").append(String.valueOf(this.exportSetId));
        sb.append(",updateExportSetDetails=").append(String.valueOf((Object)this.updateExportSetDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExportSetRequest)) {
            return false;
        }
        UpdateExportSetRequest other = (UpdateExportSetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exportSetId, other.exportSetId) && Objects.equals((Object)this.updateExportSetDetails, (Object)other.updateExportSetDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exportSetId == null ? 43 : this.exportSetId.hashCode());
        result = result * 59 + (this.updateExportSetDetails == null ? 43 : this.updateExportSetDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExportSetRequest, UpdateExportSetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exportSetId = null;
        private UpdateExportSetDetails updateExportSetDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder exportSetId(String exportSetId) {
            this.exportSetId = exportSetId;
            return this;
        }

        public Builder updateExportSetDetails(UpdateExportSetDetails updateExportSetDetails) {
            this.updateExportSetDetails = updateExportSetDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExportSetRequest o) {
            this.exportSetId(o.getExportSetId());
            this.updateExportSetDetails(o.getUpdateExportSetDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExportSetRequest build() {
            UpdateExportSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExportSetDetails body) {
            this.updateExportSetDetails(body);
            return this;
        }

        public UpdateExportSetRequest buildWithoutInvocationCallback() {
            UpdateExportSetRequest request = new UpdateExportSetRequest();
            request.exportSetId = this.exportSetId;
            request.updateExportSetDetails = this.updateExportSetDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

