/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateExportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExportRequest
extends BmcRequest<UpdateExportDetails> {
    private String exportId;
    private UpdateExportDetails updateExportDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getExportId() {
        return this.exportId;
    }

    public UpdateExportDetails getUpdateExportDetails() {
        return this.updateExportDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateExportDetails getBody$() {
        return this.updateExportDetails;
    }

    public Builder toBuilder() {
        return new Builder().exportId(this.exportId).updateExportDetails(this.updateExportDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exportId=").append(String.valueOf(this.exportId));
        sb.append(",updateExportDetails=").append(String.valueOf((Object)this.updateExportDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExportRequest)) {
            return false;
        }
        UpdateExportRequest other = (UpdateExportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exportId, other.exportId) && Objects.equals((Object)this.updateExportDetails, (Object)other.updateExportDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exportId == null ? 43 : this.exportId.hashCode());
        result = result * 59 + (this.updateExportDetails == null ? 43 : this.updateExportDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExportRequest, UpdateExportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exportId = null;
        private UpdateExportDetails updateExportDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public Builder updateExportDetails(UpdateExportDetails updateExportDetails) {
            this.updateExportDetails = updateExportDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExportRequest o) {
            this.exportId(o.getExportId());
            this.updateExportDetails(o.getUpdateExportDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExportRequest build() {
            UpdateExportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExportDetails body) {
            this.updateExportDetails(body);
            return this;
        }

        public UpdateExportRequest buildWithoutInvocationCallback() {
            UpdateExportRequest request = new UpdateExportRequest();
            request.exportId = this.exportId;
            request.updateExportDetails = this.updateExportDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

