/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetReplicationTargetRequest
extends BmcRequest<Void> {
    private String replicationTargetId;
    private String opcRequestId;

    public String getReplicationTargetId() {
        return this.replicationTargetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().replicationTargetId(this.replicationTargetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",replicationTargetId=").append(String.valueOf(this.replicationTargetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetReplicationTargetRequest)) {
            return false;
        }
        GetReplicationTargetRequest other = (GetReplicationTargetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.replicationTargetId, other.replicationTargetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationTargetId == null ? 43 : this.replicationTargetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetReplicationTargetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String replicationTargetId = null;
        private String opcRequestId = null;

        public Builder replicationTargetId(String replicationTargetId) {
            this.replicationTargetId = replicationTargetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetReplicationTargetRequest o) {
            this.replicationTargetId(o.getReplicationTargetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetReplicationTargetRequest build() {
            GetReplicationTargetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetReplicationTargetRequest buildWithoutInvocationCallback() {
            GetReplicationTargetRequest request = new GetReplicationTargetRequest();
            request.replicationTargetId = this.replicationTargetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

