/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DeleteReplicationRequest
extends BmcRequest<Void> {
    private String replicationId;
    private String ifMatch;
    private String opcRequestId;
    private DeleteMode deleteMode;

    public String getReplicationId() {
        return this.replicationId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DeleteMode getDeleteMode() {
        return this.deleteMode;
    }

    public Builder toBuilder() {
        return new Builder().replicationId(this.replicationId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).deleteMode(this.deleteMode);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",replicationId=").append(String.valueOf(this.replicationId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",deleteMode=").append(String.valueOf((Object)this.deleteMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteReplicationRequest)) {
            return false;
        }
        DeleteReplicationRequest other = (DeleteReplicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.replicationId, other.replicationId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.deleteMode, (Object)other.deleteMode);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationId == null ? 43 : this.replicationId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.deleteMode == null ? 43 : this.deleteMode.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteReplicationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String replicationId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private DeleteMode deleteMode = null;

        public Builder replicationId(String replicationId) {
            this.replicationId = replicationId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder deleteMode(DeleteMode deleteMode) {
            this.deleteMode = deleteMode;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteReplicationRequest o) {
            this.replicationId(o.getReplicationId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.deleteMode(o.getDeleteMode());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteReplicationRequest build() {
            DeleteReplicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteReplicationRequest buildWithoutInvocationCallback() {
            DeleteReplicationRequest request = new DeleteReplicationRequest();
            request.replicationId = this.replicationId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.deleteMode = this.deleteMode;
            return request;
        }
    }

    public static enum DeleteMode implements BmcEnum
    {
        FinishCycleIfCapturingOrApplying("FINISH_CYCLE_IF_CAPTURING_OR_APPLYING"),
        OneMoreCycle("ONE_MORE_CYCLE"),
        FinishCycleIfApplying("FINISH_CYCLE_IF_APPLYING");

        private final String value;
        private static Map<String, DeleteMode> map;

        private DeleteMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeleteMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DeleteMode: " + key);
        }

        static {
            map = new HashMap<String, DeleteMode>();
            for (DeleteMode v : DeleteMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

