/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.CreateFileSystemDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateFileSystemRequest
extends BmcRequest<CreateFileSystemDetails> {
    private CreateFileSystemDetails createFileSystemDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateFileSystemDetails getCreateFileSystemDetails() {
        return this.createFileSystemDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateFileSystemDetails getBody$() {
        return this.createFileSystemDetails;
    }

    public Builder toBuilder() {
        return new Builder().createFileSystemDetails(this.createFileSystemDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createFileSystemDetails=").append(String.valueOf((Object)this.createFileSystemDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createFileSystemDetails, (Object)other.createFileSystemDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createFileSystemDetails == null ? 43 : this.createFileSystemDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateFileSystemRequest, CreateFileSystemDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateFileSystemDetails createFileSystemDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createFileSystemDetails(CreateFileSystemDetails createFileSystemDetails) {
            this.createFileSystemDetails = createFileSystemDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateFileSystemRequest o) {
            this.createFileSystemDetails(o.getCreateFileSystemDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateFileSystemRequest build() {
            CreateFileSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateFileSystemDetails body) {
            this.createFileSystemDetails(body);
            return this;
        }

        public CreateFileSystemRequest buildWithoutInvocationCallback() {
            CreateFileSystemRequest request = new CreateFileSystemRequest();
            request.createFileSystemDetails = this.createFileSystemDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

