/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.ChangeReplicationCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeReplicationCompartmentRequest
extends BmcRequest<ChangeReplicationCompartmentDetails> {
    private String replicationId;
    private ChangeReplicationCompartmentDetails changeReplicationCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getReplicationId() {
        return this.replicationId;
    }

    public ChangeReplicationCompartmentDetails getChangeReplicationCompartmentDetails() {
        return this.changeReplicationCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeReplicationCompartmentDetails getBody$() {
        return this.changeReplicationCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().replicationId(this.replicationId).changeReplicationCompartmentDetails(this.changeReplicationCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",replicationId=").append(String.valueOf(this.replicationId));
        sb.append(",changeReplicationCompartmentDetails=").append(String.valueOf((Object)this.changeReplicationCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeReplicationCompartmentRequest)) {
            return false;
        }
        ChangeReplicationCompartmentRequest other = (ChangeReplicationCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.replicationId, other.replicationId) && Objects.equals((Object)this.changeReplicationCompartmentDetails, (Object)other.changeReplicationCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationId == null ? 43 : this.replicationId.hashCode());
        result = result * 59 + (this.changeReplicationCompartmentDetails == null ? 43 : this.changeReplicationCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeReplicationCompartmentRequest, ChangeReplicationCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String replicationId = null;
        private ChangeReplicationCompartmentDetails changeReplicationCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder replicationId(String replicationId) {
            this.replicationId = replicationId;
            return this;
        }

        public Builder changeReplicationCompartmentDetails(ChangeReplicationCompartmentDetails changeReplicationCompartmentDetails) {
            this.changeReplicationCompartmentDetails = changeReplicationCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeReplicationCompartmentRequest o) {
            this.replicationId(o.getReplicationId());
            this.changeReplicationCompartmentDetails(o.getChangeReplicationCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeReplicationCompartmentRequest build() {
            ChangeReplicationCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeReplicationCompartmentDetails body) {
            this.changeReplicationCompartmentDetails(body);
            return this;
        }

        public ChangeReplicationCompartmentRequest buildWithoutInvocationCallback() {
            ChangeReplicationCompartmentRequest request = new ChangeReplicationCompartmentRequest();
            request.replicationId = this.replicationId;
            request.changeReplicationCompartmentDetails = this.changeReplicationCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

