/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.ChangeFileSystemCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeFileSystemCompartmentRequest
extends BmcRequest<ChangeFileSystemCompartmentDetails> {
    private String fileSystemId;
    private ChangeFileSystemCompartmentDetails changeFileSystemCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public ChangeFileSystemCompartmentDetails getChangeFileSystemCompartmentDetails() {
        return this.changeFileSystemCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeFileSystemCompartmentDetails getBody$() {
        return this.changeFileSystemCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().fileSystemId(this.fileSystemId).changeFileSystemCompartmentDetails(this.changeFileSystemCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fileSystemId=").append(String.valueOf(this.fileSystemId));
        sb.append(",changeFileSystemCompartmentDetails=").append(String.valueOf((Object)this.changeFileSystemCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeFileSystemCompartmentRequest)) {
            return false;
        }
        ChangeFileSystemCompartmentRequest other = (ChangeFileSystemCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fileSystemId, other.fileSystemId) && Objects.equals((Object)this.changeFileSystemCompartmentDetails, (Object)other.changeFileSystemCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fileSystemId == null ? 43 : this.fileSystemId.hashCode());
        result = result * 59 + (this.changeFileSystemCompartmentDetails == null ? 43 : this.changeFileSystemCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeFileSystemCompartmentRequest, ChangeFileSystemCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fileSystemId = null;
        private ChangeFileSystemCompartmentDetails changeFileSystemCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public Builder changeFileSystemCompartmentDetails(ChangeFileSystemCompartmentDetails changeFileSystemCompartmentDetails) {
            this.changeFileSystemCompartmentDetails = changeFileSystemCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeFileSystemCompartmentRequest o) {
            this.fileSystemId(o.getFileSystemId());
            this.changeFileSystemCompartmentDetails(o.getChangeFileSystemCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeFileSystemCompartmentRequest build() {
            ChangeFileSystemCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeFileSystemCompartmentDetails body) {
            this.changeFileSystemCompartmentDetails(body);
            return this;
        }

        public ChangeFileSystemCompartmentRequest buildWithoutInvocationCallback() {
            ChangeFileSystemCompartmentRequest request = new ChangeFileSystemCompartmentRequest();
            request.fileSystemId = this.fileSystemId;
            request.changeFileSystemCompartmentDetails = this.changeFileSystemCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

