/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Snapshot
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fileSystemId")
    private final String fileSystemId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="snapshotType")
    private final SnapshotType snapshotType;
    @JsonProperty(value="snapshotTime")
    private final Date snapshotTime;
    @JsonProperty(value="provenanceId")
    private final String provenanceId;
    @JsonProperty(value="isCloneSource")
    private final Boolean isCloneSource;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"fileSystemId", "id", "lifecycleState", "name", "timeCreated", "snapshotType", "snapshotTime", "provenanceId", "isCloneSource", "lifecycleDetails", "freeformTags", "definedTags"})
    public Snapshot(String fileSystemId, String id, LifecycleState lifecycleState, String name, Date timeCreated, SnapshotType snapshotType, Date snapshotTime, String provenanceId, Boolean isCloneSource, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.fileSystemId = fileSystemId;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.name = name;
        this.timeCreated = timeCreated;
        this.snapshotType = snapshotType;
        this.snapshotTime = snapshotTime;
        this.provenanceId = provenanceId;
        this.isCloneSource = isCloneSource;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public SnapshotType getSnapshotType() {
        return this.snapshotType;
    }

    public Date getSnapshotTime() {
        return this.snapshotTime;
    }

    public String getProvenanceId() {
        return this.provenanceId;
    }

    public Boolean getIsCloneSource() {
        return this.isCloneSource;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Snapshot(");
        sb.append("super=").append(super.toString());
        sb.append("fileSystemId=").append(String.valueOf(this.fileSystemId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", snapshotType=").append(String.valueOf((Object)this.snapshotType));
        sb.append(", snapshotTime=").append(String.valueOf(this.snapshotTime));
        sb.append(", provenanceId=").append(String.valueOf(this.provenanceId));
        sb.append(", isCloneSource=").append(String.valueOf(this.isCloneSource));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)((Object)o);
        return Objects.equals(this.fileSystemId, other.fileSystemId) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.name, other.name) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.snapshotType, (Object)other.snapshotType) && Objects.equals(this.snapshotTime, other.snapshotTime) && Objects.equals(this.provenanceId, other.provenanceId) && Objects.equals(this.isCloneSource, other.isCloneSource) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fileSystemId == null ? 43 : this.fileSystemId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.snapshotType == null ? 43 : this.snapshotType.hashCode());
        result = result * 59 + (this.snapshotTime == null ? 43 : this.snapshotTime.hashCode());
        result = result * 59 + (this.provenanceId == null ? 43 : this.provenanceId.hashCode());
        result = result * 59 + (this.isCloneSource == null ? 43 : this.isCloneSource.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SnapshotType implements BmcEnum
    {
        User("USER"),
        PolicyBased("POLICY_BASED"),
        Replication("REPLICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SnapshotType> map;

        private SnapshotType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SnapshotType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SnapshotType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SnapshotType.class);
            map = new HashMap<String, SnapshotType>();
            for (SnapshotType v : SnapshotType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fileSystemId")
        private String fileSystemId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="snapshotType")
        private SnapshotType snapshotType;
        @JsonProperty(value="snapshotTime")
        private Date snapshotTime;
        @JsonProperty(value="provenanceId")
        private String provenanceId;
        @JsonProperty(value="isCloneSource")
        private Boolean isCloneSource;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            this.__explicitlySet__.add("fileSystemId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder snapshotType(SnapshotType snapshotType) {
            this.snapshotType = snapshotType;
            this.__explicitlySet__.add("snapshotType");
            return this;
        }

        public Builder snapshotTime(Date snapshotTime) {
            this.snapshotTime = snapshotTime;
            this.__explicitlySet__.add("snapshotTime");
            return this;
        }

        public Builder provenanceId(String provenanceId) {
            this.provenanceId = provenanceId;
            this.__explicitlySet__.add("provenanceId");
            return this;
        }

        public Builder isCloneSource(Boolean isCloneSource) {
            this.isCloneSource = isCloneSource;
            this.__explicitlySet__.add("isCloneSource");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Snapshot build() {
            Snapshot model = new Snapshot(this.fileSystemId, this.id, this.lifecycleState, this.name, this.timeCreated, this.snapshotType, this.snapshotTime, this.provenanceId, this.isCloneSource, this.lifecycleDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Snapshot model) {
            if (model.wasPropertyExplicitlySet("fileSystemId")) {
                this.fileSystemId(model.getFileSystemId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("snapshotType")) {
                this.snapshotType(model.getSnapshotType());
            }
            if (model.wasPropertyExplicitlySet("snapshotTime")) {
                this.snapshotTime(model.getSnapshotTime());
            }
            if (model.wasPropertyExplicitlySet("provenanceId")) {
                this.provenanceId(model.getProvenanceId());
            }
            if (model.wasPropertyExplicitlySet("isCloneSource")) {
                this.isCloneSource(model.getIsCloneSource());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

