/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReplicationEstimate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="changeRateInMBps")
    private final Integer changeRateInMBps;
    @JsonProperty(value="isReplicationSupported")
    private final Boolean isReplicationSupported;
    @JsonProperty(value="minimumSupportedIntervalInMinutes")
    private final Integer minimumSupportedIntervalInMinutes;
    @JsonProperty(value="estimatedBaseCopyTimeInMinutes")
    private final Integer estimatedBaseCopyTimeInMinutes;
    @JsonProperty(value="allowedTargetRegions")
    private final List<String> allowedTargetRegions;

    @Deprecated
    @ConstructorProperties(value={"changeRateInMBps", "isReplicationSupported", "minimumSupportedIntervalInMinutes", "estimatedBaseCopyTimeInMinutes", "allowedTargetRegions"})
    public ReplicationEstimate(Integer changeRateInMBps, Boolean isReplicationSupported, Integer minimumSupportedIntervalInMinutes, Integer estimatedBaseCopyTimeInMinutes, List<String> allowedTargetRegions) {
        this.changeRateInMBps = changeRateInMBps;
        this.isReplicationSupported = isReplicationSupported;
        this.minimumSupportedIntervalInMinutes = minimumSupportedIntervalInMinutes;
        this.estimatedBaseCopyTimeInMinutes = estimatedBaseCopyTimeInMinutes;
        this.allowedTargetRegions = allowedTargetRegions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getChangeRateInMBps() {
        return this.changeRateInMBps;
    }

    public Boolean getIsReplicationSupported() {
        return this.isReplicationSupported;
    }

    public Integer getMinimumSupportedIntervalInMinutes() {
        return this.minimumSupportedIntervalInMinutes;
    }

    public Integer getEstimatedBaseCopyTimeInMinutes() {
        return this.estimatedBaseCopyTimeInMinutes;
    }

    public List<String> getAllowedTargetRegions() {
        return this.allowedTargetRegions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationEstimate(");
        sb.append("super=").append(super.toString());
        sb.append("changeRateInMBps=").append(String.valueOf(this.changeRateInMBps));
        sb.append(", isReplicationSupported=").append(String.valueOf(this.isReplicationSupported));
        sb.append(", minimumSupportedIntervalInMinutes=").append(String.valueOf(this.minimumSupportedIntervalInMinutes));
        sb.append(", estimatedBaseCopyTimeInMinutes=").append(String.valueOf(this.estimatedBaseCopyTimeInMinutes));
        sb.append(", allowedTargetRegions=").append(String.valueOf(this.allowedTargetRegions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicationEstimate)) {
            return false;
        }
        ReplicationEstimate other = (ReplicationEstimate)((Object)o);
        return Objects.equals(this.changeRateInMBps, other.changeRateInMBps) && Objects.equals(this.isReplicationSupported, other.isReplicationSupported) && Objects.equals(this.minimumSupportedIntervalInMinutes, other.minimumSupportedIntervalInMinutes) && Objects.equals(this.estimatedBaseCopyTimeInMinutes, other.estimatedBaseCopyTimeInMinutes) && Objects.equals(this.allowedTargetRegions, other.allowedTargetRegions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.changeRateInMBps == null ? 43 : this.changeRateInMBps.hashCode());
        result = result * 59 + (this.isReplicationSupported == null ? 43 : this.isReplicationSupported.hashCode());
        result = result * 59 + (this.minimumSupportedIntervalInMinutes == null ? 43 : this.minimumSupportedIntervalInMinutes.hashCode());
        result = result * 59 + (this.estimatedBaseCopyTimeInMinutes == null ? 43 : this.estimatedBaseCopyTimeInMinutes.hashCode());
        result = result * 59 + (this.allowedTargetRegions == null ? 43 : this.allowedTargetRegions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="changeRateInMBps")
        private Integer changeRateInMBps;
        @JsonProperty(value="isReplicationSupported")
        private Boolean isReplicationSupported;
        @JsonProperty(value="minimumSupportedIntervalInMinutes")
        private Integer minimumSupportedIntervalInMinutes;
        @JsonProperty(value="estimatedBaseCopyTimeInMinutes")
        private Integer estimatedBaseCopyTimeInMinutes;
        @JsonProperty(value="allowedTargetRegions")
        private List<String> allowedTargetRegions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder changeRateInMBps(Integer changeRateInMBps) {
            this.changeRateInMBps = changeRateInMBps;
            this.__explicitlySet__.add("changeRateInMBps");
            return this;
        }

        public Builder isReplicationSupported(Boolean isReplicationSupported) {
            this.isReplicationSupported = isReplicationSupported;
            this.__explicitlySet__.add("isReplicationSupported");
            return this;
        }

        public Builder minimumSupportedIntervalInMinutes(Integer minimumSupportedIntervalInMinutes) {
            this.minimumSupportedIntervalInMinutes = minimumSupportedIntervalInMinutes;
            this.__explicitlySet__.add("minimumSupportedIntervalInMinutes");
            return this;
        }

        public Builder estimatedBaseCopyTimeInMinutes(Integer estimatedBaseCopyTimeInMinutes) {
            this.estimatedBaseCopyTimeInMinutes = estimatedBaseCopyTimeInMinutes;
            this.__explicitlySet__.add("estimatedBaseCopyTimeInMinutes");
            return this;
        }

        public Builder allowedTargetRegions(List<String> allowedTargetRegions) {
            this.allowedTargetRegions = allowedTargetRegions;
            this.__explicitlySet__.add("allowedTargetRegions");
            return this;
        }

        public ReplicationEstimate build() {
            ReplicationEstimate model = new ReplicationEstimate(this.changeRateInMBps, this.isReplicationSupported, this.minimumSupportedIntervalInMinutes, this.estimatedBaseCopyTimeInMinutes, this.allowedTargetRegions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReplicationEstimate model) {
            if (model.wasPropertyExplicitlySet("changeRateInMBps")) {
                this.changeRateInMBps(model.getChangeRateInMBps());
            }
            if (model.wasPropertyExplicitlySet("isReplicationSupported")) {
                this.isReplicationSupported(model.getIsReplicationSupported());
            }
            if (model.wasPropertyExplicitlySet("minimumSupportedIntervalInMinutes")) {
                this.minimumSupportedIntervalInMinutes(model.getMinimumSupportedIntervalInMinutes());
            }
            if (model.wasPropertyExplicitlySet("estimatedBaseCopyTimeInMinutes")) {
                this.estimatedBaseCopyTimeInMinutes(model.getEstimatedBaseCopyTimeInMinutes());
            }
            if (model.wasPropertyExplicitlySet("allowedTargetRegions")) {
                this.allowedTargetRegions(model.getAllowedTargetRegions());
            }
            return this;
        }
    }
}

