/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Replication
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="sourceId")
    private final String sourceId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="replicationTargetId")
    private final String replicationTargetId;
    @JsonProperty(value="replicationInterval")
    private final Long replicationInterval;
    @JsonProperty(value="lastSnapshotId")
    private final String lastSnapshotId;
    @JsonProperty(value="recoveryPointTime")
    private final Date recoveryPointTime;
    @JsonProperty(value="deltaStatus")
    private final DeltaStatus deltaStatus;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="deltaProgress")
    private final Long deltaProgress;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "availabilityDomain", "id", "lifecycleState", "displayName", "timeCreated", "sourceId", "targetId", "replicationTargetId", "replicationInterval", "lastSnapshotId", "recoveryPointTime", "deltaStatus", "lifecycleDetails", "deltaProgress", "freeformTags", "definedTags"})
    public Replication(String compartmentId, String availabilityDomain, String id, LifecycleState lifecycleState, String displayName, Date timeCreated, String sourceId, String targetId, String replicationTargetId, Long replicationInterval, String lastSnapshotId, Date recoveryPointTime, DeltaStatus deltaStatus, String lifecycleDetails, Long deltaProgress, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.replicationTargetId = replicationTargetId;
        this.replicationInterval = replicationInterval;
        this.lastSnapshotId = lastSnapshotId;
        this.recoveryPointTime = recoveryPointTime;
        this.deltaStatus = deltaStatus;
        this.lifecycleDetails = lifecycleDetails;
        this.deltaProgress = deltaProgress;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getReplicationTargetId() {
        return this.replicationTargetId;
    }

    public Long getReplicationInterval() {
        return this.replicationInterval;
    }

    public String getLastSnapshotId() {
        return this.lastSnapshotId;
    }

    public Date getRecoveryPointTime() {
        return this.recoveryPointTime;
    }

    public DeltaStatus getDeltaStatus() {
        return this.deltaStatus;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Long getDeltaProgress() {
        return this.deltaProgress;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Replication(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", replicationTargetId=").append(String.valueOf(this.replicationTargetId));
        sb.append(", replicationInterval=").append(String.valueOf(this.replicationInterval));
        sb.append(", lastSnapshotId=").append(String.valueOf(this.lastSnapshotId));
        sb.append(", recoveryPointTime=").append(String.valueOf(this.recoveryPointTime));
        sb.append(", deltaStatus=").append(String.valueOf((Object)this.deltaStatus));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", deltaProgress=").append(String.valueOf(this.deltaProgress));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Replication)) {
            return false;
        }
        Replication other = (Replication)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.replicationTargetId, other.replicationTargetId) && Objects.equals(this.replicationInterval, other.replicationInterval) && Objects.equals(this.lastSnapshotId, other.lastSnapshotId) && Objects.equals(this.recoveryPointTime, other.recoveryPointTime) && Objects.equals((Object)this.deltaStatus, (Object)other.deltaStatus) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.deltaProgress, other.deltaProgress) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.replicationTargetId == null ? 43 : this.replicationTargetId.hashCode());
        result = result * 59 + (this.replicationInterval == null ? 43 : this.replicationInterval.hashCode());
        result = result * 59 + (this.lastSnapshotId == null ? 43 : this.lastSnapshotId.hashCode());
        result = result * 59 + (this.recoveryPointTime == null ? 43 : this.recoveryPointTime.hashCode());
        result = result * 59 + (this.deltaStatus == null ? 43 : this.deltaStatus.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.deltaProgress == null ? 43 : this.deltaProgress.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DeltaStatus implements BmcEnum
    {
        Idle("IDLE"),
        Capturing("CAPTURING"),
        Applying("APPLYING"),
        ServiceError("SERVICE_ERROR"),
        UserError("USER_ERROR"),
        Failed("FAILED"),
        Transferring("TRANSFERRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DeltaStatus> map;

        private DeltaStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeltaStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DeltaStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DeltaStatus.class);
            map = new HashMap<String, DeltaStatus>();
            for (DeltaStatus v : DeltaStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="sourceId")
        private String sourceId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="replicationTargetId")
        private String replicationTargetId;
        @JsonProperty(value="replicationInterval")
        private Long replicationInterval;
        @JsonProperty(value="lastSnapshotId")
        private String lastSnapshotId;
        @JsonProperty(value="recoveryPointTime")
        private Date recoveryPointTime;
        @JsonProperty(value="deltaStatus")
        private DeltaStatus deltaStatus;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="deltaProgress")
        private Long deltaProgress;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder replicationTargetId(String replicationTargetId) {
            this.replicationTargetId = replicationTargetId;
            this.__explicitlySet__.add("replicationTargetId");
            return this;
        }

        public Builder replicationInterval(Long replicationInterval) {
            this.replicationInterval = replicationInterval;
            this.__explicitlySet__.add("replicationInterval");
            return this;
        }

        public Builder lastSnapshotId(String lastSnapshotId) {
            this.lastSnapshotId = lastSnapshotId;
            this.__explicitlySet__.add("lastSnapshotId");
            return this;
        }

        public Builder recoveryPointTime(Date recoveryPointTime) {
            this.recoveryPointTime = recoveryPointTime;
            this.__explicitlySet__.add("recoveryPointTime");
            return this;
        }

        public Builder deltaStatus(DeltaStatus deltaStatus) {
            this.deltaStatus = deltaStatus;
            this.__explicitlySet__.add("deltaStatus");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder deltaProgress(Long deltaProgress) {
            this.deltaProgress = deltaProgress;
            this.__explicitlySet__.add("deltaProgress");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Replication build() {
            Replication model = new Replication(this.compartmentId, this.availabilityDomain, this.id, this.lifecycleState, this.displayName, this.timeCreated, this.sourceId, this.targetId, this.replicationTargetId, this.replicationInterval, this.lastSnapshotId, this.recoveryPointTime, this.deltaStatus, this.lifecycleDetails, this.deltaProgress, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Replication model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("replicationTargetId")) {
                this.replicationTargetId(model.getReplicationTargetId());
            }
            if (model.wasPropertyExplicitlySet("replicationInterval")) {
                this.replicationInterval(model.getReplicationInterval());
            }
            if (model.wasPropertyExplicitlySet("lastSnapshotId")) {
                this.lastSnapshotId(model.getLastSnapshotId());
            }
            if (model.wasPropertyExplicitlySet("recoveryPointTime")) {
                this.recoveryPointTime(model.getRecoveryPointTime());
            }
            if (model.wasPropertyExplicitlySet("deltaStatus")) {
                this.deltaStatus(model.getDeltaStatus());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("deltaProgress")) {
                this.deltaProgress(model.getDeltaProgress());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

