/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MountTargetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="exportSetId")
    private final String exportSetId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="privateIpIds")
    private final List<String> privateIpIds;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "displayName", "exportSetId", "id", "lifecycleState", "privateIpIds", "subnetId", "nsgIds", "timeCreated", "freeformTags", "definedTags"})
    public MountTargetSummary(String availabilityDomain, String compartmentId, String displayName, String exportSetId, String id, LifecycleState lifecycleState, List<String> privateIpIds, String subnetId, List<String> nsgIds, Date timeCreated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.exportSetId = exportSetId;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.privateIpIds = privateIpIds;
        this.subnetId = subnetId;
        this.nsgIds = nsgIds;
        this.timeCreated = timeCreated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExportSetId() {
        return this.exportSetId;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<String> getPrivateIpIds() {
        return this.privateIpIds;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MountTargetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", exportSetId=").append(String.valueOf(this.exportSetId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", privateIpIds=").append(String.valueOf(this.privateIpIds));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MountTargetSummary)) {
            return false;
        }
        MountTargetSummary other = (MountTargetSummary)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.exportSetId, other.exportSetId) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.privateIpIds, other.privateIpIds) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.exportSetId == null ? 43 : this.exportSetId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.privateIpIds == null ? 43 : this.privateIpIds.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="exportSetId")
        private String exportSetId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="privateIpIds")
        private List<String> privateIpIds;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder exportSetId(String exportSetId) {
            this.exportSetId = exportSetId;
            this.__explicitlySet__.add("exportSetId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder privateIpIds(List<String> privateIpIds) {
            this.privateIpIds = privateIpIds;
            this.__explicitlySet__.add("privateIpIds");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public MountTargetSummary build() {
            MountTargetSummary model = new MountTargetSummary(this.availabilityDomain, this.compartmentId, this.displayName, this.exportSetId, this.id, this.lifecycleState, this.privateIpIds, this.subnetId, this.nsgIds, this.timeCreated, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MountTargetSummary model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("exportSetId")) {
                this.exportSetId(model.getExportSetId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("privateIpIds")) {
                this.privateIpIds(model.getPrivateIpIds());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

