/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClientOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="source")
    private final String source;
    @JsonProperty(value="requirePrivilegedSourcePort")
    private final Boolean requirePrivilegedSourcePort;
    @JsonProperty(value="access")
    private final Access access;
    @JsonProperty(value="identitySquash")
    private final IdentitySquash identitySquash;
    @JsonProperty(value="anonymousUid")
    private final Long anonymousUid;
    @JsonProperty(value="anonymousGid")
    private final Long anonymousGid;

    @Deprecated
    @ConstructorProperties(value={"source", "requirePrivilegedSourcePort", "access", "identitySquash", "anonymousUid", "anonymousGid"})
    public ClientOptions(String source, Boolean requirePrivilegedSourcePort, Access access, IdentitySquash identitySquash, Long anonymousUid, Long anonymousGid) {
        this.source = source;
        this.requirePrivilegedSourcePort = requirePrivilegedSourcePort;
        this.access = access;
        this.identitySquash = identitySquash;
        this.anonymousUid = anonymousUid;
        this.anonymousGid = anonymousGid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getRequirePrivilegedSourcePort() {
        return this.requirePrivilegedSourcePort;
    }

    public Access getAccess() {
        return this.access;
    }

    public IdentitySquash getIdentitySquash() {
        return this.identitySquash;
    }

    public Long getAnonymousUid() {
        return this.anonymousUid;
    }

    public Long getAnonymousGid() {
        return this.anonymousGid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientOptions(");
        sb.append("super=").append(super.toString());
        sb.append("source=").append(String.valueOf(this.source));
        sb.append(", requirePrivilegedSourcePort=").append(String.valueOf(this.requirePrivilegedSourcePort));
        sb.append(", access=").append(String.valueOf((Object)this.access));
        sb.append(", identitySquash=").append(String.valueOf((Object)this.identitySquash));
        sb.append(", anonymousUid=").append(String.valueOf(this.anonymousUid));
        sb.append(", anonymousGid=").append(String.valueOf(this.anonymousGid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientOptions)) {
            return false;
        }
        ClientOptions other = (ClientOptions)((Object)o);
        return Objects.equals(this.source, other.source) && Objects.equals(this.requirePrivilegedSourcePort, other.requirePrivilegedSourcePort) && Objects.equals((Object)this.access, (Object)other.access) && Objects.equals((Object)this.identitySquash, (Object)other.identitySquash) && Objects.equals(this.anonymousUid, other.anonymousUid) && Objects.equals(this.anonymousGid, other.anonymousGid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.requirePrivilegedSourcePort == null ? 43 : this.requirePrivilegedSourcePort.hashCode());
        result = result * 59 + (this.access == null ? 43 : this.access.hashCode());
        result = result * 59 + (this.identitySquash == null ? 43 : this.identitySquash.hashCode());
        result = result * 59 + (this.anonymousUid == null ? 43 : this.anonymousUid.hashCode());
        result = result * 59 + (this.anonymousGid == null ? 43 : this.anonymousGid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IdentitySquash implements BmcEnum
    {
        None("NONE"),
        Root("ROOT"),
        All("ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IdentitySquash> map;

        private IdentitySquash(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IdentitySquash create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IdentitySquash', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IdentitySquash.class);
            map = new HashMap<String, IdentitySquash>();
            for (IdentitySquash v : IdentitySquash.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Access implements BmcEnum
    {
        ReadWrite("READ_WRITE"),
        ReadOnly("READ_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Access> map;

        private Access(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Access create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Access', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Access.class);
            map = new HashMap<String, Access>();
            for (Access v : Access.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="requirePrivilegedSourcePort")
        private Boolean requirePrivilegedSourcePort;
        @JsonProperty(value="access")
        private Access access;
        @JsonProperty(value="identitySquash")
        private IdentitySquash identitySquash;
        @JsonProperty(value="anonymousUid")
        private Long anonymousUid;
        @JsonProperty(value="anonymousGid")
        private Long anonymousGid;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder source(String source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder requirePrivilegedSourcePort(Boolean requirePrivilegedSourcePort) {
            this.requirePrivilegedSourcePort = requirePrivilegedSourcePort;
            this.__explicitlySet__.add("requirePrivilegedSourcePort");
            return this;
        }

        public Builder access(Access access) {
            this.access = access;
            this.__explicitlySet__.add("access");
            return this;
        }

        public Builder identitySquash(IdentitySquash identitySquash) {
            this.identitySquash = identitySquash;
            this.__explicitlySet__.add("identitySquash");
            return this;
        }

        public Builder anonymousUid(Long anonymousUid) {
            this.anonymousUid = anonymousUid;
            this.__explicitlySet__.add("anonymousUid");
            return this;
        }

        public Builder anonymousGid(Long anonymousGid) {
            this.anonymousGid = anonymousGid;
            this.__explicitlySet__.add("anonymousGid");
            return this;
        }

        public ClientOptions build() {
            ClientOptions model = new ClientOptions(this.source, this.requirePrivilegedSourcePort, this.access, this.identitySquash, this.anonymousUid, this.anonymousGid);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClientOptions model) {
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("requirePrivilegedSourcePort")) {
                this.requirePrivilegedSourcePort(model.getRequirePrivilegedSourcePort());
            }
            if (model.wasPropertyExplicitlySet("access")) {
                this.access(model.getAccess());
            }
            if (model.wasPropertyExplicitlySet("identitySquash")) {
                this.identitySquash(model.getIdentitySquash());
            }
            if (model.wasPropertyExplicitlySet("anonymousUid")) {
                this.anonymousUid(model.getAnonymousUid());
            }
            if (model.wasPropertyExplicitlySet("anonymousGid")) {
                this.anonymousGid(model.getAnonymousGid());
            }
            return this;
        }
    }
}

