/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.oracle.bmc.filestorage.FileStorage;
import com.oracle.bmc.filestorage.model.ExportSetSummary;
import com.oracle.bmc.filestorage.model.ExportSummary;
import com.oracle.bmc.filestorage.model.FileSystemSummary;
import com.oracle.bmc.filestorage.model.MountTargetSummary;
import com.oracle.bmc.filestorage.model.ReplicationSummary;
import com.oracle.bmc.filestorage.model.ReplicationTargetSummary;
import com.oracle.bmc.filestorage.model.SnapshotSummary;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListReplicationTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListReplicationsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListReplicationTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListReplicationsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FileStoragePaginators {
    private final FileStorage client;

    public FileStoragePaginators(FileStorage client) {
        this.client = client;
    }

    public Iterable<ListExportSetsResponse> listExportSetsResponseIterator(final ListExportSetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExportSetsRequest.Builder>(){

            @Override
            public ListExportSetsRequest.Builder get() {
                return ListExportSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportSetsResponse, String>(){

            @Override
            public String apply(ListExportSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportSetsRequest.Builder>, ListExportSetsRequest>(){

            @Override
            public ListExportSetsRequest apply(RequestBuilderAndToken<ListExportSetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExportSetsRequest, ListExportSetsResponse>(){

            @Override
            public ListExportSetsResponse apply(ListExportSetsRequest request) {
                return FileStoragePaginators.this.client.listExportSets(request);
            }
        });
    }

    public Iterable<ExportSetSummary> listExportSetsRecordIterator(final ListExportSetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExportSetsRequest.Builder>(){

            @Override
            public ListExportSetsRequest.Builder get() {
                return ListExportSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportSetsResponse, String>(){

            @Override
            public String apply(ListExportSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportSetsRequest.Builder>, ListExportSetsRequest>(){

            @Override
            public ListExportSetsRequest apply(RequestBuilderAndToken<ListExportSetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExportSetsRequest, ListExportSetsResponse>(){

            @Override
            public ListExportSetsResponse apply(ListExportSetsRequest request) {
                return FileStoragePaginators.this.client.listExportSets(request);
            }
        }, (Function)new Function<ListExportSetsResponse, List<ExportSetSummary>>(){

            @Override
            public List<ExportSetSummary> apply(ListExportSetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListExportsResponse> listExportsResponseIterator(final ListExportsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExportsRequest.Builder>(){

            @Override
            public ListExportsRequest.Builder get() {
                return ListExportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportsResponse, String>(){

            @Override
            public String apply(ListExportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportsRequest.Builder>, ListExportsRequest>(){

            @Override
            public ListExportsRequest apply(RequestBuilderAndToken<ListExportsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExportsRequest, ListExportsResponse>(){

            @Override
            public ListExportsResponse apply(ListExportsRequest request) {
                return FileStoragePaginators.this.client.listExports(request);
            }
        });
    }

    public Iterable<ExportSummary> listExportsRecordIterator(final ListExportsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExportsRequest.Builder>(){

            @Override
            public ListExportsRequest.Builder get() {
                return ListExportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportsResponse, String>(){

            @Override
            public String apply(ListExportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportsRequest.Builder>, ListExportsRequest>(){

            @Override
            public ListExportsRequest apply(RequestBuilderAndToken<ListExportsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListExportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListExportsRequest, ListExportsResponse>(){

            @Override
            public ListExportsResponse apply(ListExportsRequest request) {
                return FileStoragePaginators.this.client.listExports(request);
            }
        }, (Function)new Function<ListExportsResponse, List<ExportSummary>>(){

            @Override
            public List<ExportSummary> apply(ListExportsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFileSystemsResponse> listFileSystemsResponseIterator(final ListFileSystemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFileSystemsRequest.Builder>(){

            @Override
            public ListFileSystemsRequest.Builder get() {
                return ListFileSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, String>(){

            @Override
            public String apply(ListFileSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFileSystemsRequest.Builder>, ListFileSystemsRequest>(){

            @Override
            public ListFileSystemsRequest apply(RequestBuilderAndToken<ListFileSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFileSystemsRequest, ListFileSystemsResponse>(){

            @Override
            public ListFileSystemsResponse apply(ListFileSystemsRequest request) {
                return FileStoragePaginators.this.client.listFileSystems(request);
            }
        });
    }

    public Iterable<FileSystemSummary> listFileSystemsRecordIterator(final ListFileSystemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFileSystemsRequest.Builder>(){

            @Override
            public ListFileSystemsRequest.Builder get() {
                return ListFileSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, String>(){

            @Override
            public String apply(ListFileSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFileSystemsRequest.Builder>, ListFileSystemsRequest>(){

            @Override
            public ListFileSystemsRequest apply(RequestBuilderAndToken<ListFileSystemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFileSystemsRequest, ListFileSystemsResponse>(){

            @Override
            public ListFileSystemsResponse apply(ListFileSystemsRequest request) {
                return FileStoragePaginators.this.client.listFileSystems(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, List<FileSystemSummary>>(){

            @Override
            public List<FileSystemSummary> apply(ListFileSystemsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMountTargetsResponse> listMountTargetsResponseIterator(final ListMountTargetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMountTargetsRequest.Builder>(){

            @Override
            public ListMountTargetsRequest.Builder get() {
                return ListMountTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, String>(){

            @Override
            public String apply(ListMountTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMountTargetsRequest.Builder>, ListMountTargetsRequest>(){

            @Override
            public ListMountTargetsRequest apply(RequestBuilderAndToken<ListMountTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMountTargetsRequest, ListMountTargetsResponse>(){

            @Override
            public ListMountTargetsResponse apply(ListMountTargetsRequest request) {
                return FileStoragePaginators.this.client.listMountTargets(request);
            }
        });
    }

    public Iterable<MountTargetSummary> listMountTargetsRecordIterator(final ListMountTargetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMountTargetsRequest.Builder>(){

            @Override
            public ListMountTargetsRequest.Builder get() {
                return ListMountTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, String>(){

            @Override
            public String apply(ListMountTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMountTargetsRequest.Builder>, ListMountTargetsRequest>(){

            @Override
            public ListMountTargetsRequest apply(RequestBuilderAndToken<ListMountTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMountTargetsRequest, ListMountTargetsResponse>(){

            @Override
            public ListMountTargetsResponse apply(ListMountTargetsRequest request) {
                return FileStoragePaginators.this.client.listMountTargets(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, List<MountTargetSummary>>(){

            @Override
            public List<MountTargetSummary> apply(ListMountTargetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationTargetsResponse> listReplicationTargetsResponseIterator(final ListReplicationTargetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationTargetsRequest.Builder>(){

            @Override
            public ListReplicationTargetsRequest.Builder get() {
                return ListReplicationTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationTargetsResponse, String>(){

            @Override
            public String apply(ListReplicationTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationTargetsRequest.Builder>, ListReplicationTargetsRequest>(){

            @Override
            public ListReplicationTargetsRequest apply(RequestBuilderAndToken<ListReplicationTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationTargetsRequest, ListReplicationTargetsResponse>(){

            @Override
            public ListReplicationTargetsResponse apply(ListReplicationTargetsRequest request) {
                return FileStoragePaginators.this.client.listReplicationTargets(request);
            }
        });
    }

    public Iterable<ReplicationTargetSummary> listReplicationTargetsRecordIterator(final ListReplicationTargetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationTargetsRequest.Builder>(){

            @Override
            public ListReplicationTargetsRequest.Builder get() {
                return ListReplicationTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationTargetsResponse, String>(){

            @Override
            public String apply(ListReplicationTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationTargetsRequest.Builder>, ListReplicationTargetsRequest>(){

            @Override
            public ListReplicationTargetsRequest apply(RequestBuilderAndToken<ListReplicationTargetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationTargetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationTargetsRequest, ListReplicationTargetsResponse>(){

            @Override
            public ListReplicationTargetsResponse apply(ListReplicationTargetsRequest request) {
                return FileStoragePaginators.this.client.listReplicationTargets(request);
            }
        }, (Function)new Function<ListReplicationTargetsResponse, List<ReplicationTargetSummary>>(){

            @Override
            public List<ReplicationTargetSummary> apply(ListReplicationTargetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationsResponse> listReplicationsResponseIterator(final ListReplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationsRequest.Builder>(){

            @Override
            public ListReplicationsRequest.Builder get() {
                return ListReplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationsResponse, String>(){

            @Override
            public String apply(ListReplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationsRequest.Builder>, ListReplicationsRequest>(){

            @Override
            public ListReplicationsRequest apply(RequestBuilderAndToken<ListReplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationsRequest, ListReplicationsResponse>(){

            @Override
            public ListReplicationsResponse apply(ListReplicationsRequest request) {
                return FileStoragePaginators.this.client.listReplications(request);
            }
        });
    }

    public Iterable<ReplicationSummary> listReplicationsRecordIterator(final ListReplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationsRequest.Builder>(){

            @Override
            public ListReplicationsRequest.Builder get() {
                return ListReplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationsResponse, String>(){

            @Override
            public String apply(ListReplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationsRequest.Builder>, ListReplicationsRequest>(){

            @Override
            public ListReplicationsRequest apply(RequestBuilderAndToken<ListReplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListReplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListReplicationsRequest, ListReplicationsResponse>(){

            @Override
            public ListReplicationsResponse apply(ListReplicationsRequest request) {
                return FileStoragePaginators.this.client.listReplications(request);
            }
        }, (Function)new Function<ListReplicationsResponse, List<ReplicationSummary>>(){

            @Override
            public List<ReplicationSummary> apply(ListReplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSnapshotsResponse> listSnapshotsResponseIterator(final ListSnapshotsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSnapshotsRequest.Builder>(){

            @Override
            public ListSnapshotsRequest.Builder get() {
                return ListSnapshotsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, String>(){

            @Override
            public String apply(ListSnapshotsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSnapshotsRequest.Builder>, ListSnapshotsRequest>(){

            @Override
            public ListSnapshotsRequest apply(RequestBuilderAndToken<ListSnapshotsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSnapshotsRequest, ListSnapshotsResponse>(){

            @Override
            public ListSnapshotsResponse apply(ListSnapshotsRequest request) {
                return FileStoragePaginators.this.client.listSnapshots(request);
            }
        });
    }

    public Iterable<SnapshotSummary> listSnapshotsRecordIterator(final ListSnapshotsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSnapshotsRequest.Builder>(){

            @Override
            public ListSnapshotsRequest.Builder get() {
                return ListSnapshotsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, String>(){

            @Override
            public String apply(ListSnapshotsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSnapshotsRequest.Builder>, ListSnapshotsRequest>(){

            @Override
            public ListSnapshotsRequest apply(RequestBuilderAndToken<ListSnapshotsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSnapshotsRequest, ListSnapshotsResponse>(){

            @Override
            public ListSnapshotsResponse apply(ListSnapshotsRequest request) {
                return FileStoragePaginators.this.client.listSnapshots(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, List<SnapshotSummary>>(){

            @Override
            public List<SnapshotSummary> apply(ListSnapshotsResponse response) {
                return response.getItems();
            }
        });
    }
}

