/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.filestorage.FileStorage;
import com.oracle.bmc.filestorage.FileStorageAsyncClient;
import com.oracle.bmc.filestorage.FileStoragePaginators;
import com.oracle.bmc.filestorage.FileStorageWaiters;
import com.oracle.bmc.filestorage.model.Export;
import com.oracle.bmc.filestorage.model.ExportSet;
import com.oracle.bmc.filestorage.model.ExportSetSummary;
import com.oracle.bmc.filestorage.model.ExportSummary;
import com.oracle.bmc.filestorage.model.FileSystem;
import com.oracle.bmc.filestorage.model.FileSystemSummary;
import com.oracle.bmc.filestorage.model.MountTarget;
import com.oracle.bmc.filestorage.model.MountTargetSummary;
import com.oracle.bmc.filestorage.model.Replication;
import com.oracle.bmc.filestorage.model.ReplicationEstimate;
import com.oracle.bmc.filestorage.model.ReplicationSummary;
import com.oracle.bmc.filestorage.model.ReplicationTarget;
import com.oracle.bmc.filestorage.model.ReplicationTargetSummary;
import com.oracle.bmc.filestorage.model.Snapshot;
import com.oracle.bmc.filestorage.model.SnapshotSummary;
import com.oracle.bmc.filestorage.requests.ChangeFileSystemCompartmentRequest;
import com.oracle.bmc.filestorage.requests.ChangeMountTargetCompartmentRequest;
import com.oracle.bmc.filestorage.requests.ChangeReplicationCompartmentRequest;
import com.oracle.bmc.filestorage.requests.CreateExportRequest;
import com.oracle.bmc.filestorage.requests.CreateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.CreateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.CreateReplicationRequest;
import com.oracle.bmc.filestorage.requests.CreateSnapshotRequest;
import com.oracle.bmc.filestorage.requests.DeleteExportRequest;
import com.oracle.bmc.filestorage.requests.DeleteFileSystemRequest;
import com.oracle.bmc.filestorage.requests.DeleteMountTargetRequest;
import com.oracle.bmc.filestorage.requests.DeleteReplicationRequest;
import com.oracle.bmc.filestorage.requests.DeleteReplicationTargetRequest;
import com.oracle.bmc.filestorage.requests.DeleteSnapshotRequest;
import com.oracle.bmc.filestorage.requests.EstimateReplicationRequest;
import com.oracle.bmc.filestorage.requests.GetExportRequest;
import com.oracle.bmc.filestorage.requests.GetExportSetRequest;
import com.oracle.bmc.filestorage.requests.GetFileSystemRequest;
import com.oracle.bmc.filestorage.requests.GetMountTargetRequest;
import com.oracle.bmc.filestorage.requests.GetReplicationRequest;
import com.oracle.bmc.filestorage.requests.GetReplicationTargetRequest;
import com.oracle.bmc.filestorage.requests.GetSnapshotRequest;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListReplicationTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListReplicationsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportRequest;
import com.oracle.bmc.filestorage.requests.UpdateExportSetRequest;
import com.oracle.bmc.filestorage.requests.UpdateFileSystemRequest;
import com.oracle.bmc.filestorage.requests.UpdateMountTargetRequest;
import com.oracle.bmc.filestorage.requests.UpdateReplicationRequest;
import com.oracle.bmc.filestorage.requests.UpdateSnapshotRequest;
import com.oracle.bmc.filestorage.responses.ChangeFileSystemCompartmentResponse;
import com.oracle.bmc.filestorage.responses.ChangeMountTargetCompartmentResponse;
import com.oracle.bmc.filestorage.responses.ChangeReplicationCompartmentResponse;
import com.oracle.bmc.filestorage.responses.CreateExportResponse;
import com.oracle.bmc.filestorage.responses.CreateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.CreateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.CreateReplicationResponse;
import com.oracle.bmc.filestorage.responses.CreateSnapshotResponse;
import com.oracle.bmc.filestorage.responses.DeleteExportResponse;
import com.oracle.bmc.filestorage.responses.DeleteFileSystemResponse;
import com.oracle.bmc.filestorage.responses.DeleteMountTargetResponse;
import com.oracle.bmc.filestorage.responses.DeleteReplicationResponse;
import com.oracle.bmc.filestorage.responses.DeleteReplicationTargetResponse;
import com.oracle.bmc.filestorage.responses.DeleteSnapshotResponse;
import com.oracle.bmc.filestorage.responses.EstimateReplicationResponse;
import com.oracle.bmc.filestorage.responses.GetExportResponse;
import com.oracle.bmc.filestorage.responses.GetExportSetResponse;
import com.oracle.bmc.filestorage.responses.GetFileSystemResponse;
import com.oracle.bmc.filestorage.responses.GetMountTargetResponse;
import com.oracle.bmc.filestorage.responses.GetReplicationResponse;
import com.oracle.bmc.filestorage.responses.GetReplicationTargetResponse;
import com.oracle.bmc.filestorage.responses.GetSnapshotResponse;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListReplicationTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListReplicationsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportResponse;
import com.oracle.bmc.filestorage.responses.UpdateExportSetResponse;
import com.oracle.bmc.filestorage.responses.UpdateFileSystemResponse;
import com.oracle.bmc.filestorage.responses.UpdateMountTargetResponse;
import com.oracle.bmc.filestorage.responses.UpdateReplicationResponse;
import com.oracle.bmc.filestorage.responses.UpdateSnapshotResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageClient
extends BaseSyncClient
implements FileStorage {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("FILESTORAGE").serviceEndpointPrefix("filestorage").serviceEndpointTemplate("https://filestorage.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageAsyncClient.class);
    private final FileStorageWaiters waiters;
    private final FileStoragePaginators paginators;

    private FileStorageClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("FileStorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new FileStorageWaiters(executorService, this);
        this.paginators = new FileStoragePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeFileSystemCompartmentResponse changeFileSystemCompartment(ChangeFileSystemCompartmentRequest request) {
        Validate.notBlank((String)request.getFileSystemId(), (String)"fileSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFileSystemCompartmentDetails(), "changeFileSystemCompartmentDetails is required");
        return (ChangeFileSystemCompartmentResponse)this.clientCall(request, ChangeFileSystemCompartmentResponse::builder).logger(LOG, "changeFileSystemCompartment").serviceDetails("FileStorage", "ChangeFileSystemCompartment", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/ChangeFileSystemCompartment").method(Method.POST).requestBuilder(ChangeFileSystemCompartmentRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendPathParam(request.getFileSystemId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeFileSystemCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeMountTargetCompartmentResponse changeMountTargetCompartment(ChangeMountTargetCompartmentRequest request) {
        Validate.notBlank((String)request.getMountTargetId(), (String)"mountTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMountTargetCompartmentDetails(), "changeMountTargetCompartmentDetails is required");
        return (ChangeMountTargetCompartmentResponse)this.clientCall(request, ChangeMountTargetCompartmentResponse::builder).logger(LOG, "changeMountTargetCompartment").serviceDetails("FileStorage", "ChangeMountTargetCompartment", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTarget/ChangeMountTargetCompartment").method(Method.POST).requestBuilder(ChangeMountTargetCompartmentRequest::builder).basePath("/20171215").appendPathParam("mountTargets").appendPathParam(request.getMountTargetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeMountTargetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeReplicationCompartmentResponse changeReplicationCompartment(ChangeReplicationCompartmentRequest request) {
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeReplicationCompartmentDetails(), "changeReplicationCompartmentDetails is required");
        return (ChangeReplicationCompartmentResponse)this.clientCall(request, ChangeReplicationCompartmentResponse::builder).logger(LOG, "changeReplicationCompartment").serviceDetails("FileStorage", "ChangeReplicationCompartment", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Replication/ChangeReplicationCompartment").method(Method.POST).requestBuilder(ChangeReplicationCompartmentRequest::builder).basePath("/20171215").appendPathParam("replications").appendPathParam(request.getReplicationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeReplicationCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateExportResponse createExport(CreateExportRequest request) {
        Objects.requireNonNull(request.getCreateExportDetails(), "createExportDetails is required");
        return (CreateExportResponse)this.clientCall(request, CreateExportResponse::builder).logger(LOG, "createExport").serviceDetails("FileStorage", "CreateExport", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Export/CreateExport").method(Method.POST).requestBuilder(CreateExportRequest::builder).basePath("/20171215").appendPathParam("exports").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Export.class, CreateExportResponse.Builder::export).handleResponseHeaderString("etag", CreateExportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest request) {
        Objects.requireNonNull(request.getCreateFileSystemDetails(), "createFileSystemDetails is required");
        return (CreateFileSystemResponse)this.clientCall(request, CreateFileSystemResponse::builder).logger(LOG, "createFileSystem").serviceDetails("FileStorage", "CreateFileSystem", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/CreateFileSystem").method(Method.POST).requestBuilder(CreateFileSystemRequest::builder).basePath("/20171215").appendPathParam("fileSystems").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FileSystem.class, CreateFileSystemResponse.Builder::fileSystem).handleResponseHeaderString("etag", CreateFileSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFileSystemResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest request) {
        Objects.requireNonNull(request.getCreateMountTargetDetails(), "createMountTargetDetails is required");
        return (CreateMountTargetResponse)this.clientCall(request, CreateMountTargetResponse::builder).logger(LOG, "createMountTarget").serviceDetails("FileStorage", "CreateMountTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTarget/CreateMountTarget").method(Method.POST).requestBuilder(CreateMountTargetRequest::builder).basePath("/20171215").appendPathParam("mountTargets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MountTarget.class, CreateMountTargetResponse.Builder::mountTarget).handleResponseHeaderString("etag", CreateMountTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateMountTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateReplicationResponse createReplication(CreateReplicationRequest request) {
        Objects.requireNonNull(request.getCreateReplicationDetails(), "createReplicationDetails is required");
        return (CreateReplicationResponse)this.clientCall(request, CreateReplicationResponse::builder).logger(LOG, "createReplication").serviceDetails("FileStorage", "CreateReplication", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Replication/CreateReplication").method(Method.POST).requestBuilder(CreateReplicationRequest::builder).basePath("/20171215").appendPathParam("replications").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Replication.class, CreateReplicationResponse.Builder::replication).handleResponseHeaderString("etag", CreateReplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateReplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) {
        Objects.requireNonNull(request.getCreateSnapshotDetails(), "createSnapshotDetails is required");
        return (CreateSnapshotResponse)this.clientCall(request, CreateSnapshotResponse::builder).logger(LOG, "createSnapshot").serviceDetails("FileStorage", "CreateSnapshot", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Snapshot/CreateSnapshot").method(Method.POST).requestBuilder(CreateSnapshotRequest::builder).basePath("/20171215").appendPathParam("snapshots").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Snapshot.class, CreateSnapshotResponse.Builder::snapshot).handleResponseHeaderString("etag", CreateSnapshotResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest request) {
        Validate.notBlank((String)request.getExportId(), (String)"exportId must not be blank", (Object[])new Object[0]);
        return (DeleteExportResponse)this.clientCall(request, DeleteExportResponse::builder).logger(LOG, "deleteExport").serviceDetails("FileStorage", "DeleteExport", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Export/DeleteExport").method(Method.DELETE).requestBuilder(DeleteExportRequest::builder).basePath("/20171215").appendPathParam("exports").appendPathParam(request.getExportId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteExportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest request) {
        Validate.notBlank((String)request.getFileSystemId(), (String)"fileSystemId must not be blank", (Object[])new Object[0]);
        return (DeleteFileSystemResponse)this.clientCall(request, DeleteFileSystemResponse::builder).logger(LOG, "deleteFileSystem").serviceDetails("FileStorage", "DeleteFileSystem", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/DeleteFileSystem").method(Method.DELETE).requestBuilder(DeleteFileSystemRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendPathParam(request.getFileSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFileSystemResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest request) {
        Validate.notBlank((String)request.getMountTargetId(), (String)"mountTargetId must not be blank", (Object[])new Object[0]);
        return (DeleteMountTargetResponse)this.clientCall(request, DeleteMountTargetResponse::builder).logger(LOG, "deleteMountTarget").serviceDetails("FileStorage", "DeleteMountTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTarget/DeleteMountTarget").method(Method.DELETE).requestBuilder(DeleteMountTargetRequest::builder).basePath("/20171215").appendPathParam("mountTargets").appendPathParam(request.getMountTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMountTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteReplicationResponse deleteReplication(DeleteReplicationRequest request) {
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        return (DeleteReplicationResponse)this.clientCall(request, DeleteReplicationResponse::builder).logger(LOG, "deleteReplication").serviceDetails("FileStorage", "DeleteReplication", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Replication/DeleteReplication").method(Method.DELETE).requestBuilder(DeleteReplicationRequest::builder).basePath("/20171215").appendPathParam("replications").appendPathParam(request.getReplicationId()).appendEnumQueryParam("deleteMode", (BmcEnum)request.getDeleteMode()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteReplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteReplicationTargetResponse deleteReplicationTarget(DeleteReplicationTargetRequest request) {
        Validate.notBlank((String)request.getReplicationTargetId(), (String)"replicationTargetId must not be blank", (Object[])new Object[0]);
        return (DeleteReplicationTargetResponse)this.clientCall(request, DeleteReplicationTargetResponse::builder).logger(LOG, "deleteReplicationTarget").serviceDetails("FileStorage", "DeleteReplicationTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ReplicationTarget/DeleteReplicationTarget").method(Method.DELETE).requestBuilder(DeleteReplicationTargetRequest::builder).basePath("/20171215").appendPathParam("replicationTargets").appendPathParam(request.getReplicationTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteReplicationTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest request) {
        Validate.notBlank((String)request.getSnapshotId(), (String)"snapshotId must not be blank", (Object[])new Object[0]);
        return (DeleteSnapshotResponse)this.clientCall(request, DeleteSnapshotResponse::builder).logger(LOG, "deleteSnapshot").serviceDetails("FileStorage", "DeleteSnapshot", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Snapshot/DeleteSnapshot").method(Method.DELETE).requestBuilder(DeleteSnapshotRequest::builder).basePath("/20171215").appendPathParam("snapshots").appendPathParam(request.getSnapshotId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EstimateReplicationResponse estimateReplication(EstimateReplicationRequest request) {
        Validate.notBlank((String)request.getFileSystemId(), (String)"fileSystemId must not be blank", (Object[])new Object[0]);
        return (EstimateReplicationResponse)this.clientCall(request, EstimateReplicationResponse::builder).logger(LOG, "estimateReplication").serviceDetails("FileStorage", "EstimateReplication", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/EstimateReplication").method(Method.POST).requestBuilder(EstimateReplicationRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendPathParam(request.getFileSystemId()).appendPathParam("actions").appendPathParam("estimateReplication").appendQueryParam("changeRateInMBps", (Object)request.getChangeRateInMBps()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationEstimate.class, EstimateReplicationResponse.Builder::replicationEstimate).handleResponseHeaderString("etag", EstimateReplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", EstimateReplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetExportResponse getExport(GetExportRequest request) {
        Validate.notBlank((String)request.getExportId(), (String)"exportId must not be blank", (Object[])new Object[0]);
        return (GetExportResponse)this.clientCall(request, GetExportResponse::builder).logger(LOG, "getExport").serviceDetails("FileStorage", "GetExport", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Export/GetExport").method(Method.GET).requestBuilder(GetExportRequest::builder).basePath("/20171215").appendPathParam("exports").appendPathParam(request.getExportId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Export.class, GetExportResponse.Builder::export).handleResponseHeaderString("etag", GetExportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetExportSetResponse getExportSet(GetExportSetRequest request) {
        Validate.notBlank((String)request.getExportSetId(), (String)"exportSetId must not be blank", (Object[])new Object[0]);
        return (GetExportSetResponse)this.clientCall(request, GetExportSetResponse::builder).logger(LOG, "getExportSet").serviceDetails("FileStorage", "GetExportSet", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ExportSet/GetExportSet").method(Method.GET).requestBuilder(GetExportSetRequest::builder).basePath("/20171215").appendPathParam("exportSets").appendPathParam(request.getExportSetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExportSet.class, GetExportSetResponse.Builder::exportSet).handleResponseHeaderString("etag", GetExportSetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExportSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFileSystemResponse getFileSystem(GetFileSystemRequest request) {
        Validate.notBlank((String)request.getFileSystemId(), (String)"fileSystemId must not be blank", (Object[])new Object[0]);
        return (GetFileSystemResponse)this.clientCall(request, GetFileSystemResponse::builder).logger(LOG, "getFileSystem").serviceDetails("FileStorage", "GetFileSystem", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/GetFileSystem").method(Method.GET).requestBuilder(GetFileSystemRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendPathParam(request.getFileSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FileSystem.class, GetFileSystemResponse.Builder::fileSystem).handleResponseHeaderString("etag", GetFileSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFileSystemResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMountTargetResponse getMountTarget(GetMountTargetRequest request) {
        Validate.notBlank((String)request.getMountTargetId(), (String)"mountTargetId must not be blank", (Object[])new Object[0]);
        return (GetMountTargetResponse)this.clientCall(request, GetMountTargetResponse::builder).logger(LOG, "getMountTarget").serviceDetails("FileStorage", "GetMountTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTarget/GetMountTarget").method(Method.GET).requestBuilder(GetMountTargetRequest::builder).basePath("/20171215").appendPathParam("mountTargets").appendPathParam(request.getMountTargetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MountTarget.class, GetMountTargetResponse.Builder::mountTarget).handleResponseHeaderString("etag", GetMountTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMountTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetReplicationResponse getReplication(GetReplicationRequest request) {
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        return (GetReplicationResponse)this.clientCall(request, GetReplicationResponse::builder).logger(LOG, "getReplication").serviceDetails("FileStorage", "GetReplication", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Replication/GetReplication").method(Method.GET).requestBuilder(GetReplicationRequest::builder).basePath("/20171215").appendPathParam("replications").appendPathParam(request.getReplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Replication.class, GetReplicationResponse.Builder::replication).handleResponseHeaderString("etag", GetReplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetReplicationTargetResponse getReplicationTarget(GetReplicationTargetRequest request) {
        Validate.notBlank((String)request.getReplicationTargetId(), (String)"replicationTargetId must not be blank", (Object[])new Object[0]);
        return (GetReplicationTargetResponse)this.clientCall(request, GetReplicationTargetResponse::builder).logger(LOG, "getReplicationTarget").serviceDetails("FileStorage", "GetReplicationTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ReplicationTarget/GetReplicationTarget").method(Method.GET).requestBuilder(GetReplicationTargetRequest::builder).basePath("/20171215").appendPathParam("replicationTargets").appendPathParam(request.getReplicationTargetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ReplicationTarget.class, GetReplicationTargetResponse.Builder::replicationTarget).handleResponseHeaderString("etag", GetReplicationTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetReplicationTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSnapshotResponse getSnapshot(GetSnapshotRequest request) {
        Validate.notBlank((String)request.getSnapshotId(), (String)"snapshotId must not be blank", (Object[])new Object[0]);
        return (GetSnapshotResponse)this.clientCall(request, GetSnapshotResponse::builder).logger(LOG, "getSnapshot").serviceDetails("FileStorage", "GetSnapshot", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Snapshot/GetSnapshot").method(Method.GET).requestBuilder(GetSnapshotRequest::builder).basePath("/20171215").appendPathParam("snapshots").appendPathParam(request.getSnapshotId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Snapshot.class, GetSnapshotResponse.Builder::snapshot).handleResponseHeaderString("etag", GetSnapshotResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListExportSetsResponse listExportSets(ListExportSetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return (ListExportSetsResponse)this.clientCall(request, ListExportSetsResponse::builder).logger(LOG, "listExportSets").serviceDetails("FileStorage", "ListExportSets", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ExportSetSummary/ListExportSets").method(Method.GET).requestBuilder(ListExportSetsRequest::builder).basePath("/20171215").appendPathParam("exportSets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ExportSetSummary.class, ListExportSetsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListExportSetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListExportSetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListExportsResponse listExports(ListExportsRequest request) {
        return (ListExportsResponse)this.clientCall(request, ListExportsResponse::builder).logger(LOG, "listExports").serviceDetails("FileStorage", "ListExports", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ExportSummary/ListExports").method(Method.GET).requestBuilder(ListExportsRequest::builder).basePath("/20171215").appendPathParam("exports").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("exportSetId", (Object)request.getExportSetId()).appendQueryParam("fileSystemId", (Object)request.getFileSystemId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ExportSummary.class, ListExportsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListExportsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListExportsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListFileSystemsResponse listFileSystems(ListFileSystemsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return (ListFileSystemsResponse)this.clientCall(request, ListFileSystemsResponse::builder).logger(LOG, "listFileSystems").serviceDetails("FileStorage", "ListFileSystems", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystemSummary/ListFileSystems").method(Method.GET).requestBuilder(ListFileSystemsRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("sourceSnapshotId", (Object)request.getSourceSnapshotId()).appendQueryParam("parentFileSystemId", (Object)request.getParentFileSystemId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(FileSystemSummary.class, ListFileSystemsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListFileSystemsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListFileSystemsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListMountTargetsResponse listMountTargets(ListMountTargetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return (ListMountTargetsResponse)this.clientCall(request, ListMountTargetsResponse::builder).logger(LOG, "listMountTargets").serviceDetails("FileStorage", "ListMountTargets", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTargetSummary/ListMountTargets").method(Method.GET).requestBuilder(ListMountTargetsRequest::builder).basePath("/20171215").appendPathParam("mountTargets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("exportSetId", (Object)request.getExportSetId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(MountTargetSummary.class, ListMountTargetsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListMountTargetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListMountTargetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListReplicationTargetsResponse listReplicationTargets(ListReplicationTargetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return (ListReplicationTargetsResponse)this.clientCall(request, ListReplicationTargetsResponse::builder).logger(LOG, "listReplicationTargets").serviceDetails("FileStorage", "ListReplicationTargets", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ReplicationTargetSummary/ListReplicationTargets").method(Method.GET).requestBuilder(ListReplicationTargetsRequest::builder).basePath("/20171215").appendPathParam("replicationTargets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ReplicationTargetSummary.class, ListReplicationTargetsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListReplicationTargetsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListReplicationTargetsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListReplicationsResponse listReplications(ListReplicationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        return (ListReplicationsResponse)this.clientCall(request, ListReplicationsResponse::builder).logger(LOG, "listReplications").serviceDetails("FileStorage", "ListReplications", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ReplicationSummary/ListReplications").method(Method.GET).requestBuilder(ListReplicationsRequest::builder).basePath("/20171215").appendPathParam("replications").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("fileSystemId", (Object)request.getFileSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ReplicationSummary.class, ListReplicationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListReplicationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListReplicationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest request) {
        Objects.requireNonNull(request.getFileSystemId(), "fileSystemId is required");
        return (ListSnapshotsResponse)this.clientCall(request, ListSnapshotsResponse::builder).logger(LOG, "listSnapshots").serviceDetails("FileStorage", "ListSnapshots", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/SnapshotSummary/ListSnapshots").method(Method.GET).requestBuilder(ListSnapshotsRequest::builder).basePath("/20171215").appendPathParam("snapshots").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("fileSystemId", (Object)request.getFileSystemId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SnapshotSummary.class, ListSnapshotsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSnapshotsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSnapshotsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest request) {
        Validate.notBlank((String)request.getExportId(), (String)"exportId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExportDetails(), "updateExportDetails is required");
        return (UpdateExportResponse)this.clientCall(request, UpdateExportResponse::builder).logger(LOG, "updateExport").serviceDetails("FileStorage", "UpdateExport", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Export/UpdateExport").method(Method.PUT).requestBuilder(UpdateExportRequest::builder).basePath("/20171215").appendPathParam("exports").appendPathParam(request.getExportId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Export.class, UpdateExportResponse.Builder::export).handleResponseHeaderString("etag", UpdateExportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateExportSetResponse updateExportSet(UpdateExportSetRequest request) {
        Validate.notBlank((String)request.getExportSetId(), (String)"exportSetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExportSetDetails(), "updateExportSetDetails is required");
        return (UpdateExportSetResponse)this.clientCall(request, UpdateExportSetResponse::builder).logger(LOG, "updateExportSet").serviceDetails("FileStorage", "UpdateExportSet", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/ExportSet/UpdateExportSet").method(Method.PUT).requestBuilder(UpdateExportSetRequest::builder).basePath("/20171215").appendPathParam("exportSets").appendPathParam(request.getExportSetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ExportSet.class, UpdateExportSetResponse.Builder::exportSet).handleResponseHeaderString("etag", UpdateExportSetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExportSetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest request) {
        Validate.notBlank((String)request.getFileSystemId(), (String)"fileSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFileSystemDetails(), "updateFileSystemDetails is required");
        return (UpdateFileSystemResponse)this.clientCall(request, UpdateFileSystemResponse::builder).logger(LOG, "updateFileSystem").serviceDetails("FileStorage", "UpdateFileSystem", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/FileSystem/UpdateFileSystem").method(Method.PUT).requestBuilder(UpdateFileSystemRequest::builder).basePath("/20171215").appendPathParam("fileSystems").appendPathParam(request.getFileSystemId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(FileSystem.class, UpdateFileSystemResponse.Builder::fileSystem).handleResponseHeaderString("etag", UpdateFileSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFileSystemResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateMountTargetResponse updateMountTarget(UpdateMountTargetRequest request) {
        Validate.notBlank((String)request.getMountTargetId(), (String)"mountTargetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMountTargetDetails(), "updateMountTargetDetails is required");
        return (UpdateMountTargetResponse)this.clientCall(request, UpdateMountTargetResponse::builder).logger(LOG, "updateMountTarget").serviceDetails("FileStorage", "UpdateMountTarget", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/MountTarget/UpdateMountTarget").method(Method.PUT).requestBuilder(UpdateMountTargetRequest::builder).basePath("/20171215").appendPathParam("mountTargets").appendPathParam(request.getMountTargetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(MountTarget.class, UpdateMountTargetResponse.Builder::mountTarget).handleResponseHeaderString("etag", UpdateMountTargetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMountTargetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateReplicationResponse updateReplication(UpdateReplicationRequest request) {
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateReplicationDetails(), "updateReplicationDetails is required");
        return (UpdateReplicationResponse)this.clientCall(request, UpdateReplicationResponse::builder).logger(LOG, "updateReplication").serviceDetails("FileStorage", "UpdateReplication", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Replication/UpdateReplication").method(Method.PUT).requestBuilder(UpdateReplicationRequest::builder).basePath("/20171215").appendPathParam("replications").appendPathParam(request.getReplicationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Replication.class, UpdateReplicationResponse.Builder::replication).handleResponseHeaderString("etag", UpdateReplicationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateReplicationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest request) {
        Validate.notBlank((String)request.getSnapshotId(), (String)"snapshotId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSnapshotDetails(), "updateSnapshotDetails is required");
        return (UpdateSnapshotResponse)this.clientCall(request, UpdateSnapshotResponse::builder).logger(LOG, "updateSnapshot").serviceDetails("FileStorage", "UpdateSnapshot", "https://docs.oracle.com/iaas/api/#/en/filestorage/20171215/Snapshot/UpdateSnapshot").method(Method.PUT).requestBuilder(UpdateSnapshotRequest::builder).basePath("/20171215").appendPathParam("snapshots").appendPathParam(request.getSnapshotId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Snapshot.class, UpdateSnapshotResponse.Builder::snapshot).handleResponseHeaderString("etag", UpdateSnapshotResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSnapshotResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public FileStorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public FileStoragePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)FileStorageClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(FileStorageClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public FileStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)FileStorageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, FileStorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public FileStorageClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new FileStorageClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

