/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.events.Events;
import com.oracle.bmc.events.EventsAsyncClient;
import com.oracle.bmc.events.EventsPaginators;
import com.oracle.bmc.events.EventsWaiters;
import com.oracle.bmc.events.model.Rule;
import com.oracle.bmc.events.model.RuleSummary;
import com.oracle.bmc.events.requests.ChangeRuleCompartmentRequest;
import com.oracle.bmc.events.requests.CreateRuleRequest;
import com.oracle.bmc.events.requests.DeleteRuleRequest;
import com.oracle.bmc.events.requests.GetRuleRequest;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.requests.UpdateRuleRequest;
import com.oracle.bmc.events.responses.ChangeRuleCompartmentResponse;
import com.oracle.bmc.events.responses.CreateRuleResponse;
import com.oracle.bmc.events.responses.DeleteRuleResponse;
import com.oracle.bmc.events.responses.GetRuleResponse;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.events.responses.UpdateRuleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsClient
extends BaseSyncClient
implements Events {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://events.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EventsAsyncClient.class);
    private final EventsWaiters waiters;
    private final EventsPaginators paginators;

    private EventsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Events-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new EventsWaiters(executorService, this);
        this.paginators = new EventsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeRuleCompartmentResponse changeRuleCompartment(ChangeRuleCompartmentRequest request) {
        Validate.notBlank((String)request.getRuleId(), (String)"ruleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRuleCompartmentDetails(), "changeRuleCompartmentDetails is required");
        return (ChangeRuleCompartmentResponse)this.clientCall(request, ChangeRuleCompartmentResponse::builder).logger(LOG, "changeRuleCompartment").serviceDetails("Events", "ChangeRuleCompartment", "https://docs.oracle.com/iaas/api/#/en/events/20181201/Rule/ChangeRuleCompartment").method(Method.POST).requestBuilder(ChangeRuleCompartmentRequest::builder).basePath("/20181201").appendPathParam("rules").appendPathParam(request.getRuleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRuleCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRuleResponse createRule(CreateRuleRequest request) {
        Objects.requireNonNull(request.getCreateRuleDetails(), "createRuleDetails is required");
        return (CreateRuleResponse)this.clientCall(request, CreateRuleResponse::builder).logger(LOG, "createRule").serviceDetails("Events", "CreateRule", "https://docs.oracle.com/iaas/api/#/en/events/20181201/Rule/CreateRule").method(Method.POST).requestBuilder(CreateRuleRequest::builder).basePath("/20181201").appendPathParam("rules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Rule.class, CreateRuleResponse.Builder::rule).handleResponseHeaderString("etag", CreateRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest request) {
        Validate.notBlank((String)request.getRuleId(), (String)"ruleId must not be blank", (Object[])new Object[0]);
        return (DeleteRuleResponse)this.clientCall(request, DeleteRuleResponse::builder).logger(LOG, "deleteRule").serviceDetails("Events", "DeleteRule", "https://docs.oracle.com/iaas/api/#/en/events/20181201/Rule/DeleteRule").method(Method.DELETE).requestBuilder(DeleteRuleRequest::builder).basePath("/20181201").appendPathParam("rules").appendPathParam(request.getRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRuleResponse getRule(GetRuleRequest request) {
        Validate.notBlank((String)request.getRuleId(), (String)"ruleId must not be blank", (Object[])new Object[0]);
        return (GetRuleResponse)this.clientCall(request, GetRuleResponse::builder).logger(LOG, "getRule").serviceDetails("Events", "GetRule", "https://docs.oracle.com/iaas/api/#/en/events/20181201/Rule/GetRule").method(Method.GET).requestBuilder(GetRuleRequest::builder).basePath("/20181201").appendPathParam("rules").appendPathParam(request.getRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Rule.class, GetRuleResponse.Builder::rule).handleResponseHeaderString("etag", GetRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRulesResponse)this.clientCall(request, ListRulesResponse::builder).logger(LOG, "listRules").serviceDetails("Events", "ListRules", "https://docs.oracle.com/iaas/api/#/en/events/20181201/RuleSummary/ListRules").method(Method.GET).requestBuilder(ListRulesRequest::builder).basePath("/20181201").appendPathParam("rules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(RuleSummary.class, ListRulesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListRulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRulesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRuleResponse updateRule(UpdateRuleRequest request) {
        Validate.notBlank((String)request.getRuleId(), (String)"ruleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRuleDetails(), "updateRuleDetails is required");
        return (UpdateRuleResponse)this.clientCall(request, UpdateRuleResponse::builder).logger(LOG, "updateRule").serviceDetails("Events", "UpdateRule", "https://docs.oracle.com/iaas/api/#/en/events/20181201/Rule/UpdateRule").method(Method.PUT).requestBuilder(UpdateRuleRequest::builder).basePath("/20181201").appendPathParam("rules").appendPathParam(request.getRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Rule.class, UpdateRuleResponse.Builder::rule).handleResponseHeaderString("etag", UpdateRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EventsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public EventsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EventsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EventsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EventsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public EventsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EventsClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

