/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.enforcer.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.ArtifactUtils;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class NoMixedOciJavaSdkVersionsRule
extends AbstractNonCacheableEnforcerRule {
    public static final String BANNED_GROUP_ID = "com.oracle.oci.sdk";
    public static final String BANNED_ARTIFACT_ID_PREFIX = "oci-java-sdk";
    private List<String> allowedDependencies = null;
    private boolean searchTransitive = true;
    private transient DependencyGraphBuilder graphBuilder;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenSession session;
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        try {
            session = (MavenSession)helper.evaluate("${session}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenSession: ", (Exception)((Object)eee));
        }
        try {
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ComponentLookupException cle) {
            throw new EnforcerRuleException("Unable to lookup DependencyGraphBuilder: ", (Exception)((Object)cle));
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setProject(project);
        Set<Artifact> dependencies = this.getDependenciesToCheck(helper, (ProjectBuildingRequest)buildingRequest);
        Map<String, Set<Artifact>> versions = this.checkDependencies(dependencies, helper.getLog());
        if (versions.size() > 1) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message).append(System.lineSeparator());
            }
            buf.append("Multiple different versions of ").append(BANNED_GROUP_ID).append(":").append(BANNED_ARTIFACT_ID_PREFIX).append("* dependencies have been found.").append(System.lineSeparator());
            buf.append("Mixing different versions is not allowedDependencies.").append(System.lineSeparator());
            for (String version : versions.keySet()) {
                buf.append("Using version ").append(version).append(":").append(System.lineSeparator());
                for (Artifact artifact : versions.get(version)) {
                    buf.append('\t').append(artifact.getId()).append(System.lineSeparator());
                }
            }
            buf.append("Use 'mvn dependency:tree' to locate the source of the dependencies with the mixed versions.");
            throw new EnforcerRuleException(buf.toString());
        }
    }

    protected Map<String, Set<Artifact>> checkDependencies(Set<Artifact> dependencies, Log log) throws EnforcerRuleException {
        HashMap<String, Set<Artifact>> versions = new HashMap<String, Set<Artifact>>();
        for (Artifact dependency : dependencies) {
            log.debug((CharSequence)("Checking dependency " + dependency.getId()));
            if (!BANNED_GROUP_ID.equals(dependency.getGroupId())) {
                log.debug((CharSequence)"Ignoring, not groupId com.oracle.oci.sdk");
                continue;
            }
            if (dependency.getArtifactId() == null || !dependency.getArtifactId().startsWith(BANNED_ARTIFACT_ID_PREFIX)) {
                log.debug((CharSequence)"Ignoring, artifactId not prefixed by oci-java-sdk");
                continue;
            }
            if (dependency.getVersion() == null) continue;
            HashSet<Artifact> artifactSet = (HashSet<Artifact>)versions.get(dependency.getVersion());
            if (artifactSet == null) {
                artifactSet = new HashSet<Artifact>();
                versions.put(dependency.getVersion(), artifactSet);
            }
            log.debug((CharSequence)("Recording version " + dependency.getVersion()));
            artifactSet.add(dependency);
        }
        Set ignored = ArtifactUtils.checkDependencies(dependencies, this.allowedDependencies);
        if (ignored != null) {
            log.debug((CharSequence)("Dependencies to ignore found: " + ignored.stream().map(a -> a.getId()).collect(Collectors.joining(", "))));
            Iterator versionsIt = versions.keySet().iterator();
            while (versionsIt.hasNext()) {
                String version = (String)versionsIt.next();
                log.debug((CharSequence)("Checking version" + version));
                Set artifactSet = (Set)versions.get(version);
                if (artifactSet != null) {
                    log.debug((CharSequence)("Artifacts in version " + version + " before: " + artifactSet.stream().map(a -> a.getId()).collect(Collectors.joining(", "))));
                    artifactSet.removeAll(ignored);
                    log.debug((CharSequence)("Artifacts in version " + version + " after: " + artifactSet.stream().map(a -> a.getId()).collect(Collectors.joining(", "))));
                }
                if (artifactSet != null && !artifactSet.isEmpty()) continue;
                log.debug((CharSequence)("Version " + version + " is now empty, removing"));
                versionsIt.remove();
            }
        }
        log.debug((CharSequence)("Different versions found: " + versions.keySet().size() + ": " + versions.keySet()));
        return versions;
    }

    public List<String> getAllowedDependencies() {
        return this.allowedDependencies;
    }

    public void setAllowedDependencies(List<String> allowed) {
        this.allowedDependencies = allowed;
    }

    private Set<Artifact> getDependenciesToCheck(EnforcerRuleHelper helper, ProjectBuildingRequest buildingRequest) {
        String cacheKey = buildingRequest.getProject().getId() + "_" + this.searchTransitive;
        return (Set)helper.getCache(cacheKey, () -> this.getDependenciesToCheck(buildingRequest));
    }

    protected Set<Artifact> getDependenciesToCheck(ProjectBuildingRequest buildingRequest) {
        HashSet dependencies = null;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(buildingRequest, (ArtifactFilter)null);
            if (this.searchTransitive) {
                dependencies = ArtifactUtils.getAllDescendants((DependencyNode)node);
            } else if (node.getChildren() != null) {
                dependencies = new HashSet();
                for (DependencyNode depNode : node.getChildren()) {
                    ((Set)dependencies).add(depNode.getArtifact());
                }
            }
            return dependencies;
        }
        catch (DependencyGraphBuilderException var6) {
            throw new RuntimeException(var6);
        }
    }
}

